/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.optimizers;

import com.ibm.xylem.Function;
import com.ibm.xylem.INewNameGenerator;
import com.ibm.xylem.ISpecialForm;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Optimizer;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.optimizers.OptimizerUtilities;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class RepeatedExpressionOptimizer
extends Optimizer {
    public void optimizeFunction(Function function) {
        s_logger.debug("optimizing " + function.getName());
        Instruction instruction = this.go(function.getBody(), new HashMap(), new PendingRenameOptimizer());
        function.setBody(instruction);
    }

    public Instruction go(Instruction instruction, Map hashMap, PendingRenameOptimizer pendingRenameOptimizer) {
        if (!(instruction instanceof ISpecialForm)) {
            return pendingRenameOptimizer.optimize(instruction);
        }
        if (!(instruction instanceof LetInstruction)) {
            for (int i = 0; i < instruction.getChildInstructionCount(); ++i) {
                instruction.setChildInstruction(i, this.go(instruction.getChildInstruction(i), hashMap, pendingRenameOptimizer));
            }
            return instruction;
        }
        hashMap = new HashMap<ExpressionInfo, ExpressionInfo>(hashMap);
        LinkedList linkedList = new LinkedList();
        Instruction instruction2 = OptimizerUtilities.skipLets(instruction, linkedList);
        LetInstruction letInstruction = null;
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            ExpressionInfo expressionInfo;
            ExpressionInfo expressionInfo2;
            LetInstruction letInstruction2 = (LetInstruction)iterator.next();
            letInstruction2.setValue(this.go(letInstruction2.getValue(), hashMap, pendingRenameOptimizer));
            if (letInstruction2.getValue() instanceof ISpecialForm) {
                letInstruction2.setValue(pendingRenameOptimizer.optimize(letInstruction2.getValue()));
            }
            if ((expressionInfo2 = hashMap.put(expressionInfo = new ExpressionInfo(letInstruction2.getVariable(), letInstruction2.getValue()), expressionInfo)) != null) {
                s_logger.debug("replacing '" + expressionInfo.getIdentifier() + " with " + expressionInfo2.getIdentifier());
                pendingRenameOptimizer.put(expressionInfo.getIdentifier(), expressionInfo2.getIdentifier());
                if (letInstruction != null) {
                    letInstruction.setBody(letInstruction2.getBody());
                }
                hashMap.put(expressionInfo2, expressionInfo2);
                iterator.remove();
                continue;
            }
            letInstruction = letInstruction2;
        }
        instruction2 = this.go(instruction2, hashMap, pendingRenameOptimizer);
        if (linkedList.size() == 0) {
            return instruction2;
        }
        ((LetInstruction)linkedList.getLast()).setBody(instruction2);
        return (Instruction)linkedList.getFirst();
    }

    private static class IdentifierCanonicalizer
    implements INewNameGenerator {
        private int m_id = 0;

        private IdentifierCanonicalizer() {
        }

        public void reset() {
            this.m_id = 0;
        }

        public Object getNewName() {
            return new Integer(++this.m_id);
        }
    }

    private static class PendingRenameOptimizer
    extends Optimizer {
        private Map m_map;

        public PendingRenameOptimizer() {
            this.m_skipStringStreams = true;
            this.m_map = new TransitiveMap();
        }

        public void put(Object object, Object object2) {
            this.m_map.put(object, object2);
        }

        protected Instruction optimizeStep(Instruction instruction) {
            IdentifierInstruction identifierInstruction;
            if (instruction instanceof IdentifierInstruction && this.m_map.containsKey((identifierInstruction = (IdentifierInstruction)instruction).getVariable())) {
                return new IdentifierInstruction(this.m_map.get(identifierInstruction.getVariable()));
            }
            return super.optimizeStep(instruction);
        }
    }

    private static class TransitiveMap
    extends HashMap {
        private static final long serialVersionUID = 7758861528196050459L;

        private TransitiveMap() {
        }

        public Collection values() {
            throw new UnsupportedOperationException();
        }

        public Set entrySet() {
            throw new UnsupportedOperationException();
        }

        public Object get(Object object) {
            Object v = super.get(object);
            while (super.containsKey(v)) {
                v = super.get(v);
            }
            if (v != null) {
                this.put(object, v);
            }
            return v;
        }
    }

    private static class ExpressionInfo {
        private Instruction m_expr;
        private String m_key;
        private String m_canonical;
        private Object m_identifier;

        public ExpressionInfo(Object object, Instruction instruction) {
            this.m_identifier = object;
            this.m_expr = instruction;
        }

        public Object getIdentifier() {
            return this.m_identifier;
        }

        public int hashCode() {
            if (this.m_key == null) {
                this.calcKey();
            }
            return this.m_key.hashCode();
        }

        public boolean equals(Object object) {
            ExpressionInfo expressionInfo = (ExpressionInfo)object;
            if (this.hashCode() != expressionInfo.hashCode()) {
                return false;
            }
            if (this.m_canonical == null) {
                this.calcCanonical();
            }
            if (expressionInfo.m_canonical == null) {
                expressionInfo.calcCanonical();
            }
            return this.m_canonical.equals(expressionInfo.m_canonical);
        }

        private void calcKey() {
            if (!(this.m_expr instanceof ISpecialForm)) {
                this.m_canonical = this.m_key = this.m_expr.toString();
            } else {
                ISpecialForm iSpecialForm = (ISpecialForm)((Object)this.m_expr);
                StringBuffer stringBuffer = new StringBuffer(this.m_expr.getClass().getName());
                for (int i = 0; i < this.m_expr.getChildInstructionCount(); ++i) {
                    if (iSpecialForm.isChildInstructionBody(i)) continue;
                    stringBuffer.append(' ');
                    stringBuffer.append(this.m_expr.getChildInstruction(i).toString());
                }
                this.m_key = stringBuffer.toString();
            }
        }

        private void calcCanonical() {
            this.m_canonical = this.m_expr.assignNewNames(new HashMap(), new IdentifierCanonicalizer()).toString();
        }
    }
}

