/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.optimizers;

import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.NavigationUtilities;
import com.ibm.xylem.Optimizer;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.builders.LetChainBuilder;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.StreamInstruction;
import com.ibm.xylem.types.CharType;
import java.util.LinkedList;
import java.util.List;

public class FlattenStreamOptimizer
extends Optimizer {
    private static final int MIN_STRING_COALESCE_SIZE = 5;
    private static final boolean COLAESCE_STRINGS_CODE = true;
    private static final boolean COLAESCE_STRINGS = true;

    protected void collectStream(StreamInstruction streamInstruction, LinkedList linkedList, LetChainBuilder letChainBuilder, StringBuffer stringBuffer) {
        if (streamInstruction.isString() && stringBuffer != null) {
            stringBuffer.append(streamInstruction.getStringContent());
            return;
        }
        int n = streamInstruction.getChildInstructionCount();
        for (int i = 0; i < n; ++i) {
            Instruction instruction;
            Instruction instruction2 = instruction = streamInstruction.getChildInstruction(i);
            if (instruction instanceof IdentifierInstruction && (instruction2 = NavigationUtilities.resolveReducedIdentifier(instruction, this.getCurrentFunction().m_bindingEnvironment)) == null) {
                instruction2 = instruction;
            }
            if (instruction2 instanceof StreamInstruction) {
                StreamInstruction streamInstruction2 = (StreamInstruction)instruction2;
                this.collectStream(streamInstruction2, linkedList, letChainBuilder, stringBuffer);
                continue;
            }
            if (instruction2 instanceof LiteralInstruction) {
                if (stringBuffer != null) {
                    stringBuffer.append(((Character)((LiteralInstruction)instruction2).getValue()).charValue());
                    continue;
                }
                linkedList.add(instruction2);
                continue;
            }
            this.coalesceString(stringBuffer, linkedList, letChainBuilder);
            linkedList.add(instruction);
        }
    }

    private void coalesceString(StringBuffer stringBuffer, LinkedList linkedList, LetChainBuilder letChainBuilder) {
        if (stringBuffer != null && stringBuffer.length() > 0) {
            if (stringBuffer.length() > 5) {
                linkedList.add(letChainBuilder.bind(StreamInstruction.charStreamLiteral(stringBuffer.toString())));
            } else {
                for (int i = 0; i < stringBuffer.length(); ++i) {
                    linkedList.add(LiteralInstruction.charLiteral(stringBuffer.charAt(i)));
                }
            }
            stringBuffer.setLength(0);
        }
    }

    protected Instruction optimizeStep(Instruction instruction, Instruction instruction2, int n) {
        if (instruction instanceof LetInstruction && ((LetInstruction)instruction).getValue() instanceof StreamInstruction) {
            LetInstruction letInstruction = (LetInstruction)instruction;
            LetChainBuilder letChainBuilder = null;
            letChainBuilder = new LetChainBuilder();
            Instruction instruction3 = this.optimizeStream((StreamInstruction)letInstruction.getValue(), letChainBuilder);
            if (instruction3 == letInstruction.getValue()) {
                return instruction;
            }
            BindingEnvironment bindingEnvironment = this.getCurrentFunction().getBindingEnvironment();
            TypeEnvironment typeEnvironment = this.getCurrentFunction().getTypeEnvironment();
            LinkedList linkedList = new LinkedList();
            letInstruction.setValue(instruction3);
            LetInstruction letInstruction2 = letInstruction = (LetInstruction)letChainBuilder.packageUp(letInstruction);
            while (letInstruction != instruction) {
                letInstruction.getValue().typeCheckReduced(typeEnvironment, bindingEnvironment, linkedList);
                bindingEnvironment.setVariableBinding(letInstruction);
                letInstruction = (LetInstruction)letInstruction.getBody();
            }
            if (instruction2 != null) {
                instruction2.setChildInstruction(n, letInstruction2);
            } else {
                this.getCurrentFunction().setBody(letInstruction2);
            }
        }
        return instruction;
    }

    protected Instruction optimizeStream(StreamInstruction streamInstruction, LetChainBuilder letChainBuilder) {
        Object object;
        if (streamInstruction.isString()) {
            return streamInstruction;
        }
        int n = streamInstruction.getChildInstructionCount();
        if (n == 1) {
            object = streamInstruction.getChildInstruction(0);
            try {
                if (this.resolveType((Instruction)object).equals(this.resolveType(streamInstruction))) {
                    return object;
                }
            }
            catch (NullPointerException nullPointerException) {
                return streamInstruction;
            }
        }
        object = new LinkedList();
        StringBuffer stringBuffer = null;
        if (streamInstruction.getType(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment()).equals(CharType.s_charType.getStreamType())) {
            stringBuffer = new StringBuffer();
        }
        this.collectStream(streamInstruction, (LinkedList)object, letChainBuilder, stringBuffer);
        this.coalesceString(stringBuffer, (LinkedList)object, letChainBuilder);
        StreamInstruction streamInstruction2 = new StreamInstruction(streamInstruction.getElementType(), (List)object);
        return streamInstruction2;
    }
}

