/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.optimizers;

import com.ibm.xylem.Binding;
import com.ibm.xylem.BindingDependencyInfo;
import com.ibm.xylem.Function;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Module;
import com.ibm.xylem.TailRecursiveOptimizer;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.optimizers.DeadLetEliminatorOptimizer;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class DeadParameterEliminatorOptimizer
extends TailRecursiveOptimizer {
    protected Module m_prog;
    protected HashMap m_originalParameterSets;
    protected static final Logger s_logger = Logger.getInstance(class$com$ibm$xylem$optimizers$DeadParameterEliminatorOptimizer == null ? (class$com$ibm$xylem$optimizers$DeadParameterEliminatorOptimizer = DeadParameterEliminatorOptimizer.class$("com.ibm.xylem.optimizers.DeadParameterEliminatorOptimizer")) : class$com$ibm$xylem$optimizers$DeadParameterEliminatorOptimizer);
    boolean m_changed;
    ArrayList m_changedFunctions = new ArrayList();
    static /* synthetic */ Class class$com$ibm$xylem$optimizers$DeadParameterEliminatorOptimizer;

    protected DeadParameterEliminatorOptimizer(Module module, HashMap hashMap) {
        this.m_prog = module;
        this.m_originalParameterSets = hashMap;
    }

    protected Instruction optimizeStep2(Instruction instruction) {
        if (instruction instanceof FunctionCallInstruction) {
            FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction;
            Function function = this.m_prog.getFunction(functionCallInstruction.getFunction());
            Binding[] bindingArray = (Binding[])this.m_originalParameterSets.get(function);
            Function function2 = function.lookupDerivative(class$com$ibm$xylem$optimizers$DeadParameterEliminatorOptimizer == null ? (class$com$ibm$xylem$optimizers$DeadParameterEliminatorOptimizer = DeadParameterEliminatorOptimizer.class$("com.ibm.xylem.optimizers.DeadParameterEliminatorOptimizer")) : class$com$ibm$xylem$optimizers$DeadParameterEliminatorOptimizer);
            if (function2 != null && functionCallInstruction.getChildInstructionCount() != function2.m_parameters.length) {
                ArrayList<Instruction> arrayList = new ArrayList<Instruction>();
                int n = bindingArray.length;
                int n2 = 0;
                for (int i = 0; i < n && n2 < function2.m_parameters.length; ++i) {
                    if (function2.m_parameters[n2] != bindingArray[i]) continue;
                    arrayList.add(functionCallInstruction.getChildInstruction(i));
                    ++n2;
                }
                functionCallInstruction.m_parameters = new Instruction[arrayList.size()];
                arrayList.toArray(functionCallInstruction.m_parameters);
                functionCallInstruction.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList());
                this.m_changed = true;
                return instruction;
            }
        }
        return instruction;
    }

    public void optimizeFunction(Function function) {
        this.m_changed = false;
        super.optimizeFunction(function);
        if (this.m_changed) {
            function.setBody(DeadLetEliminatorOptimizer.eliminateDeadLets(function.getBody(), function));
            this.m_changedFunctions.add(function);
        }
    }

    public static void eliminateDeadParameters(Module module) {
        s_logger.debug("starting dead param elimination");
        BuildFunctionCallGraph buildFunctionCallGraph = new BuildFunctionCallGraph();
        module.optimize(buildFunctionCallGraph);
        HashMap hashMap = buildFunctionCallGraph.m_callers;
        HashMap hashMap2 = new HashMap();
        final HashMap<Object, Binding[]> hashMap3 = new HashMap<Object, Binding[]>();
        ArrayList arrayList = new ArrayList(module.getFunctions());
        while (true) {
            Object object;
            Iterator<Binding> iterator;
            AbstractCollection abstractCollection;
            Object object2;
            Iterator iterator2 = arrayList.iterator();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            while (iterator2.hasNext()) {
                Function function;
                Binding[] bindingArray;
                Instruction[] instructionArray;
                object2 = (Function)iterator2.next();
                if (module.m_signature.containsFunction(((Function)object2).getName())) continue;
                abstractCollection = new ArrayList();
                iterator = new ArrayList();
                object = new ArrayList();
                int n = ((Function)object2).m_parameters.length;
                HashMap hashMap4 = (HashMap)hashMap2.get(((Function)object2).getName());
                if (hashMap4 == null) {
                    hashMap4 = new HashMap();
                    ((Function)object2).determineDataDependencies(((Function)object2).m_parameters, hashMap4);
                    hashMap2.put(((Function)object2).getName(), hashMap4);
                }
                block2: for (int i = 0; i < n; ++i) {
                    instructionArray = (Instruction[])hashMap4.get(((Function)object2).m_parameters[i]);
                    if (instructionArray == null || instructionArray.isEmpty()) continue;
                    bindingArray = instructionArray.iterator();
                    while (bindingArray.hasNext()) {
                        BindingDependencyInfo bindingDependencyInfo = (BindingDependencyInfo)bindingArray.next();
                        if (bindingDependencyInfo.getParent() instanceof FunctionCallInstruction) {
                            FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)bindingDependencyInfo.getParent();
                            int n2 = functionCallInstruction.getChildInstructionIndex(bindingDependencyInfo.m_identifierInstruction);
                            if (n2 == -1) {
                                bindingArray.remove();
                                continue;
                            }
                            if (functionCallInstruction.getFunction().equals(((Function)object2).getName())) continue;
                            ((ArrayList)abstractCollection).add(((Function)object2).m_parameters[i]);
                            continue block2;
                        }
                        ((ArrayList)abstractCollection).add(((Function)object2).m_parameters[i]);
                        continue block2;
                    }
                    if (instructionArray.isEmpty()) continue;
                    ((ArrayList)((Object)iterator)).add(((Function)object2).m_parameters[i]);
                    ((ArrayList)object).add(new LiteralInstruction(((Function)object2).m_parameters[i].getBindingType(), null));
                }
                if (((ArrayList)abstractCollection).size() == n || (function = ((Function)object2).lookupDerivative(class$com$ibm$xylem$optimizers$DeadParameterEliminatorOptimizer == null ? DeadParameterEliminatorOptimizer.class$("com.ibm.xylem.optimizers.DeadParameterEliminatorOptimizer") : class$com$ibm$xylem$optimizers$DeadParameterEliminatorOptimizer)) != null && function.m_parameters.length == ((ArrayList)abstractCollection).size()) continue;
                s_logger.debug("shrinking " + ((Function)object2).getName());
                hashMap3.put(object2, ((Function)object2).m_parameters);
                ((Function)object2).registerDerivative(class$com$ibm$xylem$optimizers$DeadParameterEliminatorOptimizer == null ? DeadParameterEliminatorOptimizer.class$("com.ibm.xylem.optimizers.DeadParameterEliminatorOptimizer") : class$com$ibm$xylem$optimizers$DeadParameterEliminatorOptimizer, (Function)object2);
                ((Function)object2).setMemoizeResult(((Function)object2).getMemoizeResult());
                ((Function)object2).m_parameters = new Binding[((ArrayList)abstractCollection).size()];
                ((ArrayList)abstractCollection).toArray(((Function)object2).m_parameters);
                instructionArray = new Instruction[((ArrayList)object).size()];
                ((ArrayList)object).toArray(instructionArray);
                bindingArray = new Binding[((ArrayList)object).size()];
                ((ArrayList)((Object)iterator)).toArray((Binding[])bindingArray);
                new TailRecursiveOptimizer(){

                    protected Instruction optimizeStep2(Instruction instruction) {
                        FunctionCallInstruction functionCallInstruction;
                        if (instruction instanceof FunctionCallInstruction && (functionCallInstruction = (FunctionCallInstruction)instruction).getFunction().equals(this.m_currentFunction.getOriginalFunction().getName())) {
                            Function function = this.m_currentFunction.getOriginalFunction();
                            Function function2 = this.m_currentFunction;
                            ArrayList<Instruction> arrayList = new ArrayList<Instruction>();
                            Binding[] bindingArray = (Binding[])hashMap3.get(function);
                            int n = bindingArray.length;
                            int n2 = 0;
                            for (int i = 0; i < n && n2 < function2.m_parameters.length; ++i) {
                                if (bindingArray[i] != function2.m_parameters[n2]) continue;
                                arrayList.add(functionCallInstruction.getChildInstruction(i));
                                ++n2;
                            }
                            functionCallInstruction.m_parameters = new Instruction[arrayList.size()];
                            arrayList.toArray(functionCallInstruction.m_parameters);
                            functionCallInstruction.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList());
                            return functionCallInstruction;
                        }
                        return instruction;
                    }
                }.optimizeFunction((Function)object2);
                arrayList2.add(((Function)object2).getName());
                if (function == null) continue;
                function.registerDerivative(class$com$ibm$xylem$optimizers$DeadParameterEliminatorOptimizer == null ? DeadParameterEliminatorOptimizer.class$("com.ibm.xylem.optimizers.DeadParameterEliminatorOptimizer") : class$com$ibm$xylem$optimizers$DeadParameterEliminatorOptimizer, (Function)object2);
            }
            if (arrayList2.size() == 0) {
                s_logger.debug("finished dead param elimination");
                return;
            }
            object2 = new DeadParameterEliminatorOptimizer(module, hashMap3);
            abstractCollection = new HashSet();
            iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                Collection collection = (Collection)hashMap.get(object);
                if (collection == null) continue;
                abstractCollection.addAll(collection);
            }
            iterator = ((HashSet)abstractCollection).iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                ((DeadParameterEliminatorOptimizer)object2).optimizeFunction(module.getFunction((String)object));
            }
            arrayList = ((DeadParameterEliminatorOptimizer)object2).m_changedFunctions;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class BuildFunctionCallGraph
    extends TailRecursiveOptimizer {
        protected HashMap m_callers = new HashMap();

        BuildFunctionCallGraph() {
        }

        protected Instruction optimizeStep2(Instruction instruction) {
            if (instruction instanceof FunctionCallInstruction) {
                FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction;
                HashSet<String> hashSet = (HashSet<String>)this.m_callers.get(functionCallInstruction.getFunction());
                if (hashSet == null) {
                    hashSet = new HashSet<String>();
                    this.m_callers.put(functionCallInstruction.getFunction(), hashSet);
                }
                hashSet.add(this.getCurrentFunction().getName());
            }
            return instruction;
        }
    }
}

