/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.optimizers;

import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.ISpecialForm;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Module;
import com.ibm.xylem.Optimizer;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LetBaseInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.StreamInstruction;
import com.ibm.xylem.utils.XylemError;
import java.util.LinkedList;

public class DeadLetEliminatorOptimizer
extends Optimizer {
    protected int m_eliminatedLetCount;

    public Instruction optimize(Instruction instruction, Function function) {
        this.m_currentFunction = function;
        Instruction instruction2 = this.optimize(instruction);
        this.m_currentFunction = null;
        return instruction2;
    }

    public Instruction optimize(Instruction instruction) {
        if (this.getCurrentFunction().getBindingEnvironment() == null) {
            return instruction;
        }
        this.m_eliminatedLetCount = 0;
        LinkedList<Instruction> linkedList = new LinkedList<Instruction>();
        linkedList.add(instruction);
        this.markUsedLets(this.getCurrentFunction().getBindingEnvironment(), linkedList);
        instruction = super.optimize(instruction);
        return instruction;
    }

    protected void markUsedLets(BindingEnvironment bindingEnvironment, LinkedList linkedList) {
        while (!linkedList.isEmpty()) {
            Instruction instruction;
            Instruction instruction2 = (Instruction)linkedList.removeFirst();
            while (instruction2 instanceof LetInstruction) {
                instruction = (LetInstruction)instruction2;
                ((LetInstruction)instruction).m_inUse = false;
                instruction2 = ((LetBaseInstruction)instruction).getBody();
            }
            if (instruction2 instanceof LiteralInstruction) continue;
            if (instruction2 instanceof IdentifierInstruction) {
                instruction = ((IdentifierInstruction)instruction2).getBinding(bindingEnvironment).getLet();
                if (instruction == null || ((LetInstruction)instruction).m_inUse) continue;
                ((LetInstruction)instruction).m_inUse = true;
                linkedList.add(((LetBaseInstruction)instruction).getValue());
                continue;
            }
            if (instruction2 instanceof StreamInstruction && ((StreamInstruction)(instruction = (StreamInstruction)instruction2)).isStoredAsString()) continue;
            int n = instruction2.getChildInstructionCount();
            ISpecialForm iSpecialForm = instruction2 instanceof ISpecialForm ? (ISpecialForm)((Object)instruction2) : null;
            for (int i = 0; i < n; ++i) {
                Instruction instruction3 = instruction2.getChildInstruction(i);
                if (iSpecialForm != null && iSpecialForm.isChildInstructionBody(i)) {
                    linkedList.add(instruction3);
                    continue;
                }
                if (!(instruction3 instanceof IdentifierInstruction)) continue;
                if (((IdentifierInstruction)instruction3).getBinding(bindingEnvironment) == null) {
                    throw new RuntimeException();
                }
                LetInstruction letInstruction = ((IdentifierInstruction)instruction3).getBinding(bindingEnvironment).getLet();
                if (letInstruction == null || letInstruction.m_inUse) continue;
                letInstruction.m_inUse = true;
                linkedList.add(letInstruction.getValue());
            }
        }
    }

    protected Instruction optimizeStep(Instruction instruction, Instruction instruction2, int n) {
        if (!(instruction instanceof LetInstruction)) {
            return instruction;
        }
        Instruction instruction3 = null;
        LetInstruction letInstruction = (LetInstruction)instruction;
        while (true) {
            if (letInstruction.getBinding() == null) {
                if (instruction2 instanceof LetInstruction) {
                    throw new XylemError("ERR_SYSTEM", "let has null binding (or no dependancy info)" + ((LetInstruction)instruction2).getValue() + " " + letInstruction.getBody() + " " + instruction2.getClass());
                }
                throw new XylemError("ERR_SYSTEM", "let has null binding (or no dependancy info)" + letInstruction.getValue() + " " + letInstruction.getBody() + " " + instruction2.getClass());
            }
            Instruction instruction4 = null;
            if (letInstruction.getBody() instanceof IdentifierInstruction && ((IdentifierInstruction)letInstruction.getBody()).getVariable().equals(letInstruction.getVariable())) {
                ++this.m_eliminatedLetCount;
                instruction4 = letInstruction.getValue();
            } else if (!letInstruction.m_inUse) {
                ++this.m_eliminatedLetCount;
                instruction4 = letInstruction.optimizeOut();
            }
            if (instruction4 != null) {
                if (instruction2 != null) {
                    instruction2.setChildInstruction(n, instruction4);
                } else {
                    instruction3 = instruction4;
                }
                if (!(instruction4 instanceof LetInstruction)) {
                    this.optimizeChildren(instruction4);
                    return instruction3;
                }
                letInstruction = (LetInstruction)instruction4;
                continue;
            }
            Instruction instruction5 = letInstruction.getBody();
            if (!(instruction5 instanceof LetInstruction)) break;
            Instruction instruction6 = letInstruction.getValue();
            Instruction instruction7 = this.optimizeStep(instruction6, letInstruction, 0);
            if (instruction7 == instruction6) {
                this.optimizeChildren(instruction7);
            } else {
                letInstruction.setValue(instruction7);
            }
            instruction2 = letInstruction;
            n = 1;
            letInstruction = (LetInstruction)instruction5;
        }
        this.optimizeChildren(letInstruction);
        return instruction3;
    }

    public static void eliminateDeadLets(Module module) {
        module.optimize(new DeadLetEliminatorOptimizer());
    }

    public static Instruction eliminateDeadLets(Instruction instruction, Function function) {
        DeadLetEliminatorOptimizer deadLetEliminatorOptimizer = new DeadLetEliminatorOptimizer();
        deadLetEliminatorOptimizer.m_currentFunction = function;
        return deadLetEliminatorOptimizer.optimize(instruction);
    }
}

