/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xtq.bcel.generic.BasicType;
import com.ibm.xtq.bcel.generic.InstructionConstants;
import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.UnaryPrimopInstruction;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.types.BigIntegerType;
import com.ibm.xylem.types.DecimalType;
import com.ibm.xylem.types.DoubleType;
import com.ibm.xylem.types.FloatType;
import com.ibm.xylem.types.IntType;
import com.ibm.xylem.types.LongType;
import java.math.BigDecimal;
import java.util.LinkedList;

public class RoundInstruction
extends UnaryPrimopInstruction {
    public RoundInstruction(Instruction instruction) {
        super(instruction);
    }

    public RoundInstruction() {
    }

    public Instruction cloneWithoutTypeInformation() {
        return new RoundInstruction(this.m_operand.cloneWithoutTypeInformation());
    }

    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        return this.setCachedType(this.m_operand.typeCheck(typeEnvironment, bindingEnvironment, linkedList));
    }

    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_operand.getType(typeEnvironment, bindingEnvironment);
    }

    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        String string2 = codeGenerationTracker.generateConventionally(this.m_operand, dataFlowCodeGenerationHelper);
        String string3 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
        Type type = codeGenerationTracker.resolveType(this);
        if (type.equals(IntType.s_intType) || type.equals(FloatType.s_floatType) || type.equals(DoubleType.s_doubleType) || type.equals(LongType.s_longType)) {
            dataFlowCodeGenerationHelper.appendAssignment(string3, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), "Math.round(" + string2 + ")", codeGenerationTracker);
        } else if (type.equals(BigIntegerType.s_bigIntegerType) || type.equals(DecimalType.s_decimalType)) {
            dataFlowCodeGenerationHelper.appendAssignment(string3, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), "new java.math.BigDecimal(Math.round(" + string2 + ".doubleValue()" + "))", codeGenerationTracker);
        } else {
            throw new UnsupportedOperationException("Absolute value not supported for type " + type);
        }
        return string3;
    }

    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        Type type = codeGenerationTracker.resolveType(this);
        if (type.equals(BigIntegerType.s_bigIntegerType) || type.equals(DecimalType.s_decimalType)) {
            instructionListBuilder.appendNew("java.math.BigDecimal");
            instructionListBuilder.appendDUP();
        }
        codeGenerationTracker.generateConventionally(this.m_operand, bCELCodeGenerationHelper, null, instructionListBuilder);
        if (type.equals(IntType.s_intType) || type.equals(LongType.s_longType)) {
            return;
        }
        if (type.equals(FloatType.s_floatType)) {
            instructionListBuilder.appendInvokeStatic("java.lang.Math", "round", IntType.s_intType, type);
            instructionListBuilder.append(InstructionConstants.I2F);
        } else if (type.equals(DoubleType.s_doubleType)) {
            instructionListBuilder.appendInvokeStatic("java.lang.Math", "round", LongType.s_longType, type);
            instructionListBuilder.append(InstructionConstants.L2D);
        } else if (type.equals(BigIntegerType.s_bigIntegerType) || type.equals(DecimalType.s_decimalType)) {
            instructionListBuilder.appendInvokeMethod("java.lang.Number", "doubleValue", BasicType.DOUBLE);
            instructionListBuilder.appendInvokeStatic("java.lang.Math", "round", (com.ibm.xtq.bcel.generic.Type)BasicType.LONG, BasicType.DOUBLE);
            instructionListBuilder.append(InstructionConstants.L2D);
            instructionListBuilder.appendInvokeConstructor("java.math.BigDecimal", BasicType.LONG);
        } else {
            throw new UnsupportedOperationException("Absolute value not supported for type " + type);
        }
    }

    public void toString(PrettyPrinter prettyPrinter, int n) {
        prettyPrinter.newline();
        prettyPrinter.printFormOpen("round", n);
        this.m_operand.toString(prettyPrinter, n + 1);
        prettyPrinter.print(")");
    }

    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        Type type = this.m_operand.evaluateType(function);
        Object object = this.m_operand.evaluate(environment, function, iDebuggerInterceptor, false);
        Object object2 = null;
        if (type.equals(IntType.s_intType) || type.equals(LongType.s_longType)) {
            object2 = object;
        } else if (type.equals(FloatType.s_floatType)) {
            object2 = new Float(Math.round(((Number)object).floatValue()));
        } else if (type.equals(DoubleType.s_doubleType)) {
            object2 = new Double(Math.round(((Number)object).doubleValue()));
        } else if (type.equals(BigIntegerType.s_bigIntegerType) || type.equals(DecimalType.s_decimalType)) {
            object2 = new BigDecimal((double)Math.round(((Number)object).doubleValue()));
        } else {
            throw new UnsupportedOperationException("Absolute value not supported for type " + type);
        }
        return Debugger.leave(iDebuggerInterceptor, this, environment, function, object2);
    }

    public Instruction cloneWithoutTypeInformation(Instruction instruction) {
        return new RoundInstruction(instruction);
    }
}

