/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xylem.Binding;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.FunctionSignature;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Module;
import com.ibm.xylem.ModuleSignature;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.instructions.NaryPrimopInstruction;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.interpreter.IAppendableStream;
import com.ibm.xylem.res.XylemMsg;
import com.ibm.xylem.utils.XylemError;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class ModuleFunctionCallInstruction
extends NaryPrimopInstruction {
    protected String m_function;
    protected String m_module;

    public ModuleFunctionCallInstruction() {
    }

    public ModuleFunctionCallInstruction(String string, String string2, Instruction[] instructionArray) {
        super(instructionArray);
        this.m_module = string;
        this.m_function = string2;
    }

    public ModuleFunctionCallInstruction(String string, String string2, List list) {
        super(list);
        this.m_module = string;
        this.m_function = string2;
    }

    public String getModule() {
        return this.m_module;
    }

    public String getFunction() {
        return this.m_function;
    }

    public void setFunction(String string) {
        this.m_function = string;
    }

    public Instruction[] getParameters() {
        return this.m_parameters;
    }

    public int getParameterCount() {
        return this.m_parameters.length;
    }

    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        FunctionSignature functionSignature = this.resolveFunctionSignature(typeEnvironment);
        if (functionSignature == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Function " + this.m_function + " not found in signature of " + "module " + this.m_module), this);
        }
        if (functionSignature.getParameterTypes().length != this.m_parameters.length) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Incorrect number of parameters to " + this.m_function + " in module " + this.m_module + "\n  expected " + functionSignature.getParameterTypes().length + ", found " + this.m_parameters.length), this);
        }
        TypeEnvironment typeEnvironment2 = new TypeEnvironment(typeEnvironment.getModule());
        HashSet hashSet = new HashSet();
        for (int i = 0; i < this.m_parameters.length; ++i) {
            Type type = this.m_parameters[i].typeCheck(typeEnvironment, bindingEnvironment, linkedList);
            try {
                typeEnvironment2.unify(type.resolveTypeAsMuchAsPossible(typeEnvironment, hashSet), functionSignature.getParameterTypes()[i], this.m_parameters[i]);
                continue;
            }
            catch (TypeCheckException typeCheckException) {
                throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Type error in parameter " + i + " for function " + this.m_function + " of module " + this.m_module + "\n" + typeCheckException.getMessage()), this);
            }
        }
        return this.setCachedType(functionSignature.getReturnType().resolveTypeAsMuchAsPossible(typeEnvironment2, hashSet));
    }

    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        try {
            FunctionSignature functionSignature = this.resolveFunctionSignature(typeEnvironment);
            if (functionSignature == null) {
                s_logger.error("function not resolved for " + this);
                throw new RuntimeException();
            }
            return functionSignature.getReturnType();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException();
        }
    }

    public Instruction cloneWithoutTypeInformation() {
        Instruction[] instructionArray = new Instruction[this.m_parameters.length];
        for (int i = 0; i < instructionArray.length; ++i) {
            instructionArray[i] = this.m_parameters[i].cloneWithoutTypeInformation();
        }
        return new ModuleFunctionCallInstruction(this.m_module, this.m_function, instructionArray);
    }

    public Instruction cloneShallow() {
        Instruction[] instructionArray = (Instruction[])this.m_parameters.clone();
        return new ModuleFunctionCallInstruction(this.m_module, this.m_function, instructionArray);
    }

    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        ModuleFunctionCallInstruction moduleFunctionCallInstruction = (ModuleFunctionCallInstruction)object;
        return moduleFunctionCallInstruction.m_function.equals(this.m_function) && moduleFunctionCallInstruction.m_module.equals(this.m_module);
    }

    protected void generateStaticThisIfNeeded(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, StringBuffer stringBuffer, boolean bl) {
        if (!dataFlowCodeGenerationHelper.getSettings().isMakeAllMethodsStatic()) {
            return;
        }
        stringBuffer.append("__this__");
        if (bl || this.m_parameters.length > 0) {
            stringBuffer.append(", ");
        }
    }

    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        Function function2 = this.resolveFunction(function.getTypeEnvironment());
        Binding[] bindingArray = function2.m_parameters;
        Object[] objectArray = new Object[bindingArray.length];
        for (int i = 0; i < bindingArray.length; ++i) {
            Object object = this.m_parameters[i].evaluate(environment, function, iDebuggerInterceptor, false);
            objectArray[i] = environment.bind(bindingArray[i], object);
        }
        Object object = function2.getBody().evaluate(environment, function2, iDebuggerInterceptor, false);
        for (int i = 0; i < bindingArray.length; ++i) {
            environment.bind(bindingArray[i], objectArray[i]);
        }
        Object object2 = object;
        return Debugger.leave(iDebuggerInterceptor, this, environment, function, object2);
    }

    public void evaluate(IAppendableStream iAppendableStream, Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor) {
        int n;
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        Function function2 = this.resolveFunction(function.getTypeEnvironment());
        Binding[] bindingArray = function2.m_parameters;
        Object[] objectArray = new Object[bindingArray.length];
        for (n = 0; n < bindingArray.length; ++n) {
            Object object = this.m_parameters[n].evaluate(environment, function, iDebuggerInterceptor, false);
            objectArray[n] = environment.bind(bindingArray[n], object);
        }
        function2.getBody().evaluate(iAppendableStream, environment, function2, iDebuggerInterceptor);
        for (n = 0; n < bindingArray.length; ++n) {
            environment.bind(bindingArray[n], objectArray[n]);
        }
        Debugger.leave(iDebuggerInterceptor, this, environment, function, null);
    }

    private Function resolveFunction(TypeEnvironment typeEnvironment) {
        Module module = typeEnvironment.getModule().getProgram().getModule(this.m_module);
        if (module == null) {
            return null;
        }
        return module.getPublicFunction(this.m_function);
    }

    protected FunctionSignature resolveFunctionSignature(TypeEnvironment typeEnvironment) throws TypeCheckException {
        ModuleSignature moduleSignature = typeEnvironment.getModule().getModuleSignature(this.m_module);
        if (moduleSignature == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Module " + this.m_module + " could not be resolved"), this);
        }
        FunctionSignature functionSignature = moduleSignature.getFunctionSignature(this.m_function);
        if (functionSignature == null) {
            throw new XylemError("ERR_SYSTEM", this + " not found in +" + moduleSignature);
        }
        return functionSignature;
    }

    public int hashCode() {
        return super.hashCode() + this.m_function.hashCode();
    }

    public String innerToString() {
        return "call-module-function " + this.m_module + " " + this.m_function;
    }

    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_module = readObjectFileHelper.readString();
        this.m_function = readObjectFileHelper.readString();
    }

    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeString(this.m_module);
        writeObjectFileHelper.writeString(this.m_function);
    }
}

