/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.UnaryPrimopInstruction;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.types.NullableType;
import com.ibm.xylem.types.TypeVariable;
import java.util.LinkedList;

public class GetNonNullValueInstruction
extends UnaryPrimopInstruction {
    protected Type m_elementType;

    public GetNonNullValueInstruction(Instruction instruction) {
        super(instruction);
    }

    public GetNonNullValueInstruction() {
    }

    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        String string2 = this.m_operand.generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, codeGenerationTracker, string, bl);
        if (dataFlowCodeGenerationHelper.isTargetCPP()) {
            dataFlowCodeGenerationHelper.append("if (" + string2 + " == NULL) longjmp(ErrorJmp, -1);\n");
        } else {
            dataFlowCodeGenerationHelper.append("if (" + string2 + " == null) throw new NullPointerException();\n");
        }
        return string2;
    }

    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        throw new UnsupportedOperationException();
    }

    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        TypeVariable typeVariable = new TypeVariable();
        NullableType nullableType = new NullableType(typeVariable);
        typeEnvironment.unify(this.m_operand.typeCheck(typeEnvironment, bindingEnvironment, linkedList), nullableType, this);
        return this.setCachedType(typeVariable);
    }

    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_elementType;
    }

    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        super.generateReducedForm(reductionHelper, instructionArray, bindingEnvironment);
        this.setupType(reductionHelper.m_typeEnvironment, bindingEnvironment);
    }

    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
        super.typeCheckReduced(typeEnvironment, bindingEnvironment, linkedList);
        this.setupType(typeEnvironment, bindingEnvironment);
    }

    protected void setupType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        Type type = this.m_operand.getType(typeEnvironment, bindingEnvironment);
        if (type instanceof NullableType) {
            this.m_elementType = ((NullableType)type).getElementType();
        } else if (this.m_elementType == null) {
            this.m_elementType = new TypeVariable();
            try {
                typeEnvironment.unify(new NullableType(this.m_elementType), this.m_operand.getType(typeEnvironment, bindingEnvironment), this);
            }
            catch (TypeCheckException typeCheckException) {
                typeCheckException.printStackTrace();
            }
        }
    }

    public Instruction cloneWithoutTypeInformation() {
        return new GetNonNullValueInstruction(this.m_operand.cloneWithoutTypeInformation());
    }

    public Instruction cloneWithoutTypeInformation(Instruction instruction) {
        return new GetNonNullValueInstruction(instruction);
    }

    public String innerToString() {
        return "get-non-null-value";
    }

    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        Object object;
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        if ((object = this.m_operand.evaluate(environment, function, iDebuggerInterceptor, false)) == null) {
            throw new NullPointerException();
        }
        return Debugger.leave(iDebuggerInterceptor, this, environment, function, object);
    }
}

