/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import java.io.IOException;
import java.util.LinkedList;

public abstract class BinaryPrimopInstruction
extends Instruction {
    protected Instruction m_operand1;
    protected Instruction m_operand2;

    protected BinaryPrimopInstruction(Instruction instruction, Instruction instruction2) {
        this.m_operand1 = instruction;
        this.m_operand2 = instruction2;
    }

    public BinaryPrimopInstruction() {
    }

    public final Instruction getOperand1() {
        return this.m_operand1;
    }

    public final Instruction getOperand2() {
        return this.m_operand2;
    }

    public final int getChildInstructionCount() {
        return 2;
    }

    public final Instruction getChildInstruction(int n) {
        switch (n) {
            case 0: {
                return this.m_operand1;
            }
            case 1: {
                return this.m_operand2;
            }
        }
        return null;
    }

    public final void setChildInstruction(int n, Instruction instruction) {
        switch (n) {
            case 0: {
                this.m_operand1 = instruction;
                break;
            }
            case 1: {
                this.m_operand2 = instruction;
            }
        }
    }

    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        Instruction instruction = reductionHelper.reduceToBasicInstruction(instructionArray, this.m_operand1, bindingEnvironment);
        Instruction instruction2 = reductionHelper.reduceToBasicInstruction(instructionArray, this.m_operand2, bindingEnvironment);
        instructionArray[0] = this;
        this.m_bindingEnvironment = null;
        this.m_operand1 = instruction;
        this.m_operand2 = instruction2;
    }

    public abstract Instruction cloneWithoutTypeInformation(Instruction var1, Instruction var2);

    public Instruction cloneShallow() {
        return this.cloneWithoutTypeInformation(this.m_operand1, this.m_operand2);
    }

    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        this.m_operand1 = readObjectFileHelper.readInstruction(bindingEnvironment);
        this.m_operand2 = readObjectFileHelper.readInstruction(bindingEnvironment);
    }

    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        writeObjectFileHelper.writeInstruction(this.m_operand1);
        writeObjectFileHelper.writeInstruction(this.m_operand2);
    }

    public Instruction cloneReduced() {
        return this.cloneShallow();
    }

    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
    }
}

