/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.drivers;

import com.ibm.xtq.bcel.classfile.JavaClass;
import com.ibm.xtq.bcel.generic.ArrayType;
import com.ibm.xtq.bcel.generic.ClassGen;
import com.ibm.xtq.bcel.generic.InstructionFactory;
import com.ibm.xtq.bcel.generic.InstructionList;
import com.ibm.xtq.bcel.generic.MethodGen;
import com.ibm.xtq.bcel.generic.Type;
import com.ibm.xylem.AbstractTypeStore;
import com.ibm.xylem.Function;
import com.ibm.xylem.IdentifierConsolidator;
import com.ibm.xylem.LogManager;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Module;
import com.ibm.xylem.ModuleImportDirective;
import com.ibm.xylem.ModuleLinker;
import com.ibm.xylem.ModuleSignature;
import com.ibm.xylem.ModuleSignatureStore;
import com.ibm.xylem.Optimizer;
import com.ibm.xylem.PolymorphicADTDesugarer;
import com.ibm.xylem.Program;
import com.ibm.xylem.codegen.CodeGenerationSettings;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.JavaC;
import com.ibm.xylem.codegen.StreamOptimizationStyle;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.ClassCollector;
import com.ibm.xylem.codegen.bcel.ClassGenerationHelper;
import com.ibm.xylem.codegen.bcel.Resource;
import com.ibm.xylem.commandline.CommandLineParserMultipleInputFile;
import com.ibm.xylem.drivers.IXylemDriver;
import com.ibm.xylem.optimizers.DeadLetEliminatorOptimizer;
import com.ibm.xylem.optimizers.SplitFunctions;
import com.ibm.xylem.optimizers.TerminalLetOptimizer;
import com.ibm.xylem.optimizers.partialeval.PartialEvaluationOptimizer;
import com.ibm.xylem.types.StreamType;
import com.ibm.xylem.utils.XylemError;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class Linker
implements IXylemDriver {
    static final boolean SHOW_CPP_RESULT = false;
    static final Logger s_logger;
    public ModuleSignatureStore m_mss;
    public File m_outputDir = new File(".").getAbsoluteFile();
    public boolean m_isPerf;
    public boolean m_dumpXylem;
    public boolean m_dumpIntermediateXylem;
    public CodeGenerationSettings m_codeGenerationSettings = new CodeGenerationSettings();
    static /* synthetic */ Class class$com$ibm$xylem$drivers$Linker;

    protected void optimize(Module module, Function function) {
    }

    public static void main(String[] stringArray) {
        Linker linker;
        CLP cLP = new CLP();
        cLP.m_linker = linker = new Linker();
        if (!cLP.parseCommandLine(stringArray)) {
            System.exit(-1);
        }
        try {
            cLP.m_signatureSearchPath.addFirst(new File(".").toURL());
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        linker.m_mss = new ModuleSignatureStore(cLP.m_signatureSearchPath);
        linker.m_dumpXylem = linker.m_codeGenerationSettings.m_dumpxylem;
        linker.m_dumpIntermediateXylem = cLP.m_dumpIntermediateXylem;
        linker.m_isPerf = cLP.m_isPerf;
        try {
            File file = linker.linkFiles(cLP.m_files, cLP.m_className, null, null, 1);
            if (file != null && !linker.m_codeGenerationSettings.getJavaCSettings().isJavaCDisabled()) {
                JavaC.compile(file.getParentFile(), new String[]{file.getName()}, linker.m_outputDir, null, linker.m_codeGenerationSettings.getJavaCSettings());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public File linkFiles(List list, String string, String string2, Collection collection, int n) {
        LinkedList<Module> linkedList = new LinkedList<Module>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            URL uRL = (URL)iterator.next();
            s_logger.info("linking " + uRL.getPath());
            try {
                Module module = Module.loadCompiled(uRL, this.m_mss);
                linkedList.add(module);
            }
            catch (Exception exception) {
                s_logger.error("!", exception);
                throw new Error();
            }
        }
        return this.linkModules(linkedList, string, string2, collection, n);
    }

    public File linkModules(List list, String string, String string2, Collection collection, int n) {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        Program program = null;
        Iterator iterator = list.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            serializable = (Module)iterator.next();
            if (!(serializable instanceof Program)) continue;
            if (program != null) {
                s_logger.warn("Program conflict noted: " + ((AbstractTypeStore)((Object)serializable)).getName() + " dominates over " + program.getName());
            }
            program = (Program)serializable;
        }
        if (program == null) {
            serializable = new ModuleSignature("");
            program = new Program((ModuleSignature)serializable);
        } else {
            bl = true;
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            program.addModule((Module)iterator.next());
        }
        if (bl) {
            ModuleLinker.reflattenModules(program);
        } else {
            ModuleLinker.flattenModules(program);
        }
        program.expandTypeAliases();
        serializable = null;
        Object object4 = null;
        iterator = list.iterator();
        while (iterator.hasNext()) {
            object3 = (Module)iterator.next();
            s_logger.info("checking " + ((AbstractTypeStore)object3).getName());
            if (serializable != null || (serializable = program.getFunction(ModuleImportDirective.translateFunctionName("main", (Module)object3))) == null) continue;
            object4 = object3;
            break;
        }
        if (object4 == null) {
            s_logger.error("no primary module found");
            return null;
        }
        object3 = null;
        if (serializable != null) {
            object3 = ModuleImportDirective.translateFunctionName("main", object4);
            program.forceFunctionGeneration(program.getFunction((String)object3));
        }
        if (collection != null) {
            object2 = collection.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                program.forceFunctionGeneration(program.getFunction((String)object));
            }
        }
        if (this.m_dumpIntermediateXylem) {
            s_logger.info("Dumping pre-optimization Xylem code");
            if (string == null) {
                string = ((AbstractTypeStore)object4).getName();
            }
            Program.dumpXylemFile(program, this.m_outputDir, string + ".preopt");
        }
        try {
            program.typeCheckReduced();
            program.removeDeadFunctions();
            program.instantiateReducedPolymorphicFunctions();
            program.removeDeadFunctions();
            this.desugar(program);
            if (string == null) {
                string = ((AbstractTypeStore)object4).getName();
            }
            program.setClassName(string);
            program.removeDeadFunctions();
            object2 = new HashSet();
            object2.add(string + "$main");
            object = new IdentifierConsolidator();
            Object object5 = new PartialEvaluationOptimizer((Set)object2);
            ((PartialEvaluationOptimizer)object5).m_ic = object;
            program.optimize((Optimizer)object5);
            object5 = new PartialEvaluationOptimizer((Set)object2);
            ((PartialEvaluationOptimizer)object5).m_ic = object;
            program.optimize((Optimizer)object5);
            program.optimize(new TerminalLetOptimizer());
            if (this.m_codeGenerationSettings.getPostReductionSplitLimit() > 0) {
                program.optimize(new SplitFunctions((Module)program, this.m_codeGenerationSettings.getPostReductionSplitLimit()));
                DeadLetEliminatorOptimizer.eliminateDeadLets(program);
            }
            this.optimize(program, (Function)serializable);
            if (this.m_dumpXylem) {
                s_logger.info("Dumping Xylem code to " + new File(this.m_outputDir, string));
                Program.dumpXylemFile(program, this.m_outputDir, string);
            }
            switch (this.m_codeGenerationSettings.getTargetLanguage()) {
                case 1: {
                    boolean bl2;
                    object2 = new StringWriter();
                    object = new File(this.m_outputDir, string + ".java");
                    object5 = new FileWriter((File)object);
                    PrintWriter printWriter = new PrintWriter((Writer)object5);
                    if (string2 != null) {
                        printWriter.write("package " + string2 + ";\n");
                    }
                    printWriter.write("final public class " + string + " extends " + string + "_Partition0 {\n");
                    DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper = new DataFlowCodeGenerationHelper(string, this.m_codeGenerationSettings);
                    if (this.m_codeGenerationSettings.isMultiPartitionOutput()) {
                        dataFlowCodeGenerationHelper.m_basePath = this.m_outputDir;
                    }
                    program.generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, (Writer)printWriter, (Writer)object2);
                    boolean bl3 = bl2 = ((Function)serializable).getReturnType() instanceof StreamType && ((Function)serializable).getBody().supportsCodeGenerationOptimization(StreamOptimizationStyle.s_streamOptimizationStyle, ((Function)serializable).getTypeEnvironment(), ((Function)serializable).getBindingEnvironment());
                    if (serializable != null) {
                        boolean bl4;
                        boolean bl5 = bl4 = ((Function)serializable).m_parameters.length == 1;
                        if (bl2) {
                            printWriter.write("private char[] m_reusableBuffer = new char[32768];\n");
                        }
                        printWriter.write("public static void main(String[] argv) {\n" + string + " instance = new " + string + "();\n");
                        printWriter.write("try {\n");
                        if (this.m_isPerf) {
                            printWriter.write("  if ((argv.length > 0) && (argv[0].equals(\"--help\"))) {\n");
                            printWriter.write("    System.out.println(\"Two args:  [priming-runs] [timing-runs]\");\n");
                            printWriter.write("    System.out.println(\"One arg:   [timing-runs]\");\n");
                            printWriter.write("    System.out.println(\"Defaults:  priming-runs=0 timing-runs=1\");\n");
                            printWriter.write("    return;\n");
                            printWriter.write("  }\n");
                            printWriter.write("  int primingRuns = 0;\n");
                            printWriter.write("  int timingRuns = 1;\n");
                            printWriter.write("  if (argv.length > 1) {primingRuns = Integer.parseInt(argv[0]); timingRuns = Integer.parseInt(argv[1]);}\n");
                            printWriter.write("  if (argv.length == 1) {timingRuns = Integer.parseInt(argv[0]);}\n");
                            if (bl4) {
                                printWriter.write("  String[] tmp = argv;\n");
                                printWriter.write("  argv = new String[tmp.length-2];\n");
                                printWriter.write("  System.arraycopy(tmp,2,argv,0,argv.length);\n");
                            }
                            printWriter.write("  // first time, print output\n");
                            if (bl2) {
                                printWriter.write("instance.m_reusableBuffer = ");
                                printWriter.write(string + "." + Function.generateFunctionName(dataFlowCodeGenerationHelper, (String)object3));
                                printWriter.write("$stream(instance" + (bl4 ? ", argv" : "") + ", instance.m_reusableBuffer, 0);\n");
                                printWriter.write("System.out.println(new String(instance.m_reusableBuffer,0,instance.m_tls_stream_size));\n");
                            } else {
                                printWriter.write("  if (timingRuns > 0) System.out.println(" + string + "." + Function.generateFunctionName(dataFlowCodeGenerationHelper, (String)object3) + "(instance" + (bl4 ? ", argv" : "") + "));\n");
                            }
                            printWriter.write("  // priming runs\n");
                            printWriter.write("  for (int i = 1 ; i < primingRuns ; i++) {\n");
                            if (bl2) {
                                printWriter.write("instance.m_reusableBuffer = ");
                                printWriter.write(string + "." + Function.generateFunctionName(dataFlowCodeGenerationHelper, (String)object3));
                                printWriter.write("$stream(instance" + (bl4 ? ", argv" : "") + ", instance.m_reusableBuffer, 0);\n");
                            } else {
                                printWriter.write("    " + string + "." + Function.generateFunctionName(dataFlowCodeGenerationHelper, (String)object3) + "(instance" + (bl4 ? ", argv" : "") + ");\n");
                            }
                            printWriter.write("  }\n");
                            printWriter.write("  if (primingRuns > 0) System.err.println(\"Finished \" + primingRuns + \" priming runs...\");\n");
                            printWriter.write("  System.err.println(\"Starting timing runs...\");\n");
                            printWriter.write("  long start = System.currentTimeMillis();\n");
                            printWriter.write("  for (int i = 0 ; i < timingRuns ; i++) {\n");
                            if (bl2) {
                                printWriter.write("instance.m_reusableBuffer = ");
                                printWriter.write(string + "." + Function.generateFunctionName(dataFlowCodeGenerationHelper, (String)object3));
                                printWriter.write("$stream(instance" + (bl4 ? ", argv" : "") + ", instance.m_reusableBuffer, 0);\n");
                            } else {
                                printWriter.write("    " + string + "." + Function.generateFunctionName(dataFlowCodeGenerationHelper, (String)object3) + "(instance" + (bl4 ? ", argv" : "") + ");\n");
                            }
                            printWriter.write("  }\n");
                            printWriter.write("  long stop = System.currentTimeMillis();\n");
                            printWriter.write("  System.err.println(\"timing: \" + timingRuns + \" runs took \" + (stop-start) + \" milliseconds.\");\n");
                        } else {
                            if (bl4) {
                                printWriter.write("  String[] tmp = argv;\n");
                                printWriter.write("  argv = new String[tmp.length-2];\n");
                                printWriter.write("  System.arraycopy(tmp,2,argv,0,argv.length);\n");
                            }
                            if (bl2) {
                                printWriter.write("instance.m_reusableBuffer = ");
                                printWriter.write(string + "." + Function.generateFunctionName(dataFlowCodeGenerationHelper, (String)object3));
                                printWriter.write("$stream(instance" + (bl4 ? ", argv" : "") + ", instance.m_reusableBuffer, 0);\n");
                                printWriter.write("System.out.println(new String(instance.m_reusableBuffer,0,instance.m_tls_stream_size));\n");
                            } else {
                                printWriter.write("  System.out.println(" + string + "." + Function.generateFunctionName(dataFlowCodeGenerationHelper, (String)object3) + "(instance" + (bl4 ? ", argv" : "") + "));\n");
                            }
                        }
                        printWriter.write("} catch (Throwable t) { t.printStackTrace(); throw new Error();}\n");
                        printWriter.write("} \n");
                    }
                    printWriter.write("public static final void __xylem_postStatic() {}\n");
                    printWriter.write("\n}\n");
                    printWriter.write(((StringWriter)object2).toString());
                    printWriter.flush();
                    printWriter.close();
                    return object;
                }
                case 2: {
                    object2 = new ClassCollector(){

                        public void acceptGeneratedClass(JavaClass javaClass) {
                            try {
                                javaClass.dump(new File(Linker.this.m_outputDir, javaClass.getClassName() + ".class"));
                            }
                            catch (IOException iOException) {
                                s_logger.error("I/O error", iOException);
                            }
                        }

                        public void acceptGeneratedResource(Resource resource) {
                            try {
                                FileOutputStream fileOutputStream = new FileOutputStream(new File(Linker.this.m_outputDir, resource.getName()));
                                resource.dump(fileOutputStream);
                                fileOutputStream.close();
                            }
                            catch (IOException iOException) {
                                s_logger.error("I/O error", iOException);
                            }
                        }
                    };
                    object = new BCELCodeGenerationHelper(string + "_Common", "java.lang.Object", this.m_codeGenerationSettings, (ClassCollector)object2);
                    program.generateCode((BCELCodeGenerationHelper)object);
                    object5 = new ClassGenerationHelper(new ClassGen(string, string + "_Common", "<generated>", 33, null));
                    InstructionList instructionList = new InstructionList();
                    MethodGen methodGen = new MethodGen(25, Type.VOID, new Type[]{new ArrayType(Type.STRING, 1)}, new String[]{"argv"}, "main", string, instructionList, ((ClassGenerationHelper)object5).m_cpg);
                    instructionList.append(InstructionFactory.createReturn(Type.VOID));
                    ((ClassGenerationHelper)object5).addDefaultConstructor((BCELCodeGenerationHelper)object, null);
                    ((BCELCodeGenerationHelper)object).addMethodToClass(methodGen, (ClassGenerationHelper)object5);
                    ((ClassCollector)object2).acceptGeneratedClass(((ClassGenerationHelper)object5).m_cg.getJavaClass());
                    return null;
                }
                case 3: {
                    object2 = new File(this.m_outputDir, string + ".cpp");
                    object = new FileWriter((File)object2);
                    object5 = new PrintWriter((Writer)object);
                    ((Writer)object).write("#include <stdlib.h>\n");
                    ((Writer)object).write("#include <string.h>\n");
                    ((Writer)object).write("#include <stdio.h>\n");
                    ((Writer)object).write("#include <memory.h>\n");
                    ((Writer)object).write("#include <setjmp.h>\n");
                    ((Writer)object).write("extern \"C\" {\n#include \"nballoc.h\"\n}\n");
                    ((Writer)object).write("#include \"PEXPParse.h\"\n");
                    ((Writer)object).write("#define LENGTH(x) (((int*)x)[-1])\n");
                    ((Writer)object).write("#define NEW_ARRAY(x,len) ((x*) __newArray(sizeof(x), len))\n");
                    ((Writer)object).write("void* __newArray(int size, int len) { int* buf = ((int*) malloc(size * len + sizeof(int))) + 1; LENGTH(buf) = len; return buf; }\n");
                    ((Writer)object).write("char* __makeStringConstant(char* buf) { int len = strlen(buf); char* x = (char*) __newArray(sizeof(char), len); memcpy(x, buf, len); return x; }\n");
                    StringWriter stringWriter = new StringWriter();
                    DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper = new DataFlowCodeGenerationHelper(string, this.m_codeGenerationSettings);
                    program.generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, (Writer)object5, stringWriter);
                    ((Writer)object).write("static int __xylem_postStatic() {return 0;}\n");
                    ((Writer)object).write("int main(int argc, char **argv) {\n");
                    if (dataFlowCodeGenerationHelper.isTargetCPP()) {
                        ((Writer)object).write("nballoc_init();\n");
                        dataFlowCodeGenerationHelper.flushStaticBuffer((Writer)object5);
                    }
                    ((Writer)object).write("  if ( setjmp(ErrorJmp) == 0 ) {\n");
                    ((Writer)object).write("puts(" + Function.generateFunctionName(dataFlowCodeGenerationHelper, (String)object3) + "((argc < 2) ? NULL : &argv[1]));\n");
                    ((Writer)object).write("  } else { fprintf (stderr, \"Runtime Exception!!\"); return -1; }\n");
                    ((Writer)object).write("  return 0; }\n");
                    ((Writer)object).write(stringWriter.toString());
                    ((OutputStreamWriter)object).close();
                    return object2;
                }
            }
            throw new XylemError("ERR_SYSTEM", "Unsupported target language");
        }
        catch (Throwable throwable) {
            s_logger.error("Error occurred during linking", throwable);
            return null;
        }
    }

    protected void desugar(Program program) {
        new PolymorphicADTDesugarer(program).desugar();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        LogManager.initializeLogger();
        s_logger = Logger.getInstance(class$com$ibm$xylem$drivers$Linker == null ? (class$com$ibm$xylem$drivers$Linker = Linker.class$("com.ibm.xylem.drivers.Linker")) : class$com$ibm$xylem$drivers$Linker);
    }

    public static class CLP
    extends CommandLineParserMultipleInputFile {
        public Linker m_linker;
        public String m_className;
        public boolean m_dumpIntermediateXylem = false;
        public boolean m_isPerf = false;
        public String m_pkgName = null;

        protected int parseOption(String[] stringArray, int n) {
            if (stringArray[n].equals("-help") || stringArray[n].equals("-?") || stringArray[n].equals("-h")) {
                System.out.println("Usage: Linker\n\t[-classname name]\n\t[-packagename name]\n\t[-dumpIntermediateXylem]\n\t[-d outputDir]");
                this.m_linker.m_codeGenerationSettings.parseOption(stringArray, n);
                super.parseOption(stringArray, n);
                System.out.println("Input files should be *.cxo");
                return -1;
            }
            if (stringArray[n].equals("-classname")) {
                if (++n == stringArray.length) {
                    s_logger.error("-classname missing parameter");
                    return -1;
                }
                this.m_className = stringArray[n];
                return n;
            }
            if (stringArray[n].equals("-packagename")) {
                if (++n == stringArray.length) {
                    s_logger.error("-packagename missing parameter");
                    return -1;
                }
                this.m_pkgName = stringArray[n];
                return n;
            }
            if (stringArray[n].equals("-javac")) {
                s_logger.info("-javac is now default; use -disablejavac to suppress");
                return n;
            }
            if (stringArray[n].equals("-dumpIntermediateXylem")) {
                this.m_dumpIntermediateXylem = true;
                return n;
            }
            if (stringArray[n].equals("-d")) {
                if (++n == stringArray.length) {
                    s_logger.error("-d missing parameter");
                    return -1;
                }
                this.m_linker.m_outputDir = new File(stringArray[n]).getAbsoluteFile();
                return n;
            }
            if (stringArray[n].equals("-perf")) {
                this.m_isPerf = true;
                return n;
            }
            int n2 = this.m_linker.m_codeGenerationSettings.parseOption(stringArray, n);
            if (n2 == -1) {
                return -1;
            }
            if (n2 != -2) {
                return n2;
            }
            return super.parseOption(stringArray, n);
        }
    }
}

