/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.drivers;

import com.ibm.xylem.AbstractTypeStore;
import com.ibm.xylem.FunctionSignature;
import com.ibm.xylem.LogManager;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Module;
import com.ibm.xylem.ModuleSignature;
import com.ibm.xylem.ModuleSignatureStore;
import com.ibm.xylem.Optimizer;
import com.ibm.xylem.commandline.CommandLineParserMultipleInputFile;
import com.ibm.xylem.commandline.SearchPathSourceResolver;
import com.ibm.xylem.drivers.IXylemDriver;
import com.ibm.xylem.optimizers.VDTMapOptimizer;
import com.ibm.xylem.parser.Parser;
import com.ibm.xylem.parser.ParserSource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Compiler
implements IXylemDriver {
    static final Logger s_logger;
    public ModuleSignatureStore m_mss;
    public File m_outputDir = new File(".").getAbsoluteFile();
    static /* synthetic */ Class class$com$ibm$xylem$drivers$Compiler;

    public static void main(String[] stringArray) {
        CLP cLP = new CLP();
        Compiler compiler = cLP.m_compiler = new Compiler();
        if (!cLP.parseCommandLine(stringArray)) {
            System.exit(-1);
        }
        try {
            cLP.m_signatureSearchPath.addFirst(new File(".").toURL());
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        compiler.m_mss = new ModuleSignatureStore(cLP.m_signatureSearchPath);
        try {
            List list = compiler.compileFiles(cLP, null, true, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public List compileFiles(CLP cLP, Collection collection, boolean bl, boolean bl2) {
        LinkedList<Module> linkedList = new LinkedList<Module>();
        Iterator iterator = cLP.m_files.iterator();
        while (iterator.hasNext()) {
            URL uRL = (URL)iterator.next();
            s_logger.info("compiling " + uRL.getPath());
            try {
                Module module = this.handleFile(uRL, cLP, bl);
                if (!bl2) continue;
                linkedList.add(module);
            }
            catch (Exception exception) {
                s_logger.error("!", exception);
                throw new Error();
            }
        }
        return bl2 ? linkedList : null;
    }

    protected Module handleFile(URL uRL, CLP cLP, boolean bl) {
        String string = uRL.toString();
        if (string.endsWith(".xylem")) {
            String string2;
            Object object;
            ModuleSignature moduleSignature = null;
            try {
                object = uRL.getPath();
                object = ((String)object).substring(((String)object).lastIndexOf("/") + 1);
                moduleSignature = this.m_mss.resolveModuleSignature(((String)object).substring(0, ((String)object).length() - 6));
            }
            catch (Exception exception) {
                s_logger.error("Error reading compiled interface file", exception);
                System.exit(-1);
            }
            object = null;
            try {
                object = this.compile(uRL, moduleSignature, cLP.m_signatureSearchPath, this.m_mss);
            }
            catch (Exception exception) {
                s_logger.error("Error occurred during compilation of " + uRL, exception);
                System.exit(-1);
            }
            if (((AbstractTypeStore)object).getName().equals("")) {
                string2 = uRL.getPath();
                string2 = string2.substring(string2.lastIndexOf("/") + 1);
                ((AbstractTypeStore)object).setName(string2);
            }
            if (((AbstractTypeStore)object).getName().endsWith(".xylem")) {
                string2 = ((AbstractTypeStore)object).getName();
                string2 = string2.substring(0, string2.lastIndexOf(".xylem"));
                ((AbstractTypeStore)object).setName(string2);
            }
            if (bl) {
                Object object2;
                string2 = ((AbstractTypeStore)object).getName() + ".cxo";
                try {
                    object2 = new File(string2);
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream((File)object2));
                    Module.writeModule(objectOutputStream, (Module)object);
                    objectOutputStream.flush();
                    objectOutputStream.close();
                }
                catch (Exception exception) {
                    s_logger.error("Error occurred writing of compiled module to " + string2, exception);
                    System.exit(-1);
                }
                object2 = ModuleSignatureStore.makeFilename(((AbstractTypeStore)object).getName()) + ".cxi";
                Compiler.writeOutSignature(((Module)object).m_signature, (String)object2);
            }
            return object;
        }
        if (string.endsWith(".xylemi")) {
            ModuleSignature moduleSignature = null;
            try {
                moduleSignature = Compiler.compileSignature(uRL, cLP.m_signatureSearchPath, this.m_mss);
            }
            catch (Exception exception) {
                s_logger.error("Error occurred during compilation of signature " + uRL, exception);
                System.exit(-1);
            }
            if (bl) {
                String string3 = ModuleSignatureStore.makeFilename(moduleSignature.getName()) + ".cxi";
                Compiler.writeOutSignature(moduleSignature, string3);
            }
            return null;
        }
        s_logger.warn("Ignoring file with unrecognized extension: " + uRL);
        return null;
    }

    public Module compile(URL uRL, ModuleSignature moduleSignature, List list, ModuleSignatureStore moduleSignatureStore) throws Exception {
        return this.compile(moduleSignature, new Parser(new SearchPathSourceResolver(list), new ParserSource(uRL), moduleSignatureStore));
    }

    public Module compile(ModuleSignature moduleSignature, Parser parser) throws Exception {
        Object object;
        Module module = parser.parseModule(moduleSignature);
        if (moduleSignature == null) {
            module.exportAllSymbols();
        }
        module.typeCheck();
        if (moduleSignature == null) {
            object = new HashSet(module.m_signature.m_functionSignatures.keySet()).iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                module.m_signature.addFunctionSignature(new FunctionSignature(module.getFunction(string)));
            }
        }
        module.reduce();
        if (module.getVDTMap() != null) {
            object = new VDTMapOptimizer(module.getVDTMap());
            module.optimize((Optimizer)object);
            ((VDTMapOptimizer)object).doUpdate(module);
            object = null;
        }
        return module;
    }

    public static final ModuleSignature compileSignature(URL uRL, List list, ModuleSignatureStore moduleSignatureStore) throws Exception {
        ParserSource parserSource = new ParserSource(uRL);
        Parser parser = new Parser(new SearchPathSourceResolver(list), parserSource, moduleSignatureStore);
        return Compiler.compileSignature(uRL, parser);
    }

    public static final ModuleSignature compileSignature(URL uRL, Parser parser) throws Exception {
        ParserSource parserSource = new ParserSource(uRL);
        ModuleSignature moduleSignature = parser.parseExternalModuleSignature(parserSource);
        return moduleSignature;
    }

    public static final void writeOutSignature(ModuleSignature moduleSignature, String string) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(string));
            moduleSignature.write(objectOutputStream);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            s_logger.error("Error occurred writing of compiled signature to " + string, exception);
            System.exit(-1);
        }
    }

    public static final void writeOutSignature(ModuleSignature moduleSignature, String string, File file) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(new File(file, string)));
            moduleSignature.write(objectOutputStream);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            s_logger.error("Error occurred writing of compiled signature to " + string, exception);
            System.exit(-1);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        LogManager.initializeLogger();
        s_logger = Logger.getInstance(class$com$ibm$xylem$drivers$Compiler == null ? (class$com$ibm$xylem$drivers$Compiler = Compiler.class$("com.ibm.xylem.drivers.Compiler")) : class$com$ibm$xylem$drivers$Compiler);
    }

    public static class CLP
    extends CommandLineParserMultipleInputFile {
        public Compiler m_compiler;

        protected int parseOption(String[] stringArray, int n) {
            if (stringArray[n].equals("-help") || stringArray[n].equals("-?") || stringArray[n].equals("-h")) {
                System.out.println("Usage: Compiler");
                super.parseOption(stringArray, n);
                System.out.println("Input files should be be *.xylem or *.xylemi");
                return -1;
            }
            return super.parseOption(stringArray, n);
        }
    }
}

