/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.commandline;

import com.ibm.xylem.LogManager;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Module;
import com.ibm.xylem.ModuleSignatureStore;
import com.ibm.xylem.commandline.CommandLineParserSingleInputFile;
import com.ibm.xylem.commandline.XylemC;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;

public class XylemP
extends CommandLineParserSingleInputFile {
    static final Logger s_logger;
    private static final int XYLEM = 0;
    private static final int XYLEMQ = 1;
    private static final int XYLEMML = 2;
    private static int m_language;
    private ArrayList m_files = new ArrayList();
    private File m_outputDir = null;
    private PrintWriter m_currentPrintWriter = null;
    static /* synthetic */ Class class$com$ibm$xylem$commandline$XylemP;
    static /* synthetic */ Class class$com$ibm$xylem$Module;
    static /* synthetic */ Class class$java$io$PrintStream;

    protected int parseOption(String[] stringArray, int n) {
        if (stringArray[n].equals("-help") || stringArray[n].equals("-?") || stringArray[n].equals("-h")) {
            System.out.println("Usage: XylemP [-q] [-ml] [-I searchpath] [-output dirname] (file.cxo)*");
            return -1;
        }
        if ("-q".equals(stringArray[n])) {
            m_language = 1;
            return n;
        }
        if ("-ml".equals(stringArray[n])) {
            m_language = 2;
            return n;
        }
        if ("-output".equals(stringArray[n]) || "--output".equals(stringArray[n])) {
            if (++n == stringArray.length) {
                XylemC.s_logger.error("-output missing parameter");
                return -1;
            }
            this.m_outputDir = new File(stringArray[n]);
            if (!this.m_outputDir.exists() || !this.m_outputDir.isDirectory()) {
                XylemC.s_logger.error("Directory " + this.m_outputDir + " does not exist");
                return -1;
            }
            return n;
        }
        this.m_inputFile = this.validateInputFilename(stringArray[n], false);
        if (this.m_inputFile == null) {
            return -1;
        }
        this.m_files.add(this.m_inputFile);
        return n;
    }

    public static void main(String[] stringArray) {
        new XylemP(stringArray);
    }

    public XylemP(String[] stringArray) {
        if (!this.parseCommandLine(stringArray)) {
            return;
        }
        try {
            this.m_signatureSearchPath.addFirst(new File(".").toURL());
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        ModuleSignatureStore moduleSignatureStore = new ModuleSignatureStore(this.m_signatureSearchPath);
        Iterator iterator = this.m_files.iterator();
        while (iterator.hasNext()) {
            URL uRL = (URL)iterator.next();
            this.m_signatureSearchPath.addFirst(uRL);
            try {
                String string = new File(uRL.getPath()).getName();
                string = string.substring(0, string.lastIndexOf(".cxo"));
                Module module = Module.loadCompiled(uRL, moduleSignatureStore);
                switch (m_language) {
                    case 0: {
                        this.println(string, module.toString());
                        if (!iterator.hasNext()) break;
                        this.println(null, ";; ============================================");
                        break;
                    }
                    case 2: {
                        s_logger.error("XylemML output not supported.");
                        throw new Error("XylemML output not supported.");
                    }
                    case 1: {
                        try {
                            Class<?> clazz = Class.forName("com.ibm.xylem.xylemq.parser.QPrettyPrint");
                            Method method = clazz.getMethod("printModule", class$com$ibm$xylem$Module == null ? XylemP.class$("com.ibm.xylem.Module") : class$com$ibm$xylem$Module, class$java$io$PrintStream == null ? XylemP.class$("java.io.PrintStream") : class$java$io$PrintStream);
                            if (null != this.m_outputDir) {
                                File file = new File(this.m_outputDir, string + ".xylemq");
                                PrintStream printStream = new PrintStream(new FileOutputStream(file));
                                method.invoke(null, module, printStream);
                                break;
                            }
                            method.invoke(null, module, System.out);
                            if (iterator.hasNext()) {
                                this.println(null, "// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-");
                            }
                            break;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            s_logger.error("Can't do XylemQ pretty print without QPrettyPrint");
                            throw new Error("Can't do XylemQ pretty print without QPrettyPrint");
                        }
                    }
                }
            }
            catch (Exception exception) {
                s_logger.error("Error converting CXO to Module", exception);
                throw new Error("Error converting CXO to Module");
            }
            this.m_signatureSearchPath.removeFirst();
        }
    }

    private void println(String string, String string2) {
        if (null != this.m_outputDir) {
            if (null == this.m_currentPrintWriter) {
                try {
                    File file = new File(this.m_outputDir, string + ".xylem");
                    s_logger.debug("Dumping program to file " + file);
                    FileWriter fileWriter = new FileWriter(file);
                    this.m_currentPrintWriter = new PrintWriter(fileWriter);
                    this.m_currentPrintWriter.write(string2);
                    this.m_currentPrintWriter.close();
                    this.m_currentPrintWriter = null;
                }
                catch (IOException iOException) {
                    s_logger.error("i/o error", iOException);
                }
            }
        } else {
            System.out.println(string2);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        LogManager.initializeLogger();
        s_logger = Logger.getInstance(class$com$ibm$xylem$commandline$XylemP == null ? (class$com$ibm$xylem$commandline$XylemP = XylemP.class$("com.ibm.xylem.commandline.XylemP")) : class$com$ibm$xylem$commandline$XylemP);
        m_language = 0;
    }
}

