/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.commandline;

import com.ibm.xylem.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CommandLineParser {
    static final Logger s_logger = Logger.getInstance(class$com$ibm$xylem$commandline$CommandLineParser == null ? (class$com$ibm$xylem$commandline$CommandLineParser = CommandLineParser.class$("com.ibm.xylem.commandline.CommandLineParser")) : class$com$ibm$xylem$commandline$CommandLineParser);
    public LinkedList m_signatureSearchPath = new LinkedList();
    static /* synthetic */ Class class$com$ibm$xylem$commandline$CommandLineParser;

    public static String removeExtension(File file) {
        String string = file.getAbsolutePath();
        String string2 = file.getName();
        int n = string2.length();
        int n2 = string2.lastIndexOf(46);
        if (n2 != -1 && n2 < n - 1) {
            return string.substring(0, n2 += string.length() - n);
        }
        return string;
    }

    public static List separatePath(String string) {
        int n = string.length();
        char c = File.pathSeparatorChar;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                if (stringBuffer.length() <= 0) continue;
                arrayList.add(stringBuffer.toString());
                continue;
            }
            stringBuffer.append(c2);
        }
        if (stringBuffer.length() > 0) {
            arrayList.add(stringBuffer.toString());
        }
        return arrayList;
    }

    protected boolean handleCommandOption(String string) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string2;
            stringArray = this.validateInputFilename(string, false);
            if (stringArray == null) {
                return false;
            }
            InputStreamReader inputStreamReader = new InputStreamReader(stringArray.openStream());
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                if ((string2 = string2.trim()).length() <= 0) continue;
                arrayList.add(string2);
            }
            bufferedReader.close();
            inputStreamReader.close();
        }
        catch (Exception exception) {
            s_logger.error("Error reading command file " + string, exception);
            return false;
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            int n = this.parseOption(stringArray, i);
            if (n == -1) {
                return false;
            }
            i = n;
        }
        return true;
    }

    protected int parseOption(String[] stringArray, int n) {
        boolean bl;
        boolean bl2 = bl = n == stringArray.length - 1;
        if (stringArray[n].equals("-help") || stringArray[n].equals("-?") || stringArray[n].equals("-h")) {
            System.out.println("\t[-command commandfile]\n\t[-I signature_search_directory]");
            return -1;
        }
        if ("-I".equals(stringArray[n])) {
            if (bl) {
                s_logger.error("-I missing parameter");
                return -1;
            }
            Iterator iterator = CommandLineParser.separatePath(stringArray[++n]).iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                File file = new File(string);
                if (!file.exists() || !file.isDirectory()) {
                    s_logger.warn("Directory " + string + " not found; ignoring");
                    continue;
                }
                try {
                    this.m_signatureSearchPath.add(file.toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    s_logger.warn("Unexpected failure converting directory " + string + " to URL; ignoring.");
                }
            }
        } else {
            return -2;
        }
        return n;
    }

    public URL validateInputFilename(String string, boolean bl) {
        URL uRL;
        if (string.startsWith("classpath:")) {
            return this.getClass().getClassLoader().getResource(string.substring(10));
        }
        File file = new File(string);
        if (!(bl || file.exists() && !file.isDirectory() && file.canRead())) {
            s_logger.error("Cannot find or access input file " + string);
            return null;
        }
        try {
            uRL = file.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            s_logger.error("File cannot be put into URL form: " + string);
            return null;
        }
        return uRL;
    }

    public boolean parseCommandLine(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            int n = this.parseOption(stringArray, i);
            if (n == -1) {
                return false;
            }
            if (n == -2) {
                s_logger.warn("Unrecognized command line token: " + stringArray[i]);
                n = i;
            }
            i = n;
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

