/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.annot.meta;

import com.ibm.xylem.Binding;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Type;
import com.ibm.xylem.annot.AnnotationEnvironment;
import com.ibm.xylem.annot.AnnotationTable;
import com.ibm.xylem.annot.ConversionEngine;
import com.ibm.xylem.annot.IAnnotation;
import com.ibm.xylem.annot.meta.MetaAnnotation;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LambdaInstruction;
import com.ibm.xylem.types.LambdaType;
import com.ibm.xylem.utils.XylemError;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public abstract class LambdaMetaAnnotation
extends MetaAnnotation {
    private LambdaType m_type;
    private IBinding[] m_modelBindings;
    protected HashSet m_applications = new HashSet();
    protected AnnotationTable m_table;
    private static int s_kNumber = 0;

    public static LambdaMetaAnnotation newA(LambdaInstruction lambdaInstruction, AnnotationTable annotationTable, AnnotationEnvironment annotationEnvironment) {
        return new Base(lambdaInstruction, annotationTable, annotationEnvironment);
    }

    LambdaMetaAnnotation(LambdaType lambdaType, IBinding[] iBindingArray, AnnotationTable annotationTable) {
        this.m_type = lambdaType;
        this.m_modelBindings = iBindingArray;
        this.m_table = annotationTable;
    }

    public IAnnotation clonePassthru() {
        return new Passthru(this, this);
    }

    public IAnnotation cloneAsFunctionParam() {
        return new Passthru(null, this);
    }

    public boolean propagateDependanciesTo(MetaAnnotation metaAnnotation) {
        if (!(metaAnnotation instanceof LambdaMetaAnnotation)) {
            throw new XylemError("ERR_SYSTEM", "?" + metaAnnotation);
        }
        return ((LambdaMetaAnnotation)metaAnnotation).m_applications.addAll(this.m_applications);
    }

    public IAnnotation analyzeApplication(IAnnotation[] iAnnotationArray, AnnotationEnvironment annotationEnvironment, ArrayList arrayList, ArrayList arrayList2) {
        ApplicationKey applicationKey = new ApplicationKey(iAnnotationArray, annotationEnvironment);
        ApplicationKey applicationKey2 = (ApplicationKey)this.m_table.getGlobalInfo(applicationKey);
        if (applicationKey2 == null) {
            applicationKey2 = applicationKey;
            this.m_table.addGlobalInfo(applicationKey2, applicationKey2);
        }
        this.m_applications.add(applicationKey2);
        this.propagateDependanciesToBase();
        return applicationKey2.returnVal;
    }

    protected String getVarName(Object object, ApplicationKey applicationKey) {
        return object + "$lambda" + applicationKey.kNumber;
    }

    public Instruction getIdentifier(IAnnotation[] iAnnotationArray) {
        ApplicationKey applicationKey = new ApplicationKey(iAnnotationArray, null);
        applicationKey = (ApplicationKey)this.m_table.getGlobalInfo(applicationKey);
        return new IdentifierInstruction(this.getVarName(this.getVariable(), applicationKey));
    }

    public List getBindingList(Object object, IAnnotation iAnnotation, ConversionEngine conversionEngine) {
        ArrayList<Binding> arrayList = new ArrayList<Binding>(this.m_applications.size());
        Iterator iterator = this.m_applications.iterator();
        while (iterator.hasNext()) {
            ApplicationKey applicationKey = (ApplicationKey)iterator.next();
            arrayList.add(new Binding((Object)this.getVarName(object, applicationKey), this.getLambdaType(applicationKey, conversionEngine)));
        }
        return arrayList;
    }

    protected Type getLambdaType(ApplicationKey applicationKey, ConversionEngine conversionEngine) {
        Binding[] bindingArray = conversionEngine.convertParamBindings(applicationKey.params, this.m_modelBindings);
        Type[] typeArray = new Type[bindingArray.length];
        for (int i = 0; i < bindingArray.length; ++i) {
            typeArray[i] = bindingArray[i].getBindingType();
        }
        return new LambdaType(typeArray, conversionEngine.convertType(applicationKey.returnVal, this.m_type.getReturnType()), this.m_type.isPure());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof LambdaMetaAnnotation)) {
            return false;
        }
        return this.m_type.equals(((LambdaMetaAnnotation)object).m_type);
    }

    public String toString() {
        return "(LambdaAnnot " + this.m_type + ")";
    }

    static /* synthetic */ int access$708() {
        return s_kNumber++;
    }

    private class ApplicationKey {
        private IAnnotation[] params;
        private AnnotationEnvironment env;
        private IAnnotation returnVal;
        private int kNumber = LambdaMetaAnnotation.access$708();

        private ApplicationKey(IAnnotation[] iAnnotationArray, AnnotationEnvironment annotationEnvironment) {
            this.params = iAnnotationArray;
            this.env = annotationEnvironment;
        }

        public int hashCode() {
            return LambdaMetaAnnotation.this.m_type.hashCode();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof ApplicationKey)) {
                return false;
            }
            ApplicationKey applicationKey = (ApplicationKey)object;
            if (applicationKey.params.length != this.params.length) {
                return false;
            }
            for (int i = 0; i < this.params.length; ++i) {
                if (this.params[i] == null && applicationKey.params[i] != null) {
                    return false;
                }
                if (this.params[i] == null || this.params[i].equals(applicationKey.params[i])) continue;
                return false;
            }
            return true;
        }
    }

    private static class Passthru
    extends LambdaMetaAnnotation {
        private MetaAnnotation m_base;

        public Passthru(MetaAnnotation metaAnnotation, LambdaMetaAnnotation lambdaMetaAnnotation) {
            super(lambdaMetaAnnotation.m_type, lambdaMetaAnnotation.m_modelBindings, lambdaMetaAnnotation.m_table);
            this.m_base = metaAnnotation;
        }

        public void propagateDependanciesToBase() {
            if (this.m_base != null) {
                this.propagateDependancies(this.m_base);
            }
        }

        public void insertAnnotationOperation(IAnnotation iAnnotation, AnnotationEnvironment annotationEnvironment, ConversionEngine conversionEngine) {
            this.insertPassthru(this, this.m_base, annotationEnvironment, conversionEngine);
        }
    }

    private static class Base
    extends LambdaMetaAnnotation {
        private AnnotationEnvironment m_enclosingEnvironment;
        private LambdaInstruction m_lambda;

        public Base(LambdaInstruction lambdaInstruction, AnnotationTable annotationTable, AnnotationEnvironment annotationEnvironment) {
            super((LambdaType)lambdaInstruction.getType(annotationEnvironment.getTypeEnvironment(), annotationEnvironment.getBindingEnvironment()), lambdaInstruction.getChildInstructionBindings(0), annotationTable);
            this.m_lambda = lambdaInstruction;
            this.m_enclosingEnvironment = annotationEnvironment;
        }

        public void propagateDependanciesToBase() {
            Iterator iterator = this.m_applications.iterator();
            while (iterator.hasNext()) {
                ApplicationKey applicationKey = (ApplicationKey)iterator.next();
                IAnnotation iAnnotation = this.m_table.analyzeSyntheticLambdaApplication(null, this.m_lambda, applicationKey.params, this.m_enclosingEnvironment);
                if (iAnnotation != null && this.m_enclosingEnvironment != applicationKey.env) {
                    throw new XylemError("ERR_SYSTEM", "UNSUPPORTED: non-local lambdas that have annotated return value");
                }
                applicationKey.returnVal = iAnnotation;
            }
        }

        public void insertAnnotationOperation(IAnnotation iAnnotation, AnnotationEnvironment annotationEnvironment, ConversionEngine conversionEngine) {
            if (iAnnotation != this) {
                throw new XylemError("ERR_SYSTEM", "!");
            }
            Iterator iterator = this.m_applications.iterator();
            while (iterator.hasNext()) {
                ApplicationKey applicationKey = (ApplicationKey)iterator.next();
                Object object = conversionEngine.convertSyntheticLambdaApplication((String)null, (Instruction)this.m_lambda, applicationKey.params, annotationEnvironment);
                conversionEngine.insertBinding(this.getVarName(this.getVariable(), applicationKey), new IdentifierInstruction(object));
            }
        }

        public void insertValueDecomposition(Object object, IAnnotation iAnnotation, AnnotationEnvironment annotationEnvironment, ConversionEngine conversionEngine) {
            this.insertAnnotationOperation(iAnnotation, annotationEnvironment, conversionEngine);
        }

        public Instruction convert(Instruction instruction, AnnotationEnvironment annotationEnvironment, ConversionEngine conversionEngine) {
            if (instruction == this.m_lambda) {
                return null;
            }
            return super.convert(instruction, annotationEnvironment, conversionEngine);
        }
    }
}

