/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.annot.meta;

import com.ibm.xylem.Binding;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Type;
import com.ibm.xylem.annot.AnnotationEnvironment;
import com.ibm.xylem.annot.ConversionEngine;
import com.ibm.xylem.annot.IAnnotation;
import com.ibm.xylem.annot.meta.MetaAnnotation;
import com.ibm.xylem.annot.meta.ReturnValueMetaAnnotation;
import com.ibm.xylem.annot.meta.StreamMetaAnnotation;
import com.ibm.xylem.instructions.StreamInstruction;
import com.ibm.xylem.types.ICollectionType;
import com.ibm.xylem.utils.XylemError;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class EmptyStreamMetaAnnotation
extends MetaAnnotation {
    private EmptyStreamMetaAnnotation m_base;
    private Type m_originalType;
    private boolean m_isDefined;
    private StreamMetaAnnotation m_model;

    EmptyStreamMetaAnnotation(Type type) {
        this.m_originalType = type;
    }

    EmptyStreamMetaAnnotation(EmptyStreamMetaAnnotation emptyStreamMetaAnnotation) {
        this.m_originalType = emptyStreamMetaAnnotation.m_originalType;
        this.m_model = emptyStreamMetaAnnotation.m_model;
        this.m_isDefined = emptyStreamMetaAnnotation.m_isDefined;
    }

    public boolean propagateDependancies(IAnnotation iAnnotation) {
        return false;
    }

    public Type getOriginalType() {
        return this.m_originalType;
    }

    public IAnnotation getAtomicModel() {
        if (this.m_model == null) {
            return null;
        }
        return this.m_model.getAtomicAnnotation();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            if (this.m_isDefined) {
                return this.m_model == null;
            }
            return true;
        }
        if (object instanceof ReturnValueMetaAnnotation) {
            return object.equals(this);
        }
        if (object instanceof StreamMetaAnnotation) {
            if (this.m_isDefined) {
                return object.equals(this.m_model);
            }
            this.define((StreamMetaAnnotation)object);
            return true;
        }
        if (object instanceof EmptyStreamMetaAnnotation) {
            if (this.m_isDefined && ((EmptyStreamMetaAnnotation)object).m_isDefined) {
                if (this.m_model == null) {
                    return ((EmptyStreamMetaAnnotation)object).m_model == null;
                }
                return this.m_model.equals(((EmptyStreamMetaAnnotation)object).m_model);
            }
            if (this.m_originalType.equals(((EmptyStreamMetaAnnotation)object).getOriginalType())) {
                if (this.m_isDefined) {
                    ((EmptyStreamMetaAnnotation)object).define(this.m_model);
                } else if (((EmptyStreamMetaAnnotation)object).m_isDefined) {
                    this.define(((EmptyStreamMetaAnnotation)object).m_model);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public List getBindingList(Object object, IAnnotation iAnnotation, ConversionEngine conversionEngine) {
        if (this.m_model != null) {
            return this.m_model.getBindingList(object, iAnnotation, conversionEngine);
        }
        return Collections.singletonList(new Binding(object, this.m_originalType));
    }

    public void insertAnnotationOperation(IAnnotation iAnnotation, AnnotationEnvironment annotationEnvironment, ConversionEngine conversionEngine) {
        if (iAnnotation != this) {
            throw new XylemError("ERR_SYSTEM", "!");
        }
        if (this.m_model != null) {
            Iterator iterator = this.m_model.getBindingList(this.getVariable(), this.m_model, conversionEngine).iterator();
            while (iterator.hasNext()) {
                Binding binding = (Binding)iterator.next();
                conversionEngine.insertBinding(binding.getName(), new StreamInstruction(((ICollectionType)((Object)binding.getBindingType())).getElementType()));
            }
        } else {
            conversionEngine.insertBinding(this.getVariable(), new StreamInstruction(((ICollectionType)((Object)this.m_originalType)).getElementType()));
        }
    }

    public Instruction convert(Instruction instruction, AnnotationEnvironment annotationEnvironment, ConversionEngine conversionEngine) {
        if (this.m_base == null && instruction instanceof StreamInstruction) {
            return null;
        }
        return super.convert(instruction, annotationEnvironment, conversionEngine);
    }

    public IAnnotation cloneAsFunctionParam() {
        return this.clonePassthru();
    }

    public IAnnotation clonePassthru() {
        return new EmptyStreamMetaAnnotation(this);
    }

    public IAnnotation getLoopBindingAnnotation() {
        if (this.m_model != null) {
            return this.m_model.getLoopBindingAnnotation();
        }
        return null;
    }

    public IAnnotation getLoopValueAnnotation() {
        return this.clonePassthru();
    }

    public boolean define(StreamMetaAnnotation streamMetaAnnotation) {
        boolean bl = false;
        if (this.m_isDefined) {
            if (this.m_model == null && streamMetaAnnotation != null || this.m_model != null && !this.m_model.equals(streamMetaAnnotation)) {
                throw new XylemError("ERR_SYSTEM", "can't unify " + this + " " + streamMetaAnnotation);
            }
        } else {
            this.m_model = streamMetaAnnotation;
            this.m_isDefined = true;
            bl = true;
        }
        if (bl) {
            this.propagateDependanciesToBase();
        }
        return bl;
    }

    public boolean propagateDependanciesTo(MetaAnnotation metaAnnotation) {
        boolean bl = false;
        if (metaAnnotation instanceof EmptyStreamMetaAnnotation) {
            bl |= ((EmptyStreamMetaAnnotation)metaAnnotation).define(this.m_model);
        }
        return bl;
    }

    public void propagateDependanciesToBase() {
        if (this.m_isDefined && this.m_base != null) {
            this.m_base.define(this.m_model);
        }
    }

    public IAnnotation unionValues(AnnotationEnvironment annotationEnvironment, ArrayList arrayList) {
        Iterator iterator = arrayList.iterator();
        IAnnotation iAnnotation = this;
        while (iterator.hasNext()) {
            IAnnotation iAnnotation2 = (IAnnotation)iterator.next();
            if (iAnnotation2 instanceof ReturnValueMetaAnnotation) {
                iAnnotation2 = ((ReturnValueMetaAnnotation)iAnnotation2).getReturnAnnotation();
            }
            if (iAnnotation2 instanceof StreamMetaAnnotation) {
                this.define((StreamMetaAnnotation)iAnnotation2);
                iAnnotation = iAnnotation2;
                continue;
            }
            if (this.equals(iAnnotation2)) continue;
            throw new XylemError("ERR_SYSTEM", "not supported " + this + " " + iAnnotation2);
        }
        return this;
    }

    public String toString() {
        return "(EmptyStreamAnnot" + (this.m_isDefined ? "@defined " : "@? ") + this.getVariable() + " base=" + (this.m_base == null ? "null" : this.m_base.getVariable()) + " " + this.m_model + ")";
    }
}

