/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.annot;

import com.ibm.xylem.Binding;
import com.ibm.xylem.Function;
import com.ibm.xylem.annot.AnnotationEnvironment;
import com.ibm.xylem.annot.AnnotationTable;
import com.ibm.xylem.annot.FunctionAnnotationInfo;
import com.ibm.xylem.annot.IAnnotation;
import com.ibm.xylem.annot.ICallSpec;
import com.ibm.xylem.annot.IFunctionAnnotationInfo;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.utils.XylemError;

public class FunctionCallSpec
implements ICallSpec {
    private IAnnotation[] m_paramAnnotations;
    private Function m_function;

    public FunctionCallSpec(FunctionCallInstruction functionCallInstruction, AnnotationEnvironment annotationEnvironment) {
        this.m_function = annotationEnvironment.getTypeEnvironment().getModule().getFunction(functionCallInstruction.getFunction());
        if (this.m_function == null) {
            throw new Error("not found: " + functionCallInstruction.getFunction());
        }
        int n = functionCallInstruction.getChildInstructionCount();
        this.m_paramAnnotations = new IAnnotation[n];
        for (int i = 0; i < n; ++i) {
            this.m_paramAnnotations[i] = annotationEnvironment.get(functionCallInstruction.getChildInstruction(i));
        }
    }

    public FunctionCallSpec(Function function, IAnnotation[] iAnnotationArray) {
        this.m_paramAnnotations = iAnnotationArray;
        this.m_function = function;
        if (this.m_paramAnnotations.length != this.m_function.getParameters().length) {
            throw new XylemError("ERR_SYSTEM", "paramAnnotations(" + iAnnotationArray.length + ") != " + "f(" + function.getParameters().length + ") " + function.getName());
        }
    }

    public FunctionCallSpec(Function function) {
        this(function, new IAnnotation[function.m_parameters.length]);
    }

    public Function getFunction() {
        return this.m_function;
    }

    public IAnnotation[] getParamAnnotations() {
        return this.m_paramAnnotations;
    }

    public Binding[] getParamBindings() {
        return this.getFunction().getParameters();
    }

    public IFunctionAnnotationInfo newInfo(AnnotationTable annotationTable, AnnotationEnvironment annotationEnvironment) {
        return new FunctionAnnotationInfo(this, annotationTable);
    }

    public boolean equals(Object object) {
        if (!(object instanceof FunctionCallSpec)) {
            return false;
        }
        FunctionCallSpec functionCallSpec = (FunctionCallSpec)object;
        if (this.getFunction() != functionCallSpec.getFunction()) {
            return false;
        }
        if (this.getParamAnnotations().length != functionCallSpec.getParamAnnotations().length) {
            return false;
        }
        for (int i = 0; i < this.getParamAnnotations().length; ++i) {
            if (!(this.getParamAnnotations()[i] == null ? functionCallSpec.getParamAnnotations()[i] != null : !this.getParamAnnotations()[i].equals(functionCallSpec.getParamAnnotations()[i]))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.getFunction().hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("FCS: " + this.m_function.getName());
        stringBuffer.append("(");
        Binding[] bindingArray = this.getFunction().m_parameters;
        IAnnotation[] iAnnotationArray = this.getParamAnnotations();
        for (int i = 0; i < bindingArray.length; ++i) {
            stringBuffer.append(bindingArray[i]);
            stringBuffer.append("@");
            stringBuffer.append(i < iAnnotationArray.length ? this.getParamAnnotations()[i] + "" : "UNDEF!");
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

