/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem;

import com.ibm.xylem.BaseDesugarer;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Module;
import com.ibm.xylem.Type;
import com.ibm.xylem.instructions.ConstructorInstantiationInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.MatchInstruction;
import com.ibm.xylem.instructions.ParallelForEachInstruction;
import com.ibm.xylem.instructions.ProcessStreamInstruction;
import com.ibm.xylem.instructions.TupleInstruction;
import com.ibm.xylem.instructions.TupleMatchInstruction;
import com.ibm.xylem.instructions.UnionInjectInstruction;
import com.ibm.xylem.instructions.UnionMatchInstruction;
import com.ibm.xylem.types.AbstractDataType;
import com.ibm.xylem.types.NamedType;
import com.ibm.xylem.types.TupleType;
import com.ibm.xylem.types.UnionType;
import com.ibm.xylem.utils.XylemError;
import java.util.LinkedList;

public class PolymorphicADTDesugarer
extends BaseDesugarer {
    public PolymorphicADTDesugarer(Module module) {
        super(module);
    }

    public Type convertType(Type type) {
        if (type == null) {
            throw new RuntimeException();
        }
        Type type2 = type;
        if (this.getCurrentFunction() != null) {
            type = type.resolveType(this.getCurrentFunction().getTypeEnvironment());
        }
        if (type instanceof TupleType) {
            TupleType tupleType = (TupleType)type;
            Type[] typeArray = tupleType.getElementTypes();
            Type[] typeArray2 = new Type[typeArray.length];
            for (int i = 0; i < typeArray2.length; ++i) {
                typeArray2[i] = this.convertType(typeArray[i]);
            }
            return PolymorphicADTDesugarer.generateType(this.m_prog, typeArray2, "tuple");
        }
        if (type instanceof UnionType) {
            UnionType unionType = (UnionType)type;
            Type[] typeArray = unionType.getElementTypes();
            Type[] typeArray3 = new Type[typeArray.length];
            for (int i = 0; i < typeArray3.length; ++i) {
                typeArray3[i] = this.convertType(typeArray[i]);
            }
            return PolymorphicADTDesugarer.generateUnionType(this.m_prog, typeArray3, "union");
        }
        return super.convertType(type2);
    }

    public Instruction optimizeStep2(Instruction instruction) {
        if (instruction instanceof TupleInstruction) {
            TupleInstruction tupleInstruction = (TupleInstruction)instruction;
            AbstractDataType abstractDataType = ((NamedType)this.convertType(this.resolveType(tupleInstruction))).resolveNameToADT(this.getCurrentFunction().getTypeEnvironment());
            instruction = new ConstructorInstantiationInstruction(abstractDataType.getName(), tupleInstruction.m_parameters);
            instruction.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList());
        } else if (instruction instanceof TupleMatchInstruction) {
            TupleMatchInstruction tupleMatchInstruction = (TupleMatchInstruction)instruction;
            Instruction instruction2 = tupleMatchInstruction.getToMatch();
            AbstractDataType abstractDataType = ((NamedType)this.convertType(this.resolveType(instruction2))).resolveNameToADT(this.getCurrentFunction().getTypeEnvironment());
            MatchInstruction.DeconstructionMatch deconstructionMatch = new MatchInstruction.DeconstructionMatch(abstractDataType.m_constructors[0], tupleMatchInstruction.getVariableNames(), LiteralInstruction.booleanFalseLiteral());
            instruction = new MatchInstruction(instruction2, new MatchInstruction.Match[]{deconstructionMatch}, null);
            instruction.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList());
            deconstructionMatch.setHandler(tupleMatchInstruction.getBody());
            instruction.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList());
        } else if (instruction instanceof UnionInjectInstruction) {
            UnionInjectInstruction unionInjectInstruction = (UnionInjectInstruction)instruction;
            AbstractDataType abstractDataType = ((NamedType)this.convertType(this.resolveType(unionInjectInstruction))).resolveNameToADT(this.getCurrentFunction().getTypeEnvironment());
            AbstractDataType.Constructor constructor = abstractDataType.getConstructor(unionInjectInstruction.getIndex());
            instruction = new ConstructorInstantiationInstruction(constructor, new Instruction[]{unionInjectInstruction.getOperand()});
        } else if (instruction instanceof UnionMatchInstruction) {
            int n;
            UnionMatchInstruction unionMatchInstruction = (UnionMatchInstruction)instruction;
            Instruction instruction3 = unionMatchInstruction.getToMatch();
            AbstractDataType abstractDataType = ((NamedType)this.convertType(this.resolveType(instruction3))).resolveNameToADT(this.getCurrentFunction().getTypeEnvironment());
            boolean[] blArray = new boolean[abstractDataType.getConstructorCount()];
            MatchInstruction.Match[] matchArray = new MatchInstruction.DeconstructionMatch[unionMatchInstruction.getChildInstructionCount() - 1];
            for (n = 0; n < matchArray.length; ++n) {
                IBinding[] iBindingArray = unionMatchInstruction.getChildInstructionBindings(n + 1);
                Type type = this.convertType(iBindingArray[0].getBindingType());
                AbstractDataType.Constructor constructor = null;
                for (int i = 0; i < blArray.length; ++i) {
                    if (blArray[i] || !type.equals(abstractDataType.getConstructor(i).getParameterTypes()[0])) continue;
                    constructor = abstractDataType.getConstructor(i);
                    blArray[i] = true;
                    break;
                }
                if (constructor == null) {
                    new XylemError("ERR_SYSTEM", "UnionMatchInstruction has a type not in a UnionType: " + iBindingArray[0].getBindingType().prettyPrint());
                }
                matchArray[n] = new MatchInstruction.DeconstructionMatch(constructor, new Object[]{iBindingArray[0].getName()}, LiteralInstruction.booleanFalseLiteral());
            }
            instruction = new MatchInstruction(instruction3, matchArray, null);
            instruction.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList());
            for (n = 0; n < matchArray.length; ++n) {
                matchArray[n].setHandler(unionMatchInstruction.getChildInstruction(n + 1));
            }
            instruction.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList());
        } else if (instruction instanceof ProcessStreamInstruction) {
            ProcessStreamInstruction processStreamInstruction = (ProcessStreamInstruction)instruction;
            processStreamInstruction.setStateADTType(this.resolveType(processStreamInstruction.getBody()));
            instruction.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList());
        } else if (instruction instanceof ParallelForEachInstruction) {
            ParallelForEachInstruction parallelForEachInstruction = (ParallelForEachInstruction)instruction;
            parallelForEachInstruction.setBodyADTType(this.resolveType(parallelForEachInstruction.getBody()));
            instruction.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList());
        } else if (instruction instanceof MatchInstruction) {
            MatchInstruction matchInstruction = (MatchInstruction)instruction;
            matchInstruction.desugarADTLambdas(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), this);
        } else if (instruction instanceof ConstructorInstantiationInstruction) {
            ConstructorInstantiationInstruction constructorInstantiationInstruction = (ConstructorInstantiationInstruction)instruction;
            constructorInstantiationInstruction.desugarADTLambdas(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), this);
        } else {
            return super.optimizeStep2(instruction);
        }
        return instruction;
    }
}

