/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem;

import com.ibm.xylem.AbstractTypeStore;
import com.ibm.xylem.Binding;
import com.ibm.xylem.Function;
import com.ibm.xylem.FunctionSignature;
import com.ibm.xylem.Functor;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.ILUBResolver;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.LocalModuleImportDirective;
import com.ibm.xylem.Logger;
import com.ibm.xylem.ModuleImportDirective;
import com.ibm.xylem.ModuleSignature;
import com.ibm.xylem.ModuleSignatureStore;
import com.ibm.xylem.ObjectFactory;
import com.ibm.xylem.Optimizer;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.Program;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.TopLevelModuleImportDirective;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeSpecializationDerivative;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.res.XylemMsg;
import com.ibm.xylem.types.AbstractDataType;
import com.ibm.xylem.types.AbstractDataTypeLambda;
import com.ibm.xylem.types.ClassType;
import com.ibm.xylem.types.CompoundType;
import com.ibm.xylem.types.TypeLambda;
import com.ibm.xylem.types.TypeVariable;
import com.ibm.xylem.types.VirtualDataTypeMap;
import com.ibm.xylem.utils.XylemError;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class Module
extends AbstractTypeStore
implements Serializable {
    private static final long serialVersionUID = 3362968532062637990L;
    static final Logger s_logger = Logger.getInstance(class$com$ibm$xylem$Module == null ? (class$com$ibm$xylem$Module = Module.class$("com.ibm.xylem.Module")) : class$com$ibm$xylem$Module);
    protected HashMap m_functions = new HashMap();
    protected HashMap m_modules = new HashMap();
    protected ArrayList m_moduleDefinitions = new ArrayList();
    protected ArrayList m_fixup = new ArrayList();
    public ILUBResolver m_lubResolver;
    public ModuleSignature m_signature;
    protected Module m_parent;
    protected HashMap m_moduleImportDirectives = new HashMap();
    protected HashMap m_functors = new HashMap();
    protected VirtualDataTypeMap m_vdtmap = new VirtualDataTypeMap();
    public boolean m_flatTypeNamespace;
    private boolean m_preserveInputTypeAnnotations = false;
    private HashMap m_partialInformation = new HashMap();
    boolean typeAliasesExpanded = true;
    static /* synthetic */ Class class$com$ibm$xylem$Module;

    public void setPartialInformation(String string, Set set) {
        this.m_partialInformation.put(string, set);
    }

    public Set getPartialInformation(String string) {
        return (Set)this.m_partialInformation.get(string);
    }

    public Module() {
    }

    public Module(String string, Module module) {
        this(string, module, new ModuleSignature(""));
    }

    public Module(String string, Module module, ModuleSignature moduleSignature) {
        this.m_name = string;
        this.m_signature = moduleSignature;
        this.m_parent = module;
    }

    public void addModule(Module module) {
        if (module == this) {
            throw new XylemError("ERR_SYSTEM", "can't add '" + this.getName() + "' to self");
        }
        this.m_moduleDefinitions.add(module.getName());
        this.m_modules.put(module.getName(), module);
        module.m_parent = this;
        this.addModuleImportDirective(new LocalModuleImportDirective(module.getName(), module.m_signature));
    }

    public void addModuleImportDirective(ModuleImportDirective moduleImportDirective) {
        this.m_moduleImportDirectives.put(moduleImportDirective.getLocalName(), moduleImportDirective);
    }

    public Object evaluate() {
        Environment environment = new Environment();
        return this.evaluate(environment, null);
    }

    public Object debug(IDebuggerInterceptor iDebuggerInterceptor) {
        Environment environment = new Environment();
        return this.evaluate(environment, iDebuggerInterceptor);
    }

    public Object evaluate(Environment environment, IDebuggerInterceptor iDebuggerInterceptor) {
        Function function = this.getFunction("main");
        if (function == null) {
            throw new XylemError("ERR_SYSTEM", "not found 'main'");
        }
        return function.getBody().evaluate(environment, function, iDebuggerInterceptor, false);
    }

    public void addFunctor(Functor functor) {
        this.m_functors.put(functor.getName(), functor);
    }

    public Collection getFunctors() {
        return this.m_functors.values();
    }

    public Functor getFunctor(String string) {
        return (Functor)this.m_functors.get(string);
    }

    public VirtualDataTypeMap getVDTMap() {
        return this.m_vdtmap;
    }

    public void setVDTMap(VirtualDataTypeMap virtualDataTypeMap) {
        this.m_vdtmap = virtualDataTypeMap;
    }

    public void addFunction(Function function, boolean bl) {
        s_logger.debug("adding function " + function.getName());
        Object v = this.m_functions.get(function.getName());
        if (v == function) {
            return;
        }
        if (v != null && bl) {
            s_logger.error("function with name " + function.getName() + " already exists");
        }
        this.m_functions.put(function.getName(), function);
    }

    public void addFunction(Function function) {
        this.addFunction(function, true);
    }

    public Function getFunction(String string) {
        return (Function)this.m_functions.get(string);
    }

    public Function getPublicFunction(String string) {
        if (this.m_signature.containsFunction(string)) {
            return this.getFunction(string);
        }
        return null;
    }

    public FunctionSignature getFunctionSignature(String string) {
        return this.m_signature.getFunctionSignature(string);
    }

    public Module getModule(String string) {
        return (Module)this.m_modules.get(string);
    }

    public Collection getModules() {
        return this.m_modules.values();
    }

    public ModuleImportDirective getModuleImportDirective(String string) {
        return (ModuleImportDirective)this.m_moduleImportDirectives.get(string);
    }

    public Collection getModuleImportDirectives() {
        return this.m_moduleImportDirectives.values();
    }

    public ModuleSignature getModuleSignature(String string) {
        Module module = this.getModule(string);
        if (module != null) {
            return module.m_signature;
        }
        ModuleImportDirective moduleImportDirective = (ModuleImportDirective)this.m_moduleImportDirectives.get(string);
        if (moduleImportDirective == null) {
            Iterator iterator = this.m_moduleImportDirectives.values().iterator();
            while (iterator.hasNext()) {
                ModuleImportDirective moduleImportDirective2 = (ModuleImportDirective)iterator.next();
                ModuleSignature moduleSignature = moduleImportDirective2.getSignature();
                ModuleSignature moduleSignature2 = moduleSignature.getModuleSignature(string);
                if (moduleSignature2 == null) continue;
                return moduleSignature2;
            }
            return null;
        }
        return moduleImportDirective.getSignature();
    }

    public Module getParent() {
        return this.m_parent;
    }

    public Program getProgram() {
        for (Module module = this; module != null; module = module.getParent()) {
            if (!(module instanceof Program)) continue;
            return (Program)module;
        }
        throw new XylemError("ERR_SYSTEM", "modules must be descended from a program");
    }

    public Function[] getSimilarFunctions(String string) {
        Function[] functionArray;
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.m_functions.keySet().iterator();
        while (iterator.hasNext()) {
            functionArray = (Function[])iterator.next();
            if (-1 == functionArray.indexOf(string) || -1 != functionArray.indexOf(string + "s")) continue;
            linkedList.add(this.m_functions.get(functionArray));
        }
        functionArray = new Function[linkedList.size()];
        linkedList.toArray(functionArray);
        return functionArray;
    }

    public void renameFunction(Function function, String string) {
        this.m_functions.remove(function.getName());
        function.m_name = string;
        this.addFunction(function, false);
    }

    public Collection getFunctions() {
        return this.m_functions.values();
    }

    public Set getFunctionNames() {
        return this.m_functions.keySet();
    }

    public void forceFunctionGeneration(Function function) {
        if (function.isPolymorphic()) {
            throw new IllegalArgumentException("Cannot force function " + function.getName() + " to be generated because it is polymorphic");
        }
        this.m_signature.addFunctionSignature(new FunctionSignature(function));
    }

    public void reduce() {
        Serializable serializable;
        s_logger.debug("reducing module");
        Iterator<Object> iterator = this.m_moduleDefinitions.iterator();
        while (iterator.hasNext()) {
            serializable = (Module)this.m_modules.get(iterator.next());
            ((Module)serializable).reduce();
        }
        iterator = this.m_functors.values().iterator();
        while (iterator.hasNext()) {
            serializable = (Functor)iterator.next();
            ((Functor)serializable).reduce();
        }
        serializable = new ArrayList(this.m_functions.values());
        Module.sortFunctionList((List)((Object)serializable));
        iterator = ((ArrayList)serializable).iterator();
        while (iterator.hasNext()) {
            Function function = (Function)iterator.next();
            function.reduce();
        }
    }

    public void clearTypeInformation() {
        this.clearTypeInformation(true);
    }

    public void clearTypeInformation(boolean bl) {
        Serializable serializable;
        Iterator<Object> iterator = this.m_moduleDefinitions.iterator();
        while (iterator.hasNext()) {
            serializable = (Module)this.m_modules.get(iterator.next());
            ((Module)serializable).clearTypeInformation(bl);
        }
        iterator = this.m_functors.values().iterator();
        while (iterator.hasNext()) {
            serializable = (Functor)iterator.next();
            ((Functor)serializable).clearTypeInformation();
        }
        iterator = this.m_functions.values().iterator();
        while (iterator.hasNext()) {
            serializable = (Function)iterator.next();
            ((Function)serializable).clearTypeInformation(bl);
        }
    }

    public void addToFixupList(FunctionCallInstruction functionCallInstruction, Function function) {
        this.m_fixup.add(new Object[]{functionCallInstruction, function});
    }

    public void typeCheck() throws TypeCheckException {
        this.typeCheck(true);
    }

    public void typeCheck(boolean bl) throws TypeCheckException {
        Function function;
        FunctionCallInstruction functionCallInstruction;
        Object[] objectArray;
        int n;
        Serializable serializable;
        Serializable serializable2;
        s_logger.debug("type checking module " + this.m_name);
        Iterator<Object> iterator = this.m_moduleDefinitions.iterator();
        while (iterator.hasNext()) {
            serializable2 = (Module)this.m_modules.get(iterator.next());
            ((Module)serializable2).typeCheck(bl);
        }
        iterator = this.m_functors.values().iterator();
        while (iterator.hasNext()) {
            serializable2 = (Functor)iterator.next();
            ((Functor)serializable2).typeCheck();
        }
        this.m_fixup.clear();
        serializable2 = new LinkedList();
        iterator = this.exportedFunctionsIterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof String) {
                throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Function " + object + " in module " + this.m_name + " is required by the module signature but was not defined"), null);
            }
            serializable = (Function)object;
            if (((Function)serializable).hasBeenTypeChecked()) continue;
            s_logger.debug("pretype checking function " + ((Function)serializable).getName());
            ((Function)serializable).typeCheck(this, null, (LinkedList)serializable2);
            s_logger.debug("posttype checking function " + ((Function)serializable).getName());
        }
        s_logger.debug("Finished type checking functions for module " + this.m_name + ", going on to fixup");
        for (n = 0; !this.m_fixup.isEmpty() && n < 100; ++n) {
            serializable = new ArrayList(this.m_fixup);
            this.m_fixup.clear();
            iterator = ((ArrayList)serializable).iterator();
            while (iterator.hasNext()) {
                objectArray = (Object[])iterator.next();
                functionCallInstruction = (FunctionCallInstruction)objectArray[0];
                function = (Function)objectArray[1];
                Function.pushFunction(function, (LinkedList)serializable2);
                if (functionCallInstruction.fixupPartiallySpecializedFunctions(function) || function.isPolymorphic()) {
                    iterator.remove();
                }
                Function.popFunction(function, (LinkedList)serializable2);
            }
            this.m_fixup.addAll(serializable);
        }
        if (n >= 100) {
            serializable = new StringBuffer();
            iterator = this.m_fixup.iterator();
            while (iterator.hasNext()) {
                objectArray = (Object[])iterator.next();
                functionCallInstruction = (FunctionCallInstruction)objectArray[0];
                function = (Function)objectArray[1];
                if (((StringBuffer)serializable).length() > 0) {
                    ((StringBuffer)serializable).append(", ");
                }
                ((StringBuffer)serializable).append(functionCallInstruction);
                ((StringBuffer)serializable).append(" in function ");
                ((StringBuffer)serializable).append(function.getName() + " : " + new FunctionSignature(function));
            }
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Unable to infer types for function calls: " + serializable), null);
        }
        s_logger.debug("Finished fixing up functions for module " + this.m_name + ", going on to remove unused functions");
        if (bl) {
            this.removeDeadFunctions();
            s_logger.debug("Finished removing unused and un-type-specialized functions for module " + this.m_name);
        }
        iterator = this.m_functions.values().iterator();
        while (iterator.hasNext()) {
            serializable = (Function)iterator.next();
            if (!((Function)serializable).hasBeenTypeChecked()) continue;
            ((Function)serializable).standardizeTypes(true);
        }
    }

    public void typeCheckReduced() throws TypeCheckException {
        Serializable serializable;
        Iterator iterator = this.m_moduleDefinitions.iterator();
        while (iterator.hasNext()) {
            serializable = (Module)this.m_modules.get(iterator.next());
            ((Module)serializable).typeCheckReduced();
        }
        serializable = new LinkedList();
        iterator = this.exportedFunctionsIterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Function)) {
                Program.dumpXylemFile(this, null, this.getName());
                s_logger.warn("unimplemented exported function (dumped to " + this.getName() + ".xylem)" + e);
                continue;
            }
            Function function = (Function)e;
            s_logger.debug("typeChecking function " + function.getName() + " (" + e.getClass() + ")");
            if (function.hasBeenTypeChecked()) continue;
            function.typeCheckReduced(this, (LinkedList)serializable);
        }
    }

    public void instantiateReducedPolymorphicFunctions() {
        Serializable serializable;
        Iterator iterator = this.m_moduleDefinitions.iterator();
        while (iterator.hasNext()) {
            serializable = (Module)this.m_modules.get(iterator.next());
            ((Module)serializable).instantiateReducedPolymorphicFunctions();
        }
        serializable = new HashSet();
        iterator = this.exportedFunctionsIterator();
        boolean bl = false;
        while (true) {
            HashSet hashSet = new HashSet();
            while (iterator.hasNext()) {
                Function function = (Function)iterator.next();
                if (bl) {
                    try {
                        function.typeCheckReduced(this, new LinkedList());
                    }
                    catch (TypeCheckException typeCheckException) {
                        typeCheckException.printStackTrace();
                        throw new RuntimeException();
                    }
                }
                function.instantiateReducedPolymorphicFunctions(hashSet, new HashSet(), (Set)((Object)serializable));
                function.m_returnType = function.getBody().getType(function.getTypeEnvironment(), function.getBindingEnvironment());
                if (bl) {
                    TypeSpecializationDerivative typeSpecializationDerivative = (TypeSpecializationDerivative)function.getDerivationKey();
                    for (int i = 0; i < function.m_parameters.length; ++i) {
                        try {
                            function.getTypeEnvironment().unify(function.m_parameters[i].getBindingType(), typeSpecializationDerivative.m_originalTypeVariables[i], null);
                            continue;
                        }
                        catch (TypeCheckException typeCheckException) {
                            typeCheckException.printStackTrace();
                            throw new RuntimeException();
                        }
                    }
                }
                function.standardizeTypes(true);
            }
            if (hashSet.isEmpty()) {
                return;
            }
            iterator = hashSet.iterator();
            bl = true;
        }
    }

    public void removeDeadFunctions() {
        Function function;
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.exportedFunctionsIterator();
        while (iterator.hasNext()) {
            function = (Function)iterator.next();
            hashSet.add(function.getName());
            this.accumulateCalledFunctions(hashSet, function.getBody());
        }
        iterator = this.m_functions.values().iterator();
        while (iterator.hasNext()) {
            function = (Function)iterator.next();
            if (hashSet.contains(function.getName())) continue;
            s_logger.debug("function " + function.getName() + " is not being called; removing");
            iterator.remove();
            if (function.getOriginalFunction() == null) continue;
            function.getOriginalFunction().m_derivatives.remove(function.getDerivationKey());
        }
    }

    protected void accumulateCalledFunctions(HashSet hashSet, Instruction instruction) {
        HashSet hashSet2 = new HashSet();
        instruction.accumulateFunctionsCalled(hashSet2);
        Iterator iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (hashSet.contains(string)) continue;
            hashSet.add(string);
            this.accumulateCalledFunctions(hashSet, ((Function)this.m_functions.get(string)).getBody());
        }
    }

    public void removeFunctionDerivativeInformation() {
        s_logger.debug("removing function derivative information from program");
        Iterator iterator = this.m_functions.values().iterator();
        while (iterator.hasNext()) {
            Function function = (Function)iterator.next();
            function.removeDerivativeInformation();
        }
    }

    protected String innerToString() {
        return "module";
    }

    public void dump(PrintWriter printWriter) {
        PrettyPrinter prettyPrinter = new PrettyPrinter(printWriter);
        this.toString(prettyPrinter, 0);
        printWriter.println(prettyPrinter.dumpModuleSignatures());
        printWriter.flush();
    }

    public void toString(PrettyPrinter prettyPrinter, int n) {
        prettyPrinter.printFormOpen(this.innerToString(), n + 0);
        if (this.getName().length() > 0) {
            prettyPrinter.print(" " + this.getName());
        }
        if (this.m_signature != null && this.m_signature.m_name.length() != 0) {
            prettyPrinter.m_moduleSignatures.add(this.m_signature);
        }
        this.prettyPrintModuleInternals(prettyPrinter, n);
        prettyPrinter.printFormClose(n + 0);
    }

    public void prettyPrintModuleInternals(PrettyPrinter prettyPrinter, int n) {
        Object object;
        Iterator<Object> iterator = this.m_moduleDefinitions.iterator();
        while (iterator.hasNext()) {
            object = (Module)this.m_modules.get(iterator.next());
            ((Module)object).toString(prettyPrinter, n + 1);
        }
        iterator = this.m_functors.values().iterator();
        while (iterator.hasNext()) {
            object = (Functor)iterator.next();
            ((Functor)object).toString(prettyPrinter, n + 1);
        }
        iterator = this.m_moduleImportDirectives.values().iterator();
        while (iterator.hasNext()) {
            object = (ModuleImportDirective)iterator.next();
            ((ModuleImportDirective)object).toString(prettyPrinter, n + 1);
        }
        iterator = this.getAbstractDataTypesIterator();
        while (iterator.hasNext()) {
            ((AbstractDataType)iterator.next()).toString(prettyPrinter, n + 1);
        }
        if (this.m_signature != null) {
            iterator = this.m_signature.getAbstractDataTypesIterator();
            while (iterator.hasNext()) {
                object = (AbstractDataType)iterator.next();
                ((AbstractDataType)object).toString(prettyPrinter, n + 1);
            }
        }
        object = this.m_functions.values().toArray(new Function[0]);
        Arrays.sort(object, new Comparator(){

            public int compare(Object object, Object object2) {
                String string = ((Function)object).getName();
                String string2 = ((Function)object2).getName();
                return string.compareTo(string2);
            }
        });
        for (int i = 0; i < ((Object)object).length; ++i) {
            Object object2 = object[i];
            if (((Function)object2).getName().equals("main")) continue;
            ((Function)object2).toString(prettyPrinter, n + 1);
        }
        if (this.m_functions.containsKey("main")) {
            ((Function)this.m_functions.get("main")).toString(prettyPrinter, n + 1);
        }
    }

    public String toString() {
        PrettyPrinter prettyPrinter = new PrettyPrinter();
        this.toString(prettyPrinter, 0);
        return prettyPrinter.toString();
    }

    protected Iterator exportedFunctionsIterator() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.m_signature.m_functionSignatures.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Function function = (Function)this.m_functions.get(k);
            arrayList.add(function == null ? k : function);
        }
        Module.sortFunctionList(arrayList);
        return arrayList.iterator();
    }

    public void exportAllFunctions() {
        Iterator iterator = this.m_functions.values().iterator();
        while (iterator.hasNext()) {
            Function function = (Function)iterator.next();
            this.m_signature.addFunctionSignature(new FunctionSignature(function));
        }
    }

    public void exportAllSymbols() {
        Object object;
        this.exportAllFunctions();
        Iterator<Object> iterator = this.getAbstractDataTypesIterator();
        while (iterator.hasNext()) {
            object = (AbstractDataType)iterator.next();
            this.m_signature.addAbstractDataType((AbstractDataType)object);
        }
        this.clearADTs();
        iterator = this.m_classes.values().iterator();
        while (iterator.hasNext()) {
            object = (ClassType)iterator.next();
            this.m_signature.addClass((ClassType)object);
        }
        this.m_classes.clear();
        iterator = this.m_genericADTs.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            AbstractDataTypeLambda abstractDataTypeLambda = (AbstractDataTypeLambda)this.m_genericADTs.get(object);
            this.m_signature.addGenericAbstractDataType((String)object, abstractDataTypeLambda.getTypeParameters(), abstractDataTypeLambda.m_constructors);
        }
        this.m_genericADTs.clear();
        iterator = this.m_typeLambdas.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            this.m_signature.addTypeLambda((String)object, (TypeLambda)this.m_typeLambdas.get(object));
        }
        this.m_typeLambdas.clear();
        iterator = this.m_moduleImportDirectives.values().iterator();
        while (iterator.hasNext()) {
            object = (ModuleImportDirective)iterator.next();
            this.m_signature.addModuleImportDirective((ModuleImportDirective)object);
        }
    }

    public void optimize(Optimizer optimizer) {
        if (!this.typeAliasesExpanded) {
            throw new XylemError("ERR_SYSTEM", "Internal compiler error: type aliases must be expanded before transforming code");
        }
        s_logger.debug("running optimizer " + optimizer);
        Iterator iterator = this.m_modules.values().iterator();
        while (iterator.hasNext()) {
            ((Module)iterator.next()).optimize(optimizer);
        }
        Object object = new TreeSet();
        ((TreeSet)object).addAll(this.m_functions.keySet());
        int n = 0;
        HashSet<Object> hashSet = new HashSet<Object>();
        while (true) {
            Object object2;
            Iterator iterator2 = ((TreeSet)object).iterator();
            while (iterator2.hasNext()) {
                object2 = iterator2.next();
                Function function = (Function)this.m_functions.get(object2);
                optimizer.optimizeFunction(function);
                hashSet.add(object2);
                ++n;
            }
            object2 = new TreeSet();
            ((TreeSet)object2).addAll(this.m_functions.keySet());
            ((AbstractSet)object2).removeAll(hashSet);
            if (((TreeSet)object2).isEmpty()) break;
            object = object2;
        }
    }

    public void formalizeSignature(String string) {
        this.m_signature.setName(string);
        Iterator iterator = this.m_signature.m_functionSignatures.values().iterator();
        while (iterator.hasNext()) {
            FunctionSignature functionSignature = (FunctionSignature)iterator.next();
            Function function = this.getFunction(functionSignature.getFunctionName());
            functionSignature.m_returnType = function.getReturnType().resolveType(function.getTypeEnvironment());
        }
    }

    public static void sortFunctionList(List list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object object, Object object2) {
                String string = object instanceof String ? (String)object : ((Function)object).getName();
                String string2 = object2 instanceof String ? (String)object2 : ((Function)object2).getName();
                return string.compareTo(string2);
            }
        });
    }

    protected void write(ObjectOutput objectOutput) throws IOException {
        Object object;
        Object object2;
        WriteObjectFileHelper writeObjectFileHelper = new WriteObjectFileHelper(this, objectOutput);
        writeObjectFileHelper.writeString(this.m_name);
        Module.writeTypes(this, writeObjectFileHelper);
        writeObjectFileHelper.writeInt(this.m_moduleImportDirectives.size());
        Iterator<Object> iterator = this.m_moduleImportDirectives.values().iterator();
        while (iterator.hasNext()) {
            object2 = (ModuleImportDirective)iterator.next();
            ((ModuleImportDirective)object2).write(writeObjectFileHelper);
        }
        object2 = this.getFunctions();
        writeObjectFileHelper.writeInt(object2.size());
        iterator = object2.iterator();
        while (iterator.hasNext()) {
            object = (Function)iterator.next();
            ((Function)object).write(writeObjectFileHelper);
        }
        object = this.getTypeAliases();
        writeObjectFileHelper.writeInt(object.size());
        iterator = object.iterator();
        Set set = this.getTypeAliasNames();
        Iterator iterator2 = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator2.next();
            writeObjectFileHelper.writeString(string);
            Type type = (Type)iterator.next();
            writeObjectFileHelper.writeType(type);
        }
    }

    public static Module loadCompiled(File file, String string, ModuleSignatureStore moduleSignatureStore) throws Exception {
        if (moduleSignatureStore == null) {
            moduleSignatureStore = new ModuleSignatureStore(new ArrayList());
        }
        File file2 = new File(file, string + ".cxi");
        FileInputStream fileInputStream = new FileInputStream(file2);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        ModuleSignature moduleSignature = new ModuleSignature();
        moduleSignature.read(objectInputStream, moduleSignatureStore);
        fileInputStream.close();
        moduleSignatureStore.registerModuleSignature(string, moduleSignature);
        File file3 = new File(file, string + ".cxo");
        fileInputStream = new FileInputStream(file3);
        objectInputStream = new ObjectInputStream(fileInputStream);
        Module module = Module.readModule(objectInputStream, moduleSignatureStore);
        module.m_signature = moduleSignature;
        fileInputStream.close();
        module.typeCheckReduced();
        return module;
    }

    public static Module loadCompiled(URL uRL, ModuleSignatureStore moduleSignatureStore) throws Exception {
        File file = new File(uRL.getPath());
        String string = file.getName();
        string = string.substring(0, string.lastIndexOf(".cxo"));
        file = file.getParentFile();
        return Module.loadCompiled(file, string, moduleSignatureStore);
    }

    public static void saveCompiled(Module module, URL uRL) throws Exception {
        File file = new File(uRL.getPath());
        String string = file.getName();
        string = string.substring(0, string.lastIndexOf(".cxo"));
        file = file.getParentFile();
        Module.saveCompiled(module, file, string);
    }

    public static void saveCompiled(Module module, File file, String string) throws Exception {
        File file2 = new File(file, string + ".cxo");
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file2));
        Module.writeModule(objectOutputStream, module);
        objectOutputStream.flush();
        objectOutputStream.close();
        s_logger.debug("wrote:" + file2);
        File file3 = new File(file, string + ".cxi");
        objectOutputStream = new ObjectOutputStream(new FileOutputStream(file3));
        module.m_signature.write(objectOutputStream);
        objectOutputStream.flush();
        objectOutputStream.close();
        s_logger.debug("wrote:" + file3);
    }

    public static Module readModule(ObjectInput objectInput, ModuleSignatureStore moduleSignatureStore) throws Exception {
        s_logger.debug("reading module or program");
        String string = objectInput.readUTF();
        s_logger.debug(" class = " + string);
        Module module = (Module)ObjectFactory.newInstance(string, ObjectFactory.findClassLoader(), true);
        module.read(objectInput, moduleSignatureStore);
        return module;
    }

    public static void writeModule(ObjectOutput objectOutput, Module module) throws IOException {
        objectOutput.writeUTF(module.getClass().getName());
        module.write(objectOutput);
    }

    protected void read(ObjectInput objectInput, ModuleSignatureStore moduleSignatureStore) throws Exception {
        Object object;
        int n;
        ReadObjectFileHelper readObjectFileHelper = new ReadObjectFileHelper(this, objectInput, moduleSignatureStore);
        s_logger.debug("reading module");
        this.m_name = readObjectFileHelper.readString();
        s_logger.debug("reading module m_name=" + this.m_name);
        this.m_signature = moduleSignatureStore.resolveModuleSignature(this.getName());
        Module.readTypes(this, readObjectFileHelper);
        int n2 = readObjectFileHelper.readInt();
        for (n = 0; n < n2; ++n) {
            object = new TopLevelModuleImportDirective();
            ((TopLevelModuleImportDirective)object).read(readObjectFileHelper);
            this.addModuleImportDirective((ModuleImportDirective)object);
        }
        n2 = readObjectFileHelper.readInt();
        for (n = 0; n < n2; ++n) {
            object = new Function();
            ((Function)object).read(readObjectFileHelper);
            this.addFunction((Function)object);
        }
        n2 = readObjectFileHelper.readInt();
        for (int i = 0; i < n2; ++i) {
            object = readObjectFileHelper.readString();
            Type type = readObjectFileHelper.readType();
            this.addTypeAlias((String)object, type);
        }
    }

    public AbstractDataType.Constructor getConstructor(String string) {
        if (this.m_constructors.containsKey(string)) {
            return (AbstractDataType.Constructor)this.m_constructors.get(string);
        }
        AbstractDataType.Constructor constructor = this.m_signature.getConstructor(string);
        if (constructor != null) {
            return constructor;
        }
        Iterator iterator = this.getModuleImportDirectives().iterator();
        while (iterator.hasNext()) {
            ModuleImportDirective moduleImportDirective = (ModuleImportDirective)iterator.next();
            constructor = moduleImportDirective.getSignature().getConstructor(string);
            if (constructor == null) continue;
            return constructor;
        }
        for (int i = 0; i < this.m_moduleDefinitions.size(); ++i) {
            Module module = (Module)this.m_modules.get(this.m_moduleDefinitions.get(i));
            constructor = module.getConstructor(string);
            if (constructor == null) continue;
            return constructor;
        }
        return null;
    }

    public CompoundType lookupCompoundType(String string, String string2) {
        return this.matchesName(string) ? this.lookupCompoundType(string2) : this.getModuleSignature(string).lookupCompoundType(string2);
    }

    public CompoundType lookupCompoundType(String string) {
        CompoundType compoundType = super.lookupCompoundType(string);
        if (compoundType != null) {
            return compoundType;
        }
        compoundType = this.m_signature.lookupCompoundType(string);
        if (compoundType != null) {
            return compoundType;
        }
        Iterator iterator = this.getModuleImportDirectives().iterator();
        while (iterator.hasNext()) {
            ModuleImportDirective moduleImportDirective = (ModuleImportDirective)iterator.next();
            if (moduleImportDirective == null) {
                throw new XylemError("ERR_SYSTEM", "Internal compiler error");
            }
            ModuleSignature moduleSignature = moduleImportDirective.getSignature();
            if (moduleSignature == null && !this.m_flatTypeNamespace) continue;
            if (moduleSignature == null) {
                throw new XylemError("ERR_SYSTEM", "Internal compiler error: null signature for module-import directive " + moduleImportDirective.getLocalName() + " while looking for compound type " + string);
            }
            compoundType = moduleImportDirective.getSignature().lookupCompoundType(string);
            if (compoundType == null) continue;
            return compoundType;
        }
        return null;
    }

    public Type lookupTypeAlias(String string) {
        if (this.m_typeAliases.containsKey(string)) {
            return (Type)this.m_typeAliases.get(string);
        }
        Type type = this.m_signature.lookupTypeAlias(string);
        if (type != null) {
            return type;
        }
        Iterator iterator = this.getModuleImportDirectives().iterator();
        while (iterator.hasNext()) {
            ModuleImportDirective moduleImportDirective = (ModuleImportDirective)iterator.next();
            if (moduleImportDirective.getSignature() == null && !this.m_flatTypeNamespace) continue;
            if (moduleImportDirective.getSignature() == null) {
                throw new XylemError("ERR_SYSTEM", "signature not found for module import " + moduleImportDirective.getLocalName());
            }
            type = moduleImportDirective.getSignature().lookupTypeAlias(string);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    public void addGenericAbstractDataType(String string, TypeVariable[] typeVariableArray, AbstractDataType.Constructor[] constructorArray) {
        s_logger.debug("[Module.addGenericAbstractDataType] adding generic ADT " + string + " to module " + this.m_name);
        super.addGenericAbstractDataType(string, typeVariableArray, constructorArray);
        this.m_signature.addGenericAbstractDataType(string, typeVariableArray, constructorArray);
    }

    public AbstractDataType instantiateGenericADT(String string, Type[] typeArray) {
        return this.instantiateGenericADT(null, string, typeArray);
    }

    public AbstractDataType instantiateGenericADT(String string, String string2, Type[] typeArray) {
        s_logger.debug("[Module.instatiateGenericADT] instantiating generic ADT " + string + "." + string2 + " in module " + this.m_name);
        AbstractDataTypeLambda abstractDataTypeLambda = this.matchesName(string) ? this.getGenericADT(string2) : this.getModuleSignature(string).getGenericADT(string2);
        return this.instantiateGenericADT(abstractDataTypeLambda, typeArray);
    }

    public AbstractDataTypeLambda getGenericADT(String string) {
        AbstractDataTypeLambda abstractDataTypeLambda;
        Object object;
        s_logger.debug("[Module.getGenericADT] getting generic ADT " + string + " from module " + this.m_name);
        Iterator iterator = this.m_genericADTs.values().iterator();
        while (iterator.hasNext()) {
            object = (AbstractDataTypeLambda)iterator.next();
            s_logger.debug("[Module.getGenericADT] generic ADT " + ((CompoundType)object).getName() + " is in module " + this.m_name);
        }
        object = this.m_signature.m_genericADTs.values().iterator();
        while (object.hasNext()) {
            abstractDataTypeLambda = (AbstractDataTypeLambda)object.next();
            s_logger.debug("[Module.getGenericADT] generic ADT " + abstractDataTypeLambda.getName() + " is in module signature " + this.m_signature.getName());
        }
        abstractDataTypeLambda = super.getGenericADT(string);
        if (abstractDataTypeLambda != null) {
            return abstractDataTypeLambda;
        }
        abstractDataTypeLambda = this.m_signature.getGenericADT(string);
        if (abstractDataTypeLambda != null) {
            return abstractDataTypeLambda;
        }
        Iterator iterator2 = this.m_modules.values().iterator();
        while (iterator2.hasNext()) {
            abstractDataTypeLambda = ((Module)iterator2.next()).getGenericADT(string);
            if (abstractDataTypeLambda == null) continue;
            return abstractDataTypeLambda;
        }
        s_logger.debug("[Module.getGenericADT] did not find generic ADT " + string + " in module " + this.m_name);
        return null;
    }

    public TypeLambda lookupTypeLambda(String string, String string2) {
        s_logger.debug("[Module.lookupTypeLambda] looking for type-lambda " + string + "." + string2 + " in module " + this.m_name);
        TypeLambda typeLambda = this.matchesName(string) ? this.lookupTypeLambda(string2) : this.lookupTypeLambdaInSig(string, string2);
        return typeLambda;
    }

    TypeLambda lookupTypeLambdaInSig(String string, String string2) {
        ModuleSignature moduleSignature = this.getModuleSignature(string);
        if (moduleSignature == null) {
            throw new XylemError("ERR_SYSTEM", "Module signature " + string + " was null when looking for type-lambda " + string2 + " in " + this.getName());
        }
        return moduleSignature.lookupTypeLambda(string2);
    }

    public TypeLambda lookupTypeLambda(String string) {
        TypeLambda typeLambda = super.lookupTypeLambda(string);
        return typeLambda == null ? this.m_signature.lookupTypeLambda(string) : typeLambda;
    }

    public void expandTypeAliases() {
        Iterator iterator = this.m_modules.values().iterator();
        while (iterator.hasNext()) {
            ((Module)iterator.next()).expandTypeAliases();
        }
        Iterator iterator2 = this.m_genericADTs.values().iterator();
        while (iterator2.hasNext()) {
            AbstractDataTypeLambda abstractDataTypeLambda = (AbstractDataTypeLambda)iterator2.next();
            for (int i = 0; i < abstractDataTypeLambda.m_constructors.length; ++i) {
                Binding[] bindingArray = abstractDataTypeLambda.m_constructors[i].m_parameters;
                for (int j = 0; j < bindingArray.length; ++j) {
                    bindingArray[j].m_type = bindingArray[j].m_type.expandTypeAliases(this);
                }
            }
        }
        this.typeAliasesExpanded = true;
    }

    public boolean getPreserveInputTypeAnnotations() {
        return this.m_preserveInputTypeAnnotations;
    }

    public void setPreserveInputTypeAnnotations(boolean bl) {
        this.m_preserveInputTypeAnnotations = bl;
    }

    public Module cloneModule() {
        Module module = new Module(this.m_name, this.m_parent == null ? null : this.m_parent.cloneModule(), this.m_signature == null ? null : this.m_signature.cloneModule());
        Iterator iterator = this.m_functions.keySet().iterator();
        Object k = null;
        while (iterator.hasNext()) {
            k = iterator.next();
            module.m_functions.put(k, ((Function)this.m_functions.get(k)).cloneFunction());
        }
        module.m_adtDefinitions = (ArrayList)this.m_adtDefinitions.clone();
        module.m_adts = (HashMap)this.m_adts.clone();
        module.m_compoundTypes = (HashMap)this.m_compoundTypes.clone();
        module.m_constructors = (HashMap)this.m_constructors.clone();
        module.m_moduleImportDirectives = (HashMap)this.m_moduleImportDirectives.clone();
        module.m_typeAliases = (HashMap)this.m_typeAliases.clone();
        module.m_genericADTs = (HashMap)this.m_genericADTs.clone();
        module.m_typeLambdas = (HashMap)this.m_typeLambdas.clone();
        return module;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

