/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem;

import com.ibm.xylem.LogManager;
import com.ibm.xylem.utils.XylemError;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;

public final class Logger {
    public static final int s_debug = 0;
    public static final int s_info = 1;
    public static final int s_warn = 2;
    public static final int s_error = 3;
    public static final int s_off = 4;
    private static final String[] s_levels = new String[]{"DEBUG", "INFO", "WARN", "ERROR", "OFF"};
    protected String m_className;
    protected String m_prefix;
    protected int m_level;
    protected boolean m_showThread;
    protected boolean m_perThreadFiles;
    private static PrintStream m_ps = System.out;
    private static ThreadLocal t_f = new ThreadLocal();
    static int s_defaultLevel = 4;
    static final long s_startTime = System.currentTimeMillis();
    static Properties s_properties = new Properties();

    public static int getLevelSize() {
        return s_levels.length;
    }

    public static String getLevel(int n) {
        if (n >= Logger.getLevelSize()) {
            return null;
        }
        return s_levels[n];
    }

    public static Logger getInstance(Class clazz) {
        return new Logger(clazz.getName());
    }

    Logger(String string) {
        this.m_className = string;
        this.m_level = s_defaultLevel;
        block0: while (true) {
            int n;
            String string2;
            if ((string2 = (String)s_properties.get("xylemlog.logger." + string)) != null) {
                for (n = 0; n < s_levels.length; ++n) {
                    if (!string2.startsWith(s_levels[n])) continue;
                    this.m_level = n;
                    break block0;
                }
                throw new XylemError("ERR_SYSTEM", "unknown level '" + string2 + "' for " + string);
            }
            n = string.lastIndexOf(46);
            if (n < 0) break;
            string = string.substring(0, n);
        }
        this.m_prefix = this.m_className.substring(this.m_className.lastIndexOf(46) + 1) + ": ";
        this.m_showThread = s_properties.getProperty("xylemlog.appender.showThread") != null;
        this.m_perThreadFiles = s_properties.getProperty("xylemlog.appender.perThreadFiles") != null;
    }

    public void warn(Object object) {
        this.trace(object, null, 2);
    }

    public void info(Object object) {
        this.trace(object, null, 1);
    }

    public void debug(Object object) {
        this.trace(object, null, 0);
    }

    public void error(Object object) {
        this.trace(object, null, 3);
    }

    public void warn(Object object, Throwable throwable) {
        this.trace(object, throwable, 2);
    }

    public void info(Object object, Throwable throwable) {
        this.trace(object, throwable, 1);
    }

    public void debug(Object object, Throwable throwable) {
        this.trace(object, throwable, 0);
    }

    public void error(Object object, Throwable throwable) {
        this.trace(object, throwable, 3);
    }

    public void warn(Throwable throwable) {
        this.trace(null, throwable, 2);
    }

    public void info(Throwable throwable) {
        this.trace(null, throwable, 1);
    }

    public void debug(Throwable throwable) {
        this.trace(null, throwable, 0);
    }

    public void error(Throwable throwable) {
        this.trace(null, throwable, 3);
    }

    public boolean isDebugEnabled() {
        return this.m_level <= 0;
    }

    public void trace(Object object, Throwable throwable, int n) {
        if (this.m_level <= n) {
            String string = this.format(object, throwable, n);
            m_ps.print(string);
            if (this.m_perThreadFiles) {
                Writer writer = this.getThreadFile();
                try {
                    writer.write(string);
                    writer.flush();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private String format(Object object, Throwable throwable, int n) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        String string = "[" + (System.currentTimeMillis() - s_startTime) + "] ";
        for (int i = string.length(); i < 13; ++i) {
            printWriter.print(' ');
        }
        printWriter.print(string);
        printWriter.print(s_levels[n]);
        printWriter.print(' ');
        printWriter.print(this.m_prefix);
        if (object != null) {
            printWriter.println(object);
        }
        if (throwable != null) {
            throwable.printStackTrace(printWriter);
        }
        String string2 = Thread.currentThread().getName();
        if (this.m_showThread) {
            m_ps.print("[" + string2 + "] ");
        }
        return stringWriter.getBuffer().toString();
    }

    private Writer getThreadFile() {
        String string = Thread.currentThread().getName();
        Writer writer = (Writer)t_f.get();
        if (writer == null) {
            try {
                writer = new FileWriter(string + ".log");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                writer = new Writer(){

                    public void write(int n) throws IOException {
                    }

                    public void close() throws IOException {
                    }

                    public void flush() throws IOException {
                    }

                    public void write(char[] cArray, int n, int n2) throws IOException {
                    }
                };
            }
            t_f.set(writer);
        }
        return writer;
    }

    static {
        LogManager.initializeLogger();
    }
}

