/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem;

import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.ISpecialForm;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Module;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LambdaInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.StreamInstruction;
import com.ibm.xylem.utils.XylemError;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public final class IdentifierConsolidator {
    private static final Logger s_logger = Logger.getInstance(class$com$ibm$xylem$IdentifierConsolidator == null ? (class$com$ibm$xylem$IdentifierConsolidator = IdentifierConsolidator.class$("com.ibm.xylem.IdentifierConsolidator")) : class$com$ibm$xylem$IdentifierConsolidator);
    protected ArrayList m_objects = new ArrayList();
    protected ArrayList m_instructions = new ArrayList();
    protected ArrayList m_lambdaObjects = new ArrayList();
    protected ArrayList m_lambdaInstructions = new ArrayList();
    protected HashMap m_paramInstructions = new HashMap();
    protected int m_counter = 0;
    protected int m_lambdaCounter = 0;
    static /* synthetic */ Class class$com$ibm$xylem$IdentifierConsolidator;

    public void reset() {
        this.m_counter = 0;
        this.m_lambdaCounter = 0;
    }

    public int nextIdentifier() {
        if (this.m_counter == this.m_objects.size()) {
            Integer n = new Integer(this.m_counter);
            this.m_objects.add(n);
            this.m_instructions.add(new IdentifierInstruction(n));
        }
        return this.m_counter++;
    }

    public int nextLambdaIdentifier() {
        if (this.m_lambdaCounter == this.m_lambdaObjects.size()) {
            String string = "lambda_param_" + this.m_lambdaCounter;
            this.m_lambdaObjects.add(string);
            this.m_lambdaInstructions.add(new IdentifierInstruction(string));
        }
        return this.m_lambdaCounter++;
    }

    public Object getIdentifierName(int n) {
        return this.m_objects.get(n);
    }

    public Object getLambdaIdentifierName(int n) {
        return this.m_lambdaObjects.get(n);
    }

    public IdentifierInstruction getIdentifierInstruction(int n) {
        return (IdentifierInstruction)this.m_instructions.get(n);
    }

    public IdentifierInstruction getLambdaIdentifierInstruction(int n) {
        return (IdentifierInstruction)this.m_lambdaInstructions.get(n);
    }

    public void processModule(Module module) {
        s_logger.debug("starting consolidation");
        Iterator iterator = module.getFunctions().iterator();
        while (iterator.hasNext()) {
            this.processFunction((Function)iterator.next());
        }
        s_logger.debug("finished with consolidation");
    }

    public void processFunction(Function function) {
        this.reset();
        Module module = function.getTypeEnvironment().getModule();
        HashMap<Object, IdentifierInstruction> hashMap = new HashMap<Object, IdentifierInstruction>(64);
        HashSet<Object> hashSet = new HashSet<Object>();
        for (int i = 0; i < function.m_parameters.length; ++i) {
            Object object = function.m_parameters[i].getName();
            if (object instanceof Integer) {
                int n = this.nextIdentifier();
                IdentifierInstruction identifierInstruction = this.getIdentifierInstruction(n);
                Object object2 = this.getIdentifierName(n);
                hashMap.put(object, identifierInstruction);
                object = object2;
                function.m_parameters[i].setName(object);
                continue;
            }
            hashSet.add(object);
        }
        function.clearReducedTypeInformation();
        function.setBody(this.process(function.getBody(), hashSet, hashMap));
        try {
            function.typeCheckReduced(module, new LinkedList());
        }
        catch (TypeCheckException typeCheckException) {
            typeCheckException.printStackTrace();
        }
    }

    public Instruction processLambda(LambdaInstruction lambdaInstruction, BindingEnvironment bindingEnvironment) {
        this.reset();
        HashSet hashSet = new HashSet();
        lambdaInstruction.accumulateFreeBindings(hashSet, bindingEnvironment);
        HashMap<Object, IdentifierInstruction> hashMap = new HashMap<Object, IdentifierInstruction>(64);
        HashSet<Object> hashSet2 = new HashSet<Object>();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            IBinding iBinding = (IBinding)iterator.next();
            hashSet2.add(iBinding.getName());
        }
        for (int i = 0; i < lambdaInstruction.getParameters().length; ++i) {
            Object object = lambdaInstruction.getParameters()[i].getName();
            int n = this.nextLambdaIdentifier();
            IdentifierInstruction identifierInstruction = this.getLambdaIdentifierInstruction(n);
            Object object2 = this.getLambdaIdentifierName(n);
            hashMap.put(object, identifierInstruction);
            object = object2;
            lambdaInstruction.getParameters()[i].setName(object);
            bindingEnvironment.setVariableBinding(lambdaInstruction.getParameters()[i]);
        }
        LambdaInstruction lambdaInstruction2 = lambdaInstruction;
        lambdaInstruction2.setBody(this.process(lambdaInstruction2.getBody(), hashSet2, hashMap));
        return lambdaInstruction2;
    }

    protected Instruction processLetChain(LetInstruction letInstruction, Set set, HashMap hashMap) {
        Instruction instruction;
        LetInstruction letInstruction2;
        Instruction instruction2 = letInstruction2 = new LetInstruction("", null, null);
        while (true) {
            int n = this.nextIdentifier();
            Object object = letInstruction.getVariable();
            IdentifierInstruction identifierInstruction = this.getIdentifierInstruction(n);
            Object object2 = this.getIdentifierName(n);
            Instruction instruction3 = this.process(letInstruction.getValue(), set, hashMap);
            instruction2.setValue(instruction3);
            hashMap.put(object, identifierInstruction);
            instruction2.setName(object2);
            if (!(letInstruction.getBody() instanceof LetInstruction)) break;
            letInstruction = (LetInstruction)letInstruction.getBody();
            instruction = new LetInstruction("", null, null);
            instruction2.setBody(instruction);
            instruction2 = instruction;
        }
        instruction = this.process(letInstruction.getBody(), set, hashMap);
        instruction2.setBody(instruction);
        return letInstruction2;
    }

    public Instruction process(Instruction instruction, Set set, HashMap hashMap) {
        Object object;
        if (instruction instanceof StreamInstruction && ((StreamInstruction)instruction).isStoredAsString()) {
            return instruction;
        }
        if (instruction instanceof LetInstruction) {
            return this.processLetChain((LetInstruction)instruction, set, hashMap);
        }
        if (instruction instanceof IdentifierInstruction) {
            return this.processIdentifier((IdentifierInstruction)instruction, set, hashMap);
        }
        int n = instruction.getChildInstructionCount();
        if (n == 0) {
            return instruction;
        }
        Instruction instruction2 = null;
        if (instruction instanceof ISpecialForm) {
            instruction2 = instruction.cloneShallow();
            ISpecialForm iSpecialForm = (ISpecialForm)((Object)instruction);
            object = (ISpecialForm)((Object)instruction2);
            for (int i = 0; i < n; ++i) {
                IBinding[] iBindingArray = iSpecialForm.getChildInstructionBindings(i);
                IBinding[] iBindingArray2 = object.getChildInstructionBindings(i);
                if (iBindingArray == null) continue;
                for (int j = 0; j < iBindingArray.length; ++j) {
                    int n2 = this.nextIdentifier();
                    Object object2 = iBindingArray[j].getName();
                    IdentifierInstruction identifierInstruction = this.getIdentifierInstruction(n2);
                    Object object3 = this.getIdentifierName(n2);
                    hashMap.put(object2, identifierInstruction);
                    iBindingArray2[j].setName(object3);
                }
            }
        }
        for (int i = n - 1; i >= 0; --i) {
            object = instruction.getChildInstruction(i);
            Instruction instruction3 = this.process((Instruction)object, set, hashMap);
            if (instruction3 == object) continue;
            if (instruction2 == null) {
                instruction2 = instruction.cloneShallow();
            }
            instruction2.setChildInstruction(i, instruction3);
        }
        if (instruction2 != null) {
            return instruction2;
        }
        return instruction;
    }

    protected Instruction processIdentifier(IdentifierInstruction identifierInstruction, Set set, HashMap hashMap) {
        Object object = identifierInstruction.getVariable();
        if (set.contains(object)) {
            Instruction instruction = (Instruction)this.m_paramInstructions.get(object);
            if (instruction == null) {
                this.m_paramInstructions.put(object, identifierInstruction);
                instruction = identifierInstruction;
            }
            return instruction;
        }
        Instruction instruction = (Instruction)hashMap.get(object);
        if (instruction == null) {
            throw new XylemError("ERR_SYSTEM", "unbound(?):" + identifierInstruction);
        }
        return instruction;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

