/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem;

import com.ibm.xylem.Instruction;
import com.ibm.xylem.Module;
import com.ibm.xylem.ModuleImportDirective;
import com.ibm.xylem.ModuleSignature;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.ModuleFunctionCallInstruction;
import java.io.IOException;

public class FunctorApplicationDirective
extends ModuleImportDirective {
    private static final long serialVersionUID = -6949170961858987141L;
    protected String m_functorName;
    protected Object[] m_modulesToApply;
    private static int s_applications = 0;
    protected int m_index = s_applications++;

    public FunctorApplicationDirective() {
    }

    public void read(ReadObjectFileHelper readObjectFileHelper) throws Exception {
        this.m_functorName = readObjectFileHelper.readString();
    }

    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        writeObjectFileHelper.writeString(this.m_functorName);
    }

    public FunctorApplicationDirective(String string, ModuleSignature moduleSignature, String string2, Object[] objectArray) {
        super(string, moduleSignature);
        this.m_functorName = string2;
        this.m_modulesToApply = objectArray;
    }

    public Instruction translateFunctionCall(ModuleFunctionCallInstruction moduleFunctionCallInstruction, Module module) {
        Instruction[] instructionArray = moduleFunctionCallInstruction.m_parameters;
        Instruction[] instructionArray2 = new Instruction[instructionArray.length + 1];
        System.arraycopy(instructionArray, 0, instructionArray2, 0, instructionArray.length);
        instructionArray2[instructionArray.length] = LiteralInstruction.integerLiteral(this.m_index);
        return new FunctionCallInstruction(FunctorApplicationDirective.translateFunctionName(moduleFunctionCallInstruction.getFunction(), this.m_functorName), instructionArray2);
    }

    public void toString(PrettyPrinter prettyPrinter, int n) {
        prettyPrinter.printFormOpen("apply-functor", n);
        prettyPrinter.print(" " + this.getLocalName() + "@");
        prettyPrinter.print(this.m_signature);
        prettyPrinter.print(" " + this.m_functorName);
        for (int i = 0; i < this.m_modulesToApply.length; ++i) {
            prettyPrinter.print(" " + this.m_modulesToApply[i]);
        }
        prettyPrinter.printFormClose(n);
    }
}

