/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem;

import com.ibm.xylem.ITypeStore;
import com.ibm.xylem.Logger;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.types.AbstractDataType;
import com.ibm.xylem.types.AbstractDataTypeLambda;
import com.ibm.xylem.types.ClassType;
import com.ibm.xylem.types.CompoundType;
import com.ibm.xylem.types.ConstructorDataType;
import com.ibm.xylem.types.TypeLambda;
import com.ibm.xylem.types.TypeVariable;
import com.ibm.xylem.utils.XylemError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class AbstractTypeStore
implements ITypeStore {
    static final Logger s_logger = Logger.getInstance(class$com$ibm$xylem$AbstractTypeStore == null ? (class$com$ibm$xylem$AbstractTypeStore = AbstractTypeStore.class$("com.ibm.xylem.AbstractTypeStore")) : class$com$ibm$xylem$AbstractTypeStore);
    protected HashMap m_classes = new HashMap();
    protected HashMap m_compoundTypes = new HashMap();
    protected HashMap m_constructors = new HashMap();
    protected HashMap m_adts = new HashMap();
    protected HashMap m_typeAliases = new HashMap();
    protected ArrayList m_adtDefinitions = new ArrayList();
    protected HashMap m_genericADTs = new HashMap();
    protected HashMap m_typeLambdas = new HashMap();
    protected String m_name = "";
    Comparator m_comp = new Comparator(){

        public int compare(Object object, Object object2) {
            return ((AbstractDataType)object).getName().compareTo(((AbstractDataType)object2).getName());
        }
    };
    static /* synthetic */ Class class$com$ibm$xylem$AbstractTypeStore;

    public final void addAbstractDataType(AbstractDataType abstractDataType) {
        int n = Collections.binarySearch(this.m_adtDefinitions, abstractDataType, this.m_comp);
        if (n >= 0) {
            this.m_adtDefinitions.set(n, abstractDataType);
        } else {
            this.m_adtDefinitions.add(-n - 1, abstractDataType);
        }
        this.m_adts.put(abstractDataType.getName(), abstractDataType);
        this.m_compoundTypes.put(abstractDataType.getName(), abstractDataType);
        for (int i = 0; i < abstractDataType.m_constructors.length; ++i) {
            this.m_constructors.put(abstractDataType.m_constructors[i].getName(), abstractDataType.m_constructors[i]);
        }
        abstractDataType.setTypeStore(this);
    }

    public AbstractDataType.Constructor getConstructor(String string) {
        return (AbstractDataType.Constructor)this.m_constructors.get(string);
    }

    public CompoundType lookupCompoundType(String string) {
        return (CompoundType)this.m_compoundTypes.get(string);
    }

    public final Iterator getAbstractDataTypesIterator() {
        return this.m_adtDefinitions.iterator();
    }

    public final List getAbstractDataTypes() {
        return Collections.unmodifiableList(this.m_adtDefinitions);
    }

    public int getAbstractDataTypesCount() {
        return this.m_adtDefinitions.size();
    }

    public void addTypeAlias(String string, Type type) {
        if (this.m_typeAliases.containsKey(string)) {
            this.m_typeAliases.remove(string);
        }
        this.m_typeAliases.put(string, type);
    }

    public Type lookupTypeAlias(String string) {
        return (Type)this.m_typeAliases.get(string);
    }

    public Collection getTypeAliases() {
        return this.m_typeAliases.values();
    }

    public Set getTypeAliasNames() {
        return this.m_typeAliases.keySet();
    }

    public void addClass(ClassType classType) {
        this.m_classes.put(classType.getName(), classType);
        this.m_compoundTypes.put(classType.getName(), classType);
        classType.setTypeStore(this);
    }

    public int getClassesCount() {
        return this.m_classes.size();
    }

    public Iterator getClassesIterator() {
        return this.m_classes.values().iterator();
    }

    public static void readTypes(ITypeStore iTypeStore, ReadObjectFileHelper readObjectFileHelper) throws Exception {
        Object object;
        int n;
        CompoundType compoundType;
        int n2;
        int n3 = readObjectFileHelper.readInt();
        s_logger.debug("[AbstractTypeStore.readTypes] there are " + n3 + " ADTs");
        for (n2 = 0; n2 < n3; ++n2) {
            compoundType = new ConstructorDataType();
            ((ConstructorDataType)compoundType).read(readObjectFileHelper);
            s_logger.debug("[AbstractTypeStore.readTypes] adding a CDT: " + compoundType);
            iTypeStore.addAbstractDataType((AbstractDataType)compoundType);
        }
        n3 = readObjectFileHelper.readInt();
        for (n2 = 0; n2 < n3; ++n2) {
            compoundType = new ClassType();
            ((ClassType)compoundType).read(readObjectFileHelper);
            iTypeStore.addClass((ClassType)compoundType);
        }
        n2 = readObjectFileHelper.readInt();
        for (n = 0; n < n2; ++n) {
            object = readObjectFileHelper.readString();
            TypeLambda typeLambda = readObjectFileHelper.readTypeLambda();
            iTypeStore.addTypeLambda((String)object, typeLambda);
        }
        n3 = readObjectFileHelper.readInt();
        s_logger.debug("[AbstractTypeStore.read] there are " + n3 + " generic ADTs");
        for (n = 0; n < n3; ++n) {
            object = AbstractDataTypeLambda.read_static(iTypeStore.getName(), readObjectFileHelper);
            s_logger.debug("[AbstractTypeStore.read] adding a generic ADT: " + object);
            iTypeStore.addGenericAbstractDataType(((CompoundType)object).getName(), ((AbstractDataTypeLambda)object).getTypeParameters(), ((AbstractDataTypeLambda)object).m_constructors);
        }
    }

    public static void writeTypes(ITypeStore iTypeStore, WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Iterator iterator = iTypeStore.getAbstractDataTypesIterator();
        writeObjectFileHelper.writeInt(iTypeStore.getAbstractDataTypesCount());
        while (iterator.hasNext()) {
            object3 = (AbstractDataType)iterator.next();
            ((CompoundType)object3).write(writeObjectFileHelper);
        }
        iterator = iTypeStore.getClassesIterator();
        writeObjectFileHelper.writeInt(iTypeStore.getClassesCount());
        while (iterator.hasNext()) {
            object3 = (ClassType)iterator.next();
            ((ClassType)object3).write(writeObjectFileHelper);
        }
        object3 = iTypeStore.getTypeLambdaNamesIterator();
        writeObjectFileHelper.writeInt(iTypeStore.getTypeLambdasCount());
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            writeObjectFileHelper.writeString((String)object2);
            object = iTypeStore.lookupTypeLambda((String)object2);
            writeObjectFileHelper.writeTypeLambda((TypeLambda)object);
        }
        object2 = iTypeStore.getGenericAbstractDataTypesIterator();
        writeObjectFileHelper.writeInt(iTypeStore.getGenericAbstractDataTypesCount());
        while (object2.hasNext()) {
            object = iTypeStore.getGenericADT((String)object2.next());
            ((AbstractDataTypeLambda)object).write(writeObjectFileHelper);
        }
    }

    public TypeLambda lookupTypeLambda(String string) {
        return (TypeLambda)this.m_typeLambdas.get(string);
    }

    public void addTypeLambda(String string, TypeLambda typeLambda) {
        this.m_typeLambdas.put(string, typeLambda);
    }

    public int getTypeLambdasCount() {
        return this.m_typeLambdas.size();
    }

    public Iterator getTypeLambdaNamesIterator() {
        return this.m_typeLambdas.keySet().iterator();
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public boolean matchesName(String string) {
        return string == null || string.length() == 0 || string.equals(this.m_name);
    }

    public void addGenericAbstractDataType(String string, TypeVariable[] typeVariableArray, AbstractDataType.Constructor[] constructorArray) {
        if (this.m_genericADTs.containsKey(string)) {
            throw new XylemError("ERR_SYSTEM", "Tried to redefine generic abstract data type " + string + " in type store " + this.getName());
        }
        s_logger.debug("[AbstractDataTypeStore.addGenericAbstractDataType] I am " + this.hashCode() + " (" + this.getClass().toString() + ")");
        s_logger.debug("[AbstractDataTypeStore.addGenericAbstractDataType] adding generic ADT " + string + " to type store " + this.getName());
        AbstractDataTypeLambda abstractDataTypeLambda = new AbstractDataTypeLambda(this.getName(), string, typeVariableArray, constructorArray);
        this.m_genericADTs.put(string, abstractDataTypeLambda);
        abstractDataTypeLambda.setTypeStore(this);
        for (int i = 0; i < constructorArray.length; ++i) {
            if (this.m_constructors.get(constructorArray[i].getName()) != null) {
                s_logger.debug("WARNING: variant type " + constructorArray[i].getName() + " shadows a previous definition!");
            }
            s_logger.debug("[AbstractDataTypeStore.addGenericAbstractDataType] adding generic constructor " + constructorArray[i].getName());
            this.m_constructors.put(constructorArray[i].getName(), constructorArray[i]);
        }
    }

    public AbstractDataTypeLambda getGenericADT(String string) {
        return (AbstractDataTypeLambda)this.m_genericADTs.get(string);
    }

    public AbstractDataType instantiateGenericADT(String string, Type[] typeArray) {
        AbstractDataTypeLambda abstractDataTypeLambda = this.getGenericADT(string);
        if (abstractDataTypeLambda == null) {
            throw new RuntimeException("Tried to instantiate a non-existant generic ADT: " + string);
        }
        return this.instantiateGenericADT(abstractDataTypeLambda, typeArray);
    }

    public AbstractDataType instantiateGenericADT(AbstractDataTypeLambda abstractDataTypeLambda, Type[] typeArray) {
        if (abstractDataTypeLambda == null) {
            throw new XylemError("ERR_SYSTEM", "generic adt was null");
        }
        s_logger.debug("[AbstractDataTypeStore.instantiateGenericADT] instantiating generic ADT " + abstractDataTypeLambda.getName() + " in type store " + this.getName());
        AbstractDataType abstractDataType = abstractDataTypeLambda.applyADT(this, typeArray);
        this.addAbstractDataType(abstractDataType);
        return abstractDataType;
    }

    public Iterator getGenericAbstractDataTypesIterator() {
        return this.m_genericADTs.keySet().iterator();
    }

    public int getGenericAbstractDataTypesCount() {
        return this.m_genericADTs.size();
    }

    protected void clearADTs() {
        this.m_adts.clear();
        this.m_adtDefinitions.clear();
        this.m_constructors.clear();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

