/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.xylem.xpath20.typesystem;

import com.ibm.xtq.xml.utils.QName;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;

public class PrettyPrinter {
    protected HashMap m_prefixes = new HashMap();
    protected PrintWriter m_pw;
    protected int m_indent = 0;
    protected int m_lineMax = 100;
    protected int m_pos = 0;
    protected int m_uniquePrefixCount = 0;
    public boolean m_suppressNewlines = false;

    public PrettyPrinter(PrintWriter printWriter) {
        this.m_pw = printWriter;
    }

    public String generateUniquePrefix() {
        String string;
        while (this.m_prefixes.containsKey(string = "ns" + ++this.m_uniquePrefixCount)) {
        }
        return string;
    }

    public void printQName(QName qName) {
        String string = qName.getNamespaceURI();
        if (string == null || string.length() == 0) {
            this.printToken(qName.getLocalPart());
            return;
        }
        String string2 = qName.getPrefix();
        if (string2 == null || string2.length() == 0) {
            string2 = this.generateUniquePrefix();
        }
        if (!this.m_prefixes.containsKey(string2)) {
            this.m_prefixes.put(string2, string);
        } else if (!this.m_prefixes.get(string2).equals(string)) {
            string2 = this.generateUniquePrefix();
            this.m_prefixes.put(string2, string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append(':');
        stringBuffer.append(qName.getLocalPart());
        this.printToken(stringBuffer.toString());
    }

    public void printToken(String string) {
        int n = string.length() + 1;
        if (n + this.m_pos > this.m_lineMax) {
            this.newline();
        }
        this.m_pw.print(string);
        this.m_pw.print(' ');
        this.m_pos += n;
    }

    public void indent() {
        ++this.m_indent;
    }

    public void outdent() {
        --this.m_indent;
    }

    public void newline() {
        if (this.m_suppressNewlines || this.m_pos == this.m_indent * 2) {
            return;
        }
        this.m_pw.println();
        this.m_pos = 0;
        for (int i = 0; i < this.m_indent; ++i) {
            this.m_pw.print("  ");
            this.m_pos += 2;
        }
    }

    public String generatePrefixes() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.m_prefixes.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (k.equals("xs") || k.equals("xdt")) continue;
            Object v = this.m_prefixes.get(k);
            stringBuffer.append("namespace ");
            stringBuffer.append(k);
            stringBuffer.append(" = \"");
            stringBuffer.append(v);
            stringBuffer.append('\"');
            if (!this.m_suppressNewlines) {
                stringBuffer.append('\n');
                continue;
            }
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }
}

