/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.xylem.partialeval;

import com.ibm.xtq.xslt.xylem.instructions.ArithmeticInstruction;
import com.ibm.xtq.xslt.xylem.instructions.CoerceInstruction;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Type;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.PrimitiveArithmeticInstruction;
import com.ibm.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xylem.optimizers.partialeval.PartialInformationCollector;
import com.ibm.xylem.types.DoubleType;
import com.ibm.xylem.types.INumericalType;
import com.ibm.xylem.types.IntType;

public class ArithmeticEvaluator
extends PartialEvaluator {
    public PartialEvaluationResult extractPartialInformation(Instruction instruction, PartialInformationCollector partialInformationCollector, LetInstruction letInstruction, LetChainManager letChainManager) {
        ArithmeticInstruction arithmeticInstruction = (ArithmeticInstruction)instruction;
        Instruction instruction2 = arithmeticInstruction.getOperand1();
        Instruction instruction3 = arithmeticInstruction.getOperand2();
        Type type = partialInformationCollector.resolveType(instruction2);
        Type type2 = partialInformationCollector.resolveType(instruction3);
        if (!(type instanceof INumericalType)) {
            type = DoubleType.s_doubleType;
            instruction2 = letChainManager.insertBody2(new CoerceInstruction(instruction2, type), letInstruction);
            arithmeticInstruction.setChildInstruction(0, instruction2);
        }
        if (!(type2 instanceof INumericalType)) {
            type2 = DoubleType.s_doubleType;
            instruction3 = letChainManager.insertBody2(new CoerceInstruction(instruction3, type2), letInstruction);
            arithmeticInstruction.setChildInstruction(1, instruction3);
        }
        if (IntType.s_intType.equals(type) && IntType.s_intType.equals(type2) || DoubleType.s_doubleType.equals(type) && DoubleType.s_doubleType.equals(type2)) {
            int n = 0;
            switch (arithmeticInstruction.getOperation()) {
                case 4: {
                    n = 0;
                    break;
                }
                case 5: {
                    n = 1;
                    break;
                }
                case 30: {
                    n = 2;
                    break;
                }
                case 31: {
                    n = 3;
                    break;
                }
                case 33: {
                    n = 4;
                }
            }
            return new PartialEvaluationResult((Instruction)new PrimitiveArithmeticInstruction(instruction2, instruction3, n), true);
        }
        partialInformationCollector.partiallyEvaluate(instruction2, letChainManager);
        partialInformationCollector.partiallyEvaluate(instruction3, letChainManager);
        return PartialEvaluationResult.s_emptyResult;
    }
}

