/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.xylem.optimizers;

import com.ibm.xtq.xslt.xylem.optimizers.XSLTPartialEvaluationOptimizer;
import com.ibm.xylem.BindingDependencyInfo;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Module;
import com.ibm.xylem.NavigationUtilities;
import com.ibm.xylem.Optimizer;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.TailRecursiveOptimizer;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.instructions.ChooseInstruction;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.optimizers.OptimizerUtilities;
import com.ibm.xylem.optimizers.partialeval.AutomatonFunctionCallEvaluator;
import com.ibm.xylem.optimizers.partialeval.EvaluatorDiscoveringPartialInformationCollector;
import com.ibm.xylem.optimizers.partialeval.PartialInformationCollector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AutomatonFunctionCallExtractionOptimizer
extends TailRecursiveOptimizer {
    HashMap m_functionInfo = new HashMap();
    HashSet m_affectedFunctions = new HashSet();

    public static final BindingDependencyInfo skipPastLets(BindingDependencyInfo bindingDependencyInfo, Map map) {
        while (bindingDependencyInfo.m_parent instanceof LetInstruction && bindingDependencyInfo.m_parentIndex == 0) {
            IBinding iBinding = ((LetInstruction)bindingDependencyInfo.m_parent).getBinding();
            List list = (List)map.get(iBinding);
            if (list == null) {
                return null;
            }
            if (list.size() != 1) {
                return null;
            }
            bindingDependencyInfo = (BindingDependencyInfo)list.get(0);
        }
        return bindingDependencyInfo;
    }

    protected Instruction optimizeStep2(Instruction instruction) {
        if (instruction instanceof FunctionCallInstruction) {
            FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction;
            Function function = this.getCurrentFunction().getTypeEnvironment().getModule().getFunction(functionCallInstruction.getFunction());
            Object v = this.m_functionInfo.get(function);
            if (v != null) {
                Info info = (Info)v;
                Function function2 = function.lookupDerivative(this);
                FunctionCallInstruction functionCallInstruction2 = (FunctionCallInstruction)functionCallInstruction.cloneReduced();
                ArrayList<LetInstruction> arrayList = new ArrayList<LetInstruction>();
                for (int i = 0; i < info.m_fcis.length; ++i) {
                    if (info.m_fcis[i] == null) continue;
                    Integer n = ReductionHelper.generateIntermediateIdentifier2();
                    FunctionCallInstruction functionCallInstruction3 = (FunctionCallInstruction)info.m_fcis[i].cloneReduced();
                    functionCallInstruction3.setChildInstruction(0, functionCallInstruction2.getChildInstruction(i));
                    arrayList.add(new LetInstruction(n, functionCallInstruction3, null));
                    functionCallInstruction2.setChildInstruction(i, new IdentifierInstruction(n));
                }
                functionCallInstruction2.setFunction(function2.getName());
                ChooseInstruction chooseInstruction = new ChooseInstruction(new ChooseInstruction.Case[]{new ChooseInstruction.Case(LiteralInstruction.booleanTrueLiteral(), OptimizerUtilities.reconstructLets(functionCallInstruction2, arrayList))}, null);
                ((Instruction)chooseInstruction).typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList());
                this.m_affectedFunctions.add(this.getCurrentFunction().getName());
                return chooseInstruction;
            }
        }
        return instruction;
    }

    public void optimizeFunction(Function function) {
        if (function.hasBeenTypeChecked()) {
            super.optimizeFunction(function);
        }
    }

    void doAnalysisPhase(Module module) {
        module.optimize(new Analyzer());
    }

    public static void doOptimization(Module module, Set set) {
        final PartialInformationCollector[] partialInformationCollectorArray = new PartialInformationCollector[1];
        final HashSet hashSet = new HashSet(module.getFunctionNames());
        for (int i = 0; i < 10; ++i) {
            AutomatonFunctionCallExtractionOptimizer automatonFunctionCallExtractionOptimizer = new AutomatonFunctionCallExtractionOptimizer();
            automatonFunctionCallExtractionOptimizer.doAnalysisPhase(module);
            if (automatonFunctionCallExtractionOptimizer.m_functionInfo.isEmpty()) {
                if (i > 0) {
                    module.optimize(new XSLTPartialEvaluationOptimizer(set));
                }
                return;
            }
            module.optimize(automatonFunctionCallExtractionOptimizer);
            module.optimize(new XSLTPartialEvaluationOptimizer(automatonFunctionCallExtractionOptimizer.m_affectedFunctions){

                public void optimizeFunction(Function function) {
                    if (this.m_entryPoints.contains(function.getName())) {
                        if (partialInformationCollectorArray[0] == null) {
                            partialInformationCollectorArray[0] = new EvaluatorDiscoveringPartialInformationCollector(function.getBody(), this.m_evaluators, function);
                            partialInformationCollectorArray[0].m_completedFunctions.addAll(hashSet);
                        }
                        partialInformationCollectorArray[0].m_completedFunctions.remove(function.getName());
                        partialInformationCollectorArray[0].partiallyEvaluateFunction(function);
                    }
                }
            });
            module.removeDeadFunctions();
        }
    }

    class Analyzer
    extends Optimizer {
        Info m_info;

        Analyzer() {
        }

        public void optimizeFunction(Function function) {
            Object object;
            if (function.getBindingEnvironment() == null) {
                return;
            }
            this.m_currentFunction = function;
            HashMap hashMap = new HashMap();
            function.determineDataDependencies(function.m_parameters, hashMap);
            int n = function.m_parameters.length;
            FunctionCallInstruction[] functionCallInstructionArray = new FunctionCallInstruction[n];
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                List list = (List)hashMap.get(function.m_parameters[i]);
                if (list == null || list.size() != 1 || (object = AutomatonFunctionCallExtractionOptimizer.skipPastLets((BindingDependencyInfo)list.get(0), hashMap)) == null || !(((BindingDependencyInfo)object).m_parent instanceof FunctionCallInstruction)) continue;
                FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)((BindingDependencyInfo)object).m_parent;
                Function function2 = function.getTypeEnvironment().getModule().getFunction(functionCallInstruction.getFunction());
                if (functionCallInstruction.getChildInstructionCount() != 2 || !AutomatonFunctionCallEvaluator.isAutomatonFunctionAugmented(function2)) continue;
                if (functionCallInstruction.getChildInstruction(1).isStatic(function.getBindingEnvironment())) {
                    functionCallInstructionArray[i] = functionCallInstruction;
                    bl = true;
                    continue;
                }
                s_logger.debug("Missed opportunity to extract automaton call: " + function.getName());
            }
            if (bl) {
                Function function3 = function.cloneFunctionForFixup(AutomatonFunctionCallExtractionOptimizer.this, true, true, true);
                for (int i = 0; i < n; ++i) {
                    if (functionCallInstructionArray[i] == null) continue;
                    object = this.resolveType(functionCallInstructionArray[i]);
                    function3.m_parameters[i].setType((Type)object);
                }
                function.getTypeEnvironment().getModule().addFunction(function3);
                Info info = new Info(functionCallInstructionArray, function, function3);
                AutomatonFunctionCallExtractionOptimizer.this.m_functionInfo.put(function, info);
                this.m_info = info;
                this.m_currentFunction = function3;
                function3.setBody(this.optimize(function3.getBody()));
                this.m_info = null;
            }
        }

        protected Instruction optimizeStep(Instruction instruction, Instruction instruction2, int n) {
            if (instruction instanceof FunctionCallInstruction) {
                for (int i = 0; i < this.m_info.m_fcis.length; ++i) {
                    if (this.m_info.m_fcis[i] == null || !this.m_info.m_originals[i].toString().equals(instruction.toString())) continue;
                    return new IdentifierInstruction(this.m_currentFunction.m_parameters[i].getName());
                }
            }
            return super.optimizeStep(instruction, instruction2, n);
        }
    }

    static class Info {
        FunctionCallInstruction[] m_originals;
        FunctionCallInstruction[] m_fcis;
        Type[] m_types;
        Function m_newFunction;

        Info(FunctionCallInstruction[] functionCallInstructionArray, Function function, Function function2) {
            this.m_originals = functionCallInstructionArray;
            this.m_fcis = new FunctionCallInstruction[functionCallInstructionArray.length];
            this.m_types = new Type[functionCallInstructionArray.length];
            this.m_newFunction = function2;
            for (int i = 0; i < functionCallInstructionArray.length; ++i) {
                FunctionCallInstruction functionCallInstruction = functionCallInstructionArray[i];
                if (functionCallInstruction == null) continue;
                this.m_fcis[i] = (FunctionCallInstruction)functionCallInstruction.cloneReduced();
                TypeEnvironment typeEnvironment = function.getTypeEnvironment();
                BindingEnvironment bindingEnvironment = function.getBindingEnvironment();
                this.m_fcis[i].setChildInstruction(1, NavigationUtilities.resolveReducedIdentifier(functionCallInstruction.getChildInstruction(1), bindingEnvironment).cloneReduced());
                this.m_types[i] = functionCallInstruction.getType(typeEnvironment, bindingEnvironment).resolveType(typeEnvironment);
            }
        }
    }
}

