/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.typechecker.v1;

import com.ibm.xtq.ast.XPath20Exception;
import com.ibm.xtq.ast.nodes.Expr;
import com.ibm.xtq.ast.nodes.FunctionCall;
import com.ibm.xtq.ast.nodes.Message;
import com.ibm.xtq.ast.nodes.Node;
import com.ibm.xtq.ast.nodes.OperatorExpr;
import com.ibm.xtq.ast.nodes.PathExpr;
import com.ibm.xtq.ast.nodes.SimpleNode;
import com.ibm.xtq.ast.nodes.StepExpr;
import com.ibm.xtq.ast.nodes.TopLevelDecl;
import com.ibm.xtq.ast.nodes.VariableBase;
import com.ibm.xtq.ast.nodes.VariableRef;
import com.ibm.xtq.ast.nodes.XTQProgram;
import com.ibm.xtq.ast.parsers.xpath.XPathTreeConstants;
import com.ibm.xtq.ast.res.ASTMsg;
import com.ibm.xtq.common.utils.Assert;
import com.ibm.xtq.xslt.drivers.XPathCompiler;
import com.ibm.xtq.xslt.translator.ASTDecorator;
import com.ibm.xtq.xslt.translator.ASTDecorator1;
import com.ibm.xtq.xslt.translator.TranslatorHelper;
import com.ibm.xtq.xslt.translator.XSLTCHelper;
import com.ibm.xtq.xslt.typechecker.TypeCheckError;
import com.ibm.xtq.xslt.typechecker.v1.CastHelper;
import com.ibm.xtq.xslt.typechecker.v1.FunctionTypeChecker;
import com.ibm.xtq.xslt.typechecker.v1.types.IntType;
import com.ibm.xtq.xslt.typechecker.v1.types.MethodType;
import com.ibm.xtq.xslt.typechecker.v1.types.NodeType;
import com.ibm.xtq.xslt.typechecker.v1.types.NumberType;
import com.ibm.xtq.xslt.typechecker.v1.types.Type;
import javax.xml.namespace.QName;

public class XPathTypeChecker
extends FunctionTypeChecker {
    public XPathTypeChecker(XPathCompiler xPathCompiler) {
        super(xPathCompiler);
    }

    public Type visitExpression(Expr expr) throws TypeCheckError {
        switch (expr.getId()) {
            case 101: {
                return this.parenthesizedExpression(expr);
            }
            case 40: {
                return this.genericExpression(expr);
            }
            case 186: {
                return this.pattern(expr);
            }
            case 187: {
                return this.pathPattern(expr);
            }
            case 84: {
                return this.slashSlashPattern(expr);
            }
            case 188: {
                return this.stepPattern(expr);
            }
            case 5: {
                return this.stringLiteral(expr);
            }
            case 100: {
                return this.variableOrParameterReference(expr);
            }
            case 57: {
                return this.orExpression(expr);
            }
            case 58: {
                return this.andExpression(expr);
            }
            case 59: {
                return this.comparisonExpression(expr);
            }
            case 61: {
                return this.additiveExpression(expr);
            }
            case 62: {
                return this.multiplicativeExpression(expr);
            }
            case 69: {
                return this.unaryExpression(expr);
            }
            case 63: {
                return this.unionExpression(expr);
            }
            case 82: {
                return this.pathExpression(expr);
            }
            case 85: {
                return this.stepExpression(expr);
            }
            case 97: {
                return this.integerLiteral(expr);
            }
            case 98: {
                return this.decimalLiteral(expr);
            }
            case 99: {
                return this.doubleLiteral(expr);
            }
            case 105: {
                Type type = expr.isRootOnSelfNode() ? Type.NodeSet : this.visitFunction((FunctionCall)expr);
                ASTDecorator1.setType(expr, type);
                return type;
            }
            case 102: {
                return this.contextItemExpression(expr);
            }
            case 228: {
                return this.stringLiteral(expr);
            }
        }
        Assert.throwError(false, "Unsupported expression should be removed before type check phase: " + XPathTreeConstants.jjtNodeName[expr.getId()]);
        return Type.Void;
    }

    protected Type additiveExpression(Expr expr) throws TypeCheckError {
        return this.binaryOperatorExpression(expr);
    }

    private Type binaryOperatorExpression(Expr expr) throws TypeCheckError {
        OperatorExpr operatorExpr = (OperatorExpr)expr;
        Expr expr2 = operatorExpr.getOperand(0);
        Expr expr3 = operatorExpr.getOperand(1);
        Type type = this.visitExpression(expr2);
        Type type2 = this.visitExpression(expr3);
        MethodType methodType = this.getCompiler().getFOHelper().resolveOperator(operatorExpr.getOperatorChar(), new MethodType(Type.Void, type, type2));
        Type type3 = null;
        if (methodType != null) {
            Type type4;
            Type type5 = (Type)methodType.argsType().get(0);
            if (!type5.identicalTo(type)) {
                CastHelper.setExpressionCastType(expr2, type5);
            }
            if (!(type4 = (Type)methodType.argsType().get(1)).identicalTo(type2)) {
                CastHelper.setExpressionCastType(expr3, type4);
            }
            type3 = methodType.resultType();
        } else {
            this._parser.reportError(3, new ASTMsg("TYPE_CHECK_OP_ERR", (Object)operatorExpr.getOperatorChar(), expr));
            type3 = Type.Reference;
        }
        ASTDecorator1.setType(operatorExpr, type3);
        return type3;
    }

    protected Type andExpression(Expr expr) throws TypeCheckError {
        return this.binaryOperatorExpression(expr);
    }

    protected Type orExpression(Expr expr) throws TypeCheckError {
        return this.binaryOperatorExpression(expr);
    }

    protected Type comparisonExpression(Expr expr) throws TypeCheckError {
        OperatorExpr operatorExpr = (OperatorExpr)expr;
        short s = operatorExpr.getOperatorType();
        if (s == 14 || s == 13) {
            return this.equalityExpression(operatorExpr);
        }
        if (s == 15 || s == 17 || s == 16 || s == 18) {
            return this.relationalExpression(operatorExpr);
        }
        ASTMsg aSTMsg = new ASTMsg("TYPE_CHECK_OP_ERR", (Object)operatorExpr.getOperatorChar(), expr);
        this._parser.reportError(3, aSTMsg);
        return Type.Boolean;
    }

    private Type equalityExpression(OperatorExpr operatorExpr) throws TypeCheckError {
        Expr expr = operatorExpr.getOperand(0);
        Expr expr2 = operatorExpr.getOperand(1);
        Type type = this.visitExpression(expr);
        Type type2 = this.visitExpression(expr2);
        if (type.isSimple() && type2.isSimple()) {
            if (type != type2) {
                if (type == Type.Boolean) {
                    CastHelper.setExpressionCastType(expr2, Type.Boolean);
                } else if (type2 == Type.Boolean) {
                    CastHelper.setExpressionCastType(expr, Type.Boolean);
                } else if (type instanceof NumberType || type2 instanceof NumberType) {
                    CastHelper.setExpressionCastType(expr, Type.Real);
                    CastHelper.setExpressionCastType(expr2, Type.Real);
                } else {
                    CastHelper.setExpressionCastType(expr, Type.String);
                    CastHelper.setExpressionCastType(expr2, Type.String);
                }
            }
        } else if (type == Type.Reference) {
            CastHelper.setExpressionCastType(expr2, Type.Reference);
        } else if (type2 == Type.Reference) {
            CastHelper.setExpressionCastType(expr, Type.Reference);
        } else if (type instanceof NodeType && type2 == Type.String) {
            CastHelper.setExpressionCastType(expr, Type.String);
        } else if (type == Type.String && type2 instanceof NodeType) {
            CastHelper.setExpressionCastType(expr2, Type.String);
        } else if (type instanceof NodeType && type2 instanceof NodeType) {
            CastHelper.setExpressionCastType(expr, Type.String);
            CastHelper.setExpressionCastType(expr2, Type.String);
        } else if (!(type instanceof NodeType && type2 == Type.NodeSet || type == Type.NodeSet && type2 instanceof NodeType)) {
            if (type instanceof NodeType) {
                CastHelper.setExpressionCastType(expr, Type.NodeSet);
            }
            if (type2 instanceof NodeType) {
                CastHelper.setExpressionCastType(expr2, Type.NodeSet);
            }
            if (type == Type.Int) {
                CastHelper.setExpressionCastType(expr, Type.Real);
            } else if (type2 == Type.Int) {
                CastHelper.setExpressionCastType(expr2, Type.Real);
            }
        }
        ASTDecorator1.setType(operatorExpr, Type.Boolean);
        return Type.Boolean;
    }

    protected Type relationalExpression(OperatorExpr operatorExpr) throws TypeCheckError {
        Expr expr = operatorExpr.getOperand(0);
        Expr expr2 = operatorExpr.getOperand(1);
        Type type = this.visitExpression(expr);
        Type type2 = this.visitExpression(expr2);
        if (type == Type.ResultTree && type2 == Type.ResultTree) {
            CastHelper.setExpressionCastType(expr2, Type.Real);
            CastHelper.setExpressionCastType(expr, Type.Real);
            ASTDecorator1.setType(operatorExpr, Type.Boolean);
            return Type.Boolean;
        }
        if (type == Type.Reference || type2 == Type.Reference) {
            VariableBase variableBase;
            VariableRef variableRef;
            Type type3 = null;
            Type type4 = null;
            Type type5 = null;
            if (type == Type.Reference && expr instanceof VariableRef) {
                variableRef = (VariableRef)expr;
                variableBase = ASTDecorator.getVariable(variableRef);
                type4 = ASTDecorator1.getVariableType(variableBase);
            }
            if (type2 == Type.Reference && expr2 instanceof VariableRef) {
                variableRef = (VariableRef)expr2;
                variableBase = ASTDecorator.getVariable(variableRef);
                type5 = ASTDecorator1.getVariableType(variableBase);
            }
            if ((type3 = type4 == null ? type5 : (type5 == null ? type4 : Type.Real)) == null) {
                type3 = Type.Real;
            }
            CastHelper.setExpressionCastType(expr2, type3);
            CastHelper.setExpressionCastType(expr, type3);
            ASTDecorator1.setType(operatorExpr, Type.Boolean);
            return Type.Boolean;
        }
        if (type == Type.NodeSet || type2 == Type.NodeSet) {
            Type type6;
            Expr expr3;
            if (type == Type.NodeSet) {
                expr3 = expr2;
                type6 = type2;
            } else {
                expr3 = expr;
                type6 = type;
            }
            if (type6 instanceof NodeType) {
                CastHelper.setExpressionCastType(expr3, Type.NodeSet);
            }
            if (type6 == Type.Int) {
                CastHelper.setExpressionCastType(expr3, Type.Real);
            }
            if (type6 == Type.ResultTree) {
                CastHelper.setExpressionCastType(expr3, Type.String);
            }
            ASTDecorator1.setType(operatorExpr, Type.Boolean);
            return Type.Boolean;
        }
        if (type instanceof NodeType || type2 instanceof NodeType) {
            if (type == Type.Boolean) {
                CastHelper.setExpressionCastType(expr2, Type.Boolean);
                type2 = Type.Boolean;
            }
            if (type2 == Type.Boolean) {
                CastHelper.setExpressionCastType(expr, Type.Boolean);
                type = Type.Boolean;
            }
        }
        MethodType methodType = this.getCompiler().getFOHelper().resolveOperator(operatorExpr.getOperatorChar(), new MethodType(Type.Void, type, type2));
        Type type7 = null;
        if (methodType != null) {
            Type type8;
            Type type9 = (Type)methodType.argsType().get(0);
            if (!type9.identicalTo(type)) {
                CastHelper.setExpressionCastType(expr, type9);
            }
            if (!(type8 = (Type)methodType.argsType().get(1)).identicalTo(type2)) {
                CastHelper.setExpressionCastType(expr2, type9);
            }
            type7 = methodType.resultType();
        } else {
            ASTMsg aSTMsg = new ASTMsg("TYPE_CHECK_OP_ERR", (Object)operatorExpr.getOperatorChar(), (Expr)operatorExpr);
            this._parser.reportError(3, aSTMsg);
            type7 = Type.Boolean;
        }
        ASTDecorator1.setType(operatorExpr, type7);
        return type7;
    }

    protected Type multiplicativeExpression(Expr expr) throws TypeCheckError {
        return this.binaryOperatorExpression(expr);
    }

    protected Type pattern(Expr expr) throws TypeCheckError {
        if (expr instanceof OperatorExpr && ((OperatorExpr)expr).getOperatorType() == 1) {
            return this.unionPattern((OperatorExpr)expr);
        }
        Assert.throwError(false, "Generic pattern should be a union pattern but got: " + expr.toString());
        return Type.Void;
    }

    protected Type unionPattern(OperatorExpr operatorExpr) throws TypeCheckError {
        int n = operatorExpr.getOperandCount();
        for (int i = 0; i < n; ++i) {
            this.visitExpression(operatorExpr.getOperand(i));
        }
        return Type.Boolean;
    }

    protected Type pathPattern(Expr expr) throws TypeCheckError {
        PathExpr pathExpr = (PathExpr)expr;
        int n = pathExpr.getOperandCount();
        for (int i = 0; i < n; ++i) {
            Expr expr2 = pathExpr.getOperand(i);
            this.visitExpression(expr2);
        }
        return Type.Boolean;
    }

    protected Type slashSlashPattern(Expr expr) throws TypeCheckError {
        OperatorExpr operatorExpr = (OperatorExpr)expr;
        int n = operatorExpr.getOperandCount();
        for (int i = 0; i < n; ++i) {
            Expr expr2 = operatorExpr.getOperand(i);
            this.visitExpression(expr2);
        }
        return Type.Boolean;
    }

    protected Type pathExpression(Expr expr) throws TypeCheckError {
        PathExpr pathExpr = (PathExpr)expr;
        int n = pathExpr.getOperandCount();
        int n2 = pathExpr.isAbsolute() ? 1 : 0;
        Type type = null;
        if (n == n2 + 1) {
            Expr expr2 = pathExpr.getOperand(n2);
            type = this.visitExpression(expr2);
        } else {
            Expr expr3 = pathExpr.getOperand(n2);
            Type type2 = this.visitExpression(expr3);
            if (type2 != Type.NodeSet) {
                if (type2 == Type.Reference || type2 instanceof NodeType) {
                    CastHelper.setExpressionCastType(expr3, Type.NodeSet);
                } else {
                    ASTMsg aSTMsg = new ASTMsg("INVALID_STEP_TYPE_ERR", (Object)type2.toString(), expr3);
                    this._parser.reportError(3, aSTMsg);
                }
            }
            for (int i = n2 + 1; i < n; ++i) {
                Expr expr4 = pathExpr.getOperand(i);
                type = this.visitExpression(expr4);
            }
            type = Type.NodeSet;
        }
        ASTDecorator1.setType(pathExpr, type);
        return type;
    }

    protected Type parenthesizedExpression(Expr expr) throws TypeCheckError {
        Assert.throwError(false, "No parenthesized expressions should be left at type checking phase.");
        return Type.Void;
    }

    protected Type genericExpression(Expr expr) throws TypeCheckError {
        OperatorExpr operatorExpr = (OperatorExpr)expr;
        if (operatorExpr.getOpType() == 0) {
            XTQProgram xTQProgram = operatorExpr.getXTQProgram();
            ASTMsg aSTMsg = new ASTMsg("ER_ILLEGAL_OPERATOR_COMMA", operatorExpr.getSystemId(), operatorExpr.getOperatorChar(), operatorExpr.getXQueryString(true), operatorExpr.getStartLineNumber(), operatorExpr.getStartColumnNumber());
            this._parser.reportError(3, aSTMsg);
        }
        return Type.Void;
    }

    protected Type contextItemExpression(Expr expr) throws TypeCheckError {
        Type type = XSLTCHelper.hasParentPattern(expr) ? Type.NodeSet : Type.Node;
        ASTDecorator1.setType(expr, type);
        return type;
    }

    protected Type stepExpression(Expr expr) throws TypeCheckError {
        StepExpr stepExpr = (StepExpr)expr;
        if (stepExpr.isFilterStep()) {
            return this.filterStepExpression(stepExpr);
        }
        return this.axisStepExpression(stepExpr);
    }

    private Type filterStepExpression(StepExpr stepExpr) throws TypeCheckError {
        Expr expr;
        Expr expr2 = null;
        try {
            expr2 = stepExpr.getPrimaryExpr();
        }
        catch (XPath20Exception xPath20Exception) {
            Assert.throwError(false, xPath20Exception.getMessage());
            return Type.Void;
        }
        int n = stepExpr.getPredicateCount();
        Type type = null;
        if (XSLTCHelper.isAbbreviatedDot(stepExpr)) {
            type = XSLTCHelper.hasParentPattern(stepExpr) || n > 0 ? Type.NodeSet : Type.Node;
        } else {
            type = this.visitExpression(expr2);
            if (type != Type.NodeSet) {
                if (type == Type.Reference) {
                    CastHelper.setExpressionCastType(expr2, Type.NodeSet);
                } else {
                    Expr expr3 = stepExpr;
                    while (null != expr3.jjtGetParent() && ((expr3 = (Expr)expr3.jjtGetParent()).getId() == 85 || expr3.getId() == 82)) {
                    }
                    if (!(expr3 instanceof Node)) {
                        throw new TypeCheckError(stepExpr);
                    }
                    expr = new Message("Bad XSL code reached: " + new TypeCheckError(stepExpr), true);
                    boolean bl = expr3.replaceWith(expr);
                    if (!bl) {
                        throw new TypeCheckError(stepExpr);
                    }
                    this._parser.reportError(4, new ASTMsg("WARNING_MSG", (Object)("Bad XSL code ignored, if used at runtime it will error: " + stepExpr.getXQueryString(false)), expr3));
                }
            }
            type = Type.NodeSet;
        }
        for (int i = 0; i < n; ++i) {
            expr = stepExpr.getPredicateAt(i);
            this.predicate(expr);
        }
        ASTDecorator1.setType(stepExpr, type);
        return type;
    }

    private Type axisStepExpression(StepExpr stepExpr) throws TypeCheckError {
        int n = XSLTCHelper.findNodeTypeForStep(stepExpr, this._compiler);
        stepExpr.setStepNodeType(n);
        if (n == 7) {
            XSLTCHelper.processingInstructionTestRewrite(stepExpr, this._parser);
        }
        Type type = Type.NodeSet;
        int n2 = stepExpr.getPredicateCount();
        if (XSLTCHelper.isAbbreviatedDot(stepExpr)) {
            type = XSLTCHelper.hasParentPattern(stepExpr) || n2 > 0 ? Type.NodeSet : Type.Node;
        }
        for (int i = 0; i < n2; ++i) {
            Expr expr = stepExpr.getPredicateAt(i);
            this.predicate(expr);
        }
        ASTDecorator1.setType(stepExpr, type);
        return type;
    }

    protected Type stepPattern(Expr expr) throws TypeCheckError {
        StepExpr stepExpr = (StepExpr)expr;
        int n = XSLTCHelper.findNodeTypeForStep(stepExpr, this._compiler);
        stepExpr.setStepNodeType(n);
        int n2 = stepExpr.getPredicateCount();
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                Expr expr2 = stepExpr.getPredicateAt(i);
                this.predicate(expr2);
            }
        }
        return Type.Boolean;
    }

    protected Type stringLiteral(Expr expr) throws TypeCheckError {
        ASTDecorator1.setType(expr, Type.String);
        return Type.String;
    }

    protected Type integerLiteral(Expr expr) throws TypeCheckError {
        ASTDecorator1.setType(expr, Type.Real);
        return Type.Real;
    }

    protected Type decimalLiteral(Expr expr) throws TypeCheckError {
        ASTDecorator1.setType(expr, Type.Real);
        return Type.Real;
    }

    protected Type doubleLiteral(Expr expr) throws TypeCheckError {
        ASTDecorator1.setType(expr, Type.Real);
        return Type.Real;
    }

    protected Type unaryExpression(Expr expr) throws TypeCheckError {
        OperatorExpr operatorExpr = (OperatorExpr)expr;
        Expr expr2 = operatorExpr.getOperand(0);
        Type type = this.visitExpression(expr2);
        MethodType methodType = this.getCompiler().getFOHelper().resolveOperator("u-", new MethodType(Type.Void, type));
        Type type2 = null;
        if (methodType != null) {
            Type type3 = (Type)methodType.argsType().get(0);
            if (!type3.identicalTo(type)) {
                CastHelper.setExpressionCastType(expr2, type3);
            }
            type2 = methodType.resultType();
        } else {
            ASTMsg aSTMsg = new ASTMsg("TYPE_CHECK_OP_ERR", (Object)operatorExpr.getOperatorChar(), expr);
            this._parser.reportError(3, aSTMsg);
            type2 = Type.Boolean;
        }
        ASTDecorator1.setType(operatorExpr, type2);
        return type2;
    }

    protected Type unionExpression(Expr expr) throws TypeCheckError {
        OperatorExpr operatorExpr = (OperatorExpr)expr;
        for (int i = 0; i < 2; ++i) {
            Expr expr2 = operatorExpr.getOperand(i);
            Type type = this.visitExpression(expr2);
            if (type == Type.NodeSet) continue;
            CastHelper.setExpressionCastType(expr2, Type.NodeSet);
        }
        ASTDecorator1.setType(expr, Type.NodeSet);
        return Type.NodeSet;
    }

    protected Type predicate(Expr expr) throws TypeCheckError {
        Type type = this.visitExpression(expr);
        if (type == Type.ResultTree) {
            CastHelper.setExpressionCastType(expr, Type.Boolean);
        }
        if (type instanceof NumberType) {
            Node node;
            if (!(type instanceof IntType)) {
                CastHelper.setExpressionCastType(expr, Type.Int);
            }
            Expr expr2 = (Expr)expr.jjtGetParent();
            boolean bl = false;
            if (XSLTCHelper.hasLastCall(expr) || XSLTCHelper.isPattern(expr2) || XSLTCHelper.isFilterStep(expr2)) {
                if (XSLTCHelper.isPattern(expr2) && !XSLTCHelper.hasLastCall(expr)) {
                    ASTDecorator.setNthPositionFilter(expr, ASTDecorator.getCanOptimize(expr));
                } else if (XSLTCHelper.isFilterStep(expr2)) {
                    StepExpr stepExpr = (StepExpr)expr2;
                    Expr expr3 = null;
                    try {
                        expr3 = stepExpr.getPrimaryExpr();
                    }
                    catch (XPath20Exception xPath20Exception) {
                        Assert.throwError(false, xPath20Exception.getMessage());
                        return Type.Void;
                    }
                    boolean bl2 = true;
                    if (expr3 instanceof VariableRef) {
                        bl2 = false;
                    } else if (expr3 instanceof PathExpr) {
                        bl2 = false;
                    } else if (expr3.getId() == 63) {
                        bl2 = false;
                    } else if (XSLTCHelper.hasLastCall(expr)) {
                        bl2 = false;
                    } else if (stepExpr.jjtGetParent() instanceof PathExpr && ((PathExpr)stepExpr.jjtGetParent()).getOperandCount() > 1) {
                        bl2 = false;
                    }
                    ASTDecorator.setCanOptimize(expr, bl2);
                    if (bl2) {
                        bl = true;
                    }
                }
                if (bl) {
                    ASTDecorator.setNthPositionFilter(expr, true);
                    return Type.NodeSet;
                }
                return Type.Int;
            }
            if (expr2 != null && expr2.getId() == 85 && (node = expr2.jjtGetParent()) != null && node instanceof PathExpr) {
                PathExpr pathExpr = (PathExpr)node;
                Expr expr4 = null;
                try {
                    if (pathExpr.isAbsolute() && (expr4 = pathExpr.getOperand(1)) instanceof StepExpr && ((StepExpr)expr4).getAxisType() == 13) {
                        ASTDecorator.setNthDescendant(expr, true);
                        return Type.NodeSet;
                    }
                }
                catch (XPath20Exception xPath20Exception) {
                    Assert.throwError(false, xPath20Exception.getMessage());
                    return Type.Void;
                }
            }
            ASTDecorator.setNthPositionFilter(expr, true);
            return Type.NodeSet;
        }
        if (type == Type.Boolean) {
            if (XSLTCHelper.hasPositionCall(expr)) {
                ASTDecorator.setNthPositionFilter(expr, true);
            }
        } else {
            if (type == Type.Reference) {
                ASTDecorator.setNthPositionFilter(expr, false);
                return Type.Reference;
            }
            CastHelper.setExpressionCastType(expr, Type.Boolean);
        }
        ASTDecorator.setNthPositionFilter(expr, false);
        TranslatorHelper.getCompareValue(expr);
        return Type.Boolean;
    }

    protected Type variableOrParameterReference(Expr expr) throws TypeCheckError {
        String string;
        VariableRef variableRef = (VariableRef)expr;
        Type type = ASTDecorator1.getType(variableRef);
        if (type != null) {
            return type;
        }
        QName qName = variableRef.getVariableName();
        String string2 = qName.getLocalPart();
        String string3 = qName.getNamespaceURI();
        QName qName2 = this._parser.getQName(string3, string = qName.getPrefix(), string2);
        VariableBase variableBase = this.lookupVariable(qName2);
        if (variableBase == null) {
            if (XSLTCHelper.isJAXPVariable(variableRef, this.getCompiler())) {
                type = Type.Object;
                ASTDecorator1.setType(variableRef, type);
                return type;
            }
            ASTMsg aSTMsg = new ASTMsg("VARIABLE_UNDEF_ERR", (Object)qName2, expr);
            this._parser.reportError(3, aSTMsg);
            return Type.Reference;
        }
        if (ASTDecorator.getVariable(variableRef) != null) {
            ASTMsg aSTMsg = new ASTMsg("CIRCULAR_VARIABLE_ERR", (Object)qName2, expr);
            this._parser.reportError(3, aSTMsg);
            type = ASTDecorator1.getVariableType(variableBase);
            if (type == null) {
                type = Type.Reference;
            }
            return type;
        }
        ASTDecorator.setVariable(variableRef, variableBase);
        if (variableBase.isLocal()) {
            SimpleNode simpleNode = variableRef;
            do {
                if (!XSLTCHelper.isClosure(simpleNode)) continue;
                ASTDecorator.setClosure(variableRef, simpleNode);
                XSLTCHelper.addVariableToClosure(simpleNode, variableRef);
                break;
            } while (!(simpleNode instanceof TopLevelDecl) && (simpleNode = (SimpleNode)simpleNode.jjtGetParent()) != null);
        }
        if ((type = ASTDecorator1.getVariableType(variableBase)) == null) {
            this.visitTree(variableBase);
            type = ASTDecorator1.getVariableType(variableBase);
        }
        ASTDecorator1.setType(variableRef, type);
        return type;
    }
}

