/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.translator;

import com.ibm.xtq.ast.parsers.xslt.SourceLoader;
import com.ibm.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xtq.bcel.classfile.JavaClass;
import com.ibm.xtq.xslt.drivers.AutoFunctorizingXSLTLinker;
import com.ibm.xtq.xslt.drivers.XSLTCompilerSettings;
import com.ibm.xtq.xslt.drivers.XSLTLinker;
import com.ibm.xtq.xslt.drivers.XSLTLinkerSettings;
import com.ibm.xtq.xslt.jaxp.Util;
import com.ibm.xtq.xslt.runtime.RuntimeLibrary;
import com.ibm.xtq.xslt.translator.ObjectFactory;
import com.ibm.xylem.Logger;
import com.ibm.xylem.codegen.bcel.ClassCollector;
import com.ibm.xylem.codegen.bcel.Resource;
import com.ibm.xylem.commandline.CommandLineParserSingleInputFile;
import com.ibm.xylem.instructions.DebugInstruction;
import com.ibm.xylem.interpreter.InterpreterUtilities;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import org.xml.sax.InputSource;

public class XylemXSLTC {
    static final Logger s_logger = Logger.getInstance(class$com$ibm$xtq$xslt$translator$XylemXSLTC == null ? (class$com$ibm$xtq$xslt$translator$XylemXSLTC = XylemXSLTC.class$("com.ibm.xtq.xslt.translator.XylemXSLTC")) : class$com$ibm$xtq$xslt$translator$XylemXSLTC);
    protected static SourceLoader s_sourceLoader = null;
    protected static boolean s_topResolve = false;
    protected static ArrayList s_classes;
    protected static ArrayList s_resources;
    private static boolean s_isInputXylem;
    static /* synthetic */ Class class$com$ibm$xtq$xslt$translator$XylemXSLTC;

    public static void createSourceLoader(final URIResolver uRIResolver) {
        s_sourceLoader = new SourceLoader(){

            public InputSource loadSource(String string, String string2, XSLTParser xSLTParser) {
                try {
                    Source source = uRIResolver.resolve(string, string2);
                    if (source != null) {
                        return Util.getInputSource(xSLTParser, source);
                    }
                    return null;
                }
                catch (Exception exception) {
                    return null;
                }
            }
        };
    }

    protected static void outputToJar(File file, String string) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Iterator iterator;
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.2");
        Map<String, Attributes> map = manifest.getEntries();
        Iterator iterator2 = s_classes.iterator();
        String string2 = new Date().toString();
        Attributes.Name name = new Attributes.Name("Date");
        while (iterator2.hasNext()) {
            iterator = (JavaClass)iterator2.next();
            object3 = ((JavaClass)((Object)iterator)).getClassName().replace('.', '/');
            object2 = new Attributes();
            ((Attributes)object2).put(name, string2);
            map.put((String)object3 + ".class", (Attributes)object2);
        }
        iterator = s_resources.iterator();
        while (iterator.hasNext()) {
            object3 = (Resource)iterator.next();
            object2 = new Attributes();
            ((Attributes)object2).put(name, string2);
            map.put(object3.getName(), (Attributes)object2);
        }
        object3 = new JarOutputStream((OutputStream)new FileOutputStream(new File(file, string)), manifest);
        iterator2 = s_classes.iterator();
        while (iterator2.hasNext()) {
            object2 = (JavaClass)iterator2.next();
            object = ((JavaClass)object2).getClassName().replace('.', '/');
            ((JarOutputStream)object3).putNextEntry(new JarEntry((String)object + ".class"));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
            ((JavaClass)object2).dump(byteArrayOutputStream);
            byteArrayOutputStream.writeTo((OutputStream)object3);
        }
        iterator = s_resources.iterator();
        while (iterator.hasNext()) {
            object2 = (Resource)iterator.next();
            ((JarOutputStream)object3).putNextEntry(new JarEntry(object2.getName()));
            object = new ByteArrayOutputStream(2048);
            object2.dump((OutputStream)object);
            ((ByteArrayOutputStream)object).writeTo((OutputStream)object3);
        }
        ((ZipOutputStream)object3).close();
    }

    public static void main(String[] stringArray) {
        XylemXSLTCommandLineParser xylemXSLTCommandLineParser = new XylemXSLTCommandLineParser();
        s_classes = new ArrayList();
        s_resources = new ArrayList();
        if (!xylemXSLTCommandLineParser.parseCommandLine(stringArray)) {
            System.exit(-1);
        }
        URL[] uRLArray = new URL[xylemXSLTCommandLineParser.m_files.size()];
        xylemXSLTCommandLineParser.m_files.toArray(uRLArray);
        if (xylemXSLTCommandLineParser.m_functor != null) {
            if (xylemXSLTCommandLineParser.m_interface == null) {
                s_logger.error("you must specify an interface file with -functor");
                System.exit(-1);
            }
            try {
                AutoFunctorizingXSLTLinker.compileFunctorAppliedStylesheets(xylemXSLTCommandLineParser.m_functor.toURL(), uRLArray, xylemXSLTCommandLineParser.m_interface.toURL(), xylemXSLTCommandLineParser.m_compilerSettings, s_sourceLoader, s_topResolve);
            }
            catch (MalformedURLException malformedURLException) {
                s_logger.error("malformed interface or functor filename", malformedURLException);
                System.exit(-1);
            }
        } else if (xylemXSLTCommandLineParser.m_files.size() > 1) {
            if (!xylemXSLTCommandLineParser.m_linkerSettings.isOverlapDetection()) {
                s_logger.error("multiple XSLT input files only supported with -functor");
                System.exit(-1);
            } else if (AutoFunctorizingXSLTLinker.compileStylesheetDetectOverlap(uRLArray, xylemXSLTCommandLineParser.m_classNames, xylemXSLTCommandLineParser.m_compilerSettings, xylemXSLTCommandLineParser.m_linkerSettings, s_sourceLoader, s_topResolve) == null) {
                System.exit(-1);
            }
        } else if (s_isInputXylem) {
            if (xylemXSLTCommandLineParser.m_compilerSettings.isStylesheetSpecificSAX()) {
                if (XSLTLinker.compileXylemFile(xylemXSLTCommandLineParser.m_inputFile, xylemXSLTCommandLineParser.m_linkerSettings) == null) {
                    System.exit(-1);
                }
            } else if (XSLTLinker.compileXylemFile(xylemXSLTCommandLineParser.m_inputFile) == null) {
                System.exit(-1);
            }
        } else if (xylemXSLTCommandLineParser.m_compilerSettings.isStylesheetSpecificSAX()) {
            s_logger.debug("isInputXylem=" + s_isInputXylem);
            if (XSLTLinker.compileStylesheet_StylesheetSpecificSAX(xylemXSLTCommandLineParser.m_inputFile, xylemXSLTCommandLineParser.m_classNames.size() > 0 ? (String)xylemXSLTCommandLineParser.m_classNames.get(0) : null, xylemXSLTCommandLineParser.m_compilerSettings, xylemXSLTCommandLineParser.m_linkerSettings, s_sourceLoader, s_topResolve) == null) {
                System.exit(-1);
            }
        } else {
            s_logger.debug("isInputXylem=" + s_isInputXylem);
            xylemXSLTCommandLineParser.m_linkerSettings.setDumpXylem(true);
            if (XSLTLinker.compileStylesheet(xylemXSLTCommandLineParser.m_inputFile, xylemXSLTCommandLineParser.m_classNames.size() > 0 ? (String)xylemXSLTCommandLineParser.m_classNames.get(0) : null, xylemXSLTCommandLineParser.m_compilerSettings, xylemXSLTCommandLineParser.m_linkerSettings, s_sourceLoader, s_topResolve) == null) {
                System.exit(-1);
            }
        }
        if (xylemXSLTCommandLineParser.m_jarFileName != null) {
            try {
                XylemXSLTC.outputToJar(xylemXSLTCommandLineParser.m_linkerSettings.getOutputDir(), xylemXSLTCommandLineParser.m_jarFileName);
            }
            catch (IOException iOException) {
                s_logger.error("IOException outputting jar file", iOException);
                System.exit(-1);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        s_isInputXylem = false;
    }

    private static class CachingClassCollector
    extends ChainedClassCollector {
        public CachingClassCollector(ClassCollector classCollector) {
            super(classCollector);
        }

        public void handleGeneratedClass(JavaClass javaClass) {
            s_classes.add(javaClass);
        }

        public void handleGeneratedResource(Resource resource) {
            s_resources.add(resource);
        }
    }

    private static abstract class ChainedClassCollector
    extends ClassCollector {
        private ClassCollector m_nextCollector;

        public ChainedClassCollector(ClassCollector classCollector) {
            this.m_nextCollector = classCollector;
        }

        public abstract void handleGeneratedClass(JavaClass var1);

        public abstract void handleGeneratedResource(Resource var1);

        public final void acceptGeneratedClass(JavaClass javaClass) {
            this.handleGeneratedClass(javaClass);
            if (this.m_nextCollector != null) {
                this.m_nextCollector.acceptGeneratedClass(javaClass);
            }
        }

        public final void acceptGeneratedResource(Resource resource) {
            this.handleGeneratedResource(resource);
            if (this.m_nextCollector != null) {
                this.m_nextCollector.acceptGeneratedResource(resource);
            }
        }
    }

    public static class XylemXSLTCommandLineParser
    extends CommandLineParserSingleInputFile {
        public File m_functor = null;
        public File m_interface = null;
        public ArrayList m_files = new ArrayList();
        public ArrayList m_classNames = new ArrayList();
        public XSLTCompilerSettings m_compilerSettings = new XSLTCompilerSettings();
        public XSLTLinkerSettings m_linkerSettings = new XSLTLinkerSettings(this.m_compilerSettings);
        public String m_jarFileName = null;
        public InterpreterUtilities m_utility = new InterpreterUtilities();

        protected int parseOption(String[] stringArray, int n) {
            if (stringArray[n].equals("-help") || stringArray[n].equals("-?") || stringArray[n].equals("-h")) {
                System.out.println("Usage: XylemXSLTC [-command commandfile]\n                  [-language java|cpp]\n                  [-xslt-version 1.0|2.0]\n                  [-version]\n                  [-showversion]\n                  [-split limit]\n                  [-newsplit limit]\n                  [-outputdir dir]\n                  [-jarfile file]\n                  [-uriresolver fully.qualified.ClassName]\n                  [-topresolve]\n                  [-enabletracing]\n                  [-enabledebug]\n                  [-nodesetspecialization]\n                  [-disablenvcursors]\n                  [-traceserialization]\n                  [-combinepartitions]\n                  [-dumpxylem]\n                  [-dumpintermediatexylem]\n                  [-maxfunctionsperpartition n]\n                  [-functor input0.xsl -interface input0.xylemi]\n                  [-detectoverlap]\n                  [-classloaderproxy]\n                  [-disablejavac]\n                  [-assertions]\n                  [-symbols]\n                  [-streamresultonly]\n                  [-defaultmethod method]\n                  [-forceencoding encoding]\n                  [-nometa]\n                  [-standardserializer]\n                  [-suppressComments]\n                  [-generateBCEL]\n                  [-generateCXO]\n                  [-stylesheetSpecificSAX]\n                  [-saxstreaming]\n                  [-inputXylem input.xylem]\n                  [-xhtmlCompatability]\n                  [-disablesetparameter]\n                  [-minoptimizations]\n                  [-nsd]\n                  input1.xsl input2.xsl ...");
                return -1;
            }
            if ("-command".equals(stringArray[n])) {
                if (n == stringArray.length) {
                    s_logger.error("-command missing parameter");
                    return -1;
                }
                if (!this.handleCommandOption(stringArray[++n])) {
                    return -1;
                }
                return n;
            }
            if (stringArray[n].equals("-split")) {
                if (++n == stringArray.length) {
                    s_logger.error("-split missing parameter");
                    return -1;
                }
                try {
                    this.m_compilerSettings.setPrereductionSplitLimit(Integer.parseInt(stringArray[n]));
                }
                catch (NumberFormatException numberFormatException) {
                    s_logger.error("invalid split limit: " + stringArray[n]);
                    return -1;
                }
                return n;
            }
            if (stringArray[n].equals("-xslt-version")) {
                if (++n == stringArray.length) {
                    s_logger.error("-xslt-version missing parameter");
                    return -1;
                }
                this.m_compilerSettings.setVersion(stringArray[n]);
                if (!stringArray[n].equals("1.0") && !stringArray[n].equals("2.0")) {
                    s_logger.error("invalid version: " + stringArray[n]);
                    return -1;
                }
                return n;
            }
            if (stringArray[n].equals("-version")) {
                System.out.println(RuntimeLibrary.verboseVersionWithCopyright());
                return -1;
            }
            if (stringArray[n].equals("-showversion")) {
                System.out.println(RuntimeLibrary.verboseVersionWithCopyright());
                return n;
            }
            if (stringArray[n].equals("-symbols")) {
                this.m_linkerSettings.getCodeGenerationSettings().getJavaCSettings().setGenerateSymbols(true);
                return n;
            }
            if (stringArray[n].equals("-enabletracing")) {
                this.m_linkerSettings.getCodeGenerationSettings().setFunctionCallTracing(true);
                this.m_utility.setDebuggerflag(true);
                return n;
            }
            if (stringArray[n].equals("-nodesetspecialization")) {
                this.m_linkerSettings.setNodesetSpecialization(true);
                return n;
            }
            if (stringArray[n].equals("-minoptimizations")) {
                this.m_linkerSettings.setMinOptimization(true);
                return n;
            }
            if (stringArray[n].equals("-nsd")) {
                this.m_linkerSettings.setEnableNodeSetDeforester(true);
                return n;
            }
            if (stringArray[n].equals("-disablecnlfoptimizer")) {
                this.m_linkerSettings.setDisableCNLFOptimizer(true);
                return n;
            }
            if (stringArray[n].equals("-disablenvcursors")) {
                this.m_linkerSettings.setDisableNVCursor(true);
                return n;
            }
            if (stringArray[n].equals("-detectoverlap")) {
                this.m_linkerSettings.setOverlapDetection(true);
                return n;
            }
            if (stringArray[n].equals("-dumpxylem")) {
                this.m_linkerSettings.setDumpXylem(true);
                return n;
            }
            if (stringArray[n].equals("-dumpintermediatexylem")) {
                this.m_linkerSettings.setDumpIntermediateXylem(true);
                return n;
            }
            if (stringArray[n].equals("-inputXylem")) {
                if (++n == stringArray.length) {
                    s_logger.error("-inputXylem missing parameter");
                    return -1;
                }
                this.m_inputFile = this.validateInputFilename(stringArray[n], s_topResolve);
                s_isInputXylem = true;
                return n;
            }
            if (stringArray[n].equals("-maxfunctionsperpartition")) {
                if (++n == stringArray.length) {
                    s_logger.error("-maxfunctionsperpartition missing parameter");
                    return -1;
                }
                this.m_linkerSettings.getCodeGenerationSettings().setMaxFunctionsPerPartition(Integer.parseInt(stringArray[n]));
                return n;
            }
            if (stringArray[n].equals("-functor")) {
                if (++n == stringArray.length) {
                    s_logger.error("-functor missing parameter");
                    return -1;
                }
                if (this.m_linkerSettings.isOverlapDetection()) {
                    s_logger.error("-detectoverlap and functor mode are mutually exclusive");
                    return -1;
                }
                this.m_functor = new File(stringArray[n]);
                if (!this.m_functor.exists()) {
                    s_logger.error("specified functor input file does not exist: " + this.m_functor);
                    return -1;
                }
                return n;
            }
            if (stringArray[n].equals("-interface")) {
                if (++n == stringArray.length) {
                    s_logger.error("-interface missing parameter");
                    return -1;
                }
                if (this.m_linkerSettings.isOverlapDetection()) {
                    s_logger.error("-detectoverlap and functor mode are mutually exclusive");
                    return -1;
                }
                this.m_interface = new File(stringArray[n]);
                if (!this.m_interface.exists()) {
                    s_logger.error("specified interface input file does not exist: " + this.m_interface);
                    return -1;
                }
                return n;
            }
            if (stringArray[n].equals("-classname")) {
                if (++n == stringArray.length) {
                    s_logger.error("-classname missing parameter");
                    return -1;
                }
                this.m_classNames.add(stringArray[n]);
                return n;
            }
            if (stringArray[n].equals("-outputdir")) {
                if (++n == stringArray.length) {
                    s_logger.error("-outputdir missing parameter");
                    return -1;
                }
                File file = new File(stringArray[n]);
                this.m_linkerSettings.setOutputDir(file);
                if (!file.exists() || !file.isDirectory()) {
                    s_logger.error("specified output directory does not exist or is not a directory: " + file);
                    return -1;
                }
                return n;
            }
            if (stringArray[n].equals("-jarfile")) {
                if (++n == stringArray.length) {
                    s_logger.error("-jarfile missing parameter");
                    return -1;
                }
                String string = stringArray[n];
                this.m_jarFileName = string.endsWith(".jar") ? string : string + ".jar";
                this.m_linkerSettings.getCodeGenerationSettings().setBCELClassCollector(new CachingClassCollector(null));
                return n;
            }
            if (stringArray[n].equals("-uriresolver")) {
                if (++n == stringArray.length) {
                    s_logger.error("-uriresolver missing parameter");
                    return -1;
                }
                try {
                    URIResolver uRIResolver = (URIResolver)ObjectFactory.newInstance(stringArray[n], ObjectFactory.findClassLoader(), true);
                    XylemXSLTC.createSourceLoader(uRIResolver);
                }
                catch (Exception exception) {
                    s_logger.error("-uriresolver invalid class");
                    return -1;
                }
                return n;
            }
            if (stringArray[n].equals("-topresolve")) {
                s_topResolve = true;
                return n;
            }
            if (stringArray[n].equals("-streamresultonly")) {
                this.m_compilerSettings.setStreamResultOnly(true);
                return n;
            }
            if (stringArray[n].equals("-defaultmethod")) {
                if (++n == stringArray.length) {
                    s_logger.error("-defaultmethod missing parameter");
                    return -1;
                }
                this.m_compilerSettings.setStreamResultDefaultOutputMethod(stringArray[n].toLowerCase());
                return n;
            }
            if (stringArray[n].equals("-forceencoding")) {
                if (++n == stringArray.length) {
                    s_logger.error("-forceencoding missing parameter");
                    return -1;
                }
                this.m_compilerSettings.setForcedOutputEncoding(stringArray[n]);
                return n;
            }
            if (stringArray[n].equals("-nometa")) {
                this.m_compilerSettings.setStreamResultNoMeta(true);
                return n;
            }
            if (stringArray[n].equals("-standardserializer")) {
                this.m_compilerSettings.setStreamResultOnly(false);
                return n;
            }
            if (stringArray[n].equals("-enabledebug")) {
                DebugInstruction.enable(stringArray[++n]);
                return n;
            }
            if (stringArray[n].equals("-traceserialization")) {
                this.m_compilerSettings.setSerializationTraceEnabled(true);
                return n;
            }
            if (stringArray[n].equals("-classloaderproxy")) {
                this.m_linkerSettings.setGenerateClassLoadingProxy(true);
                return n;
            }
            if (stringArray[n].equals("-stylesheetSpecificSAX")) {
                this.m_compilerSettings.setStylesheetSpecificSAX(true);
                this.m_linkerSettings.setStylesheetSpecificSAX(true);
                return n;
            }
            if (stringArray[n].equals("-saxstreaming")) {
                this.m_compilerSettings.setStreaming(true);
                this.m_compilerSettings.setStylesheetSpecificSAX(true);
                this.m_linkerSettings.setStylesheetSpecificSAX(true);
                return n;
            }
            if (stringArray[n].equals("-assertions")) {
                return n;
            }
            if (stringArray[n].equals("-xhtmlCompatability")) {
                this.m_compilerSettings.setXHTMLCompatability(true);
                return n;
            }
            if (stringArray[n].equals("-interpret")) {
                s_logger.error("-interpret no longer supported; use XSLTInterpreter instead");
                return n;
            }
            if ("-DISABLESETPARAMETER".equalsIgnoreCase(stringArray[n])) {
                this.m_compilerSettings.setDisableSetParameter(true);
                return n;
            }
            if (stringArray[n].equals("-interpretOverlap")) {
                if (++n == stringArray.length) {
                    s_logger.error("-interpretOverlap missing functorindex");
                    return -1;
                }
                if (!this.m_linkerSettings.isOverlapDetection()) {
                    s_logger.error("Set -interpretOverlap after -detectoverlap");
                    return -1;
                }
                int n2 = -1;
                try {
                    n2 = Integer.parseInt(stringArray[n]);
                }
                catch (NumberFormatException numberFormatException) {
                    s_logger.error("invalid functor index: " + stringArray[n]);
                    return -1;
                }
                this.m_linkerSettings.setInterpretIndex(n2);
                return n;
            }
            int n3 = this.m_linkerSettings.getCodeGenerationSettings().parseOption(stringArray, n);
            if (n3 == -1) {
                return -1;
            }
            if (n3 != -2) {
                return n3;
            }
            this.m_inputFile = this.validateInputFilename(stringArray[n], s_topResolve);
            if (this.m_inputFile == null) {
                return -1;
            }
            this.m_files.add(this.m_inputFile);
            return n;
        }

        public boolean parseCommandLine(String[] stringArray) {
            boolean bl = super.parseCommandLine(stringArray);
            if (this.m_linkerSettings.isOverlapDetection() && this.m_files.size() <= 1) {
                this.m_linkerSettings.setOverlapDetection(false);
            }
            return bl;
        }
    }
}

