/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.translator;

import com.ibm.xtq.ast.nodes.Expr;
import com.ibm.xtq.ast.nodes.Template;
import com.ibm.xtq.xslt.translator.ASTDecorator;
import com.ibm.xtq.xslt.translator.Mode;
import com.ibm.xtq.xslt.translator.XSLTCHelper;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;

public final class TestSeq {
    private int _kernelType;
    private List _patterns = null;
    public List _origPatterns = null;
    private Mode _mode = null;
    public Template _default = null;
    public Expr _defaultPattern = null;

    public TestSeq(List list, Mode mode) {
        this(list, -2, mode);
    }

    public TestSeq(List list, int n, Mode mode) {
        this._patterns = list;
        this._kernelType = n;
        this._mode = mode;
    }

    public String toString() {
        int n = this._patterns.size();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            Expr expr = (Expr)this._patterns.get(i);
            if (i == 0) {
                stringBuffer.append("Testseq for kernel " + this._kernelType).append('\n');
            }
            stringBuffer.append("   pattern " + i + ": ").append(expr.toString()).append('\n');
        }
        return stringBuffer.toString();
    }

    public double getPriority() {
        Expr expr = this._patterns.size() == 0 ? this._defaultPattern : (Expr)this._patterns.get(0);
        return ASTDecorator.getPatternPriority(expr);
    }

    public int getPosition() {
        Template template = this._patterns.size() == 0 ? this._default : XSLTCHelper.getTemplateForPattern((Expr)this._patterns.get(0));
        return template.getPosition();
    }

    public void reduce() {
        ArrayList<Expr> arrayList = new ArrayList<Expr>();
        int n = this._patterns.size();
        for (int i = 0; i < n; ++i) {
            Expr expr = (Expr)this._patterns.get(i);
            XSLTCHelper.reduceKernelPattern(expr);
            if (XSLTCHelper.isWildcardPattern(expr)) {
                this._default = XSLTCHelper.getTemplateForPattern(expr);
                this._defaultPattern = expr;
                break;
            }
            arrayList.add(expr);
        }
        this._origPatterns = this._patterns;
        this._patterns = arrayList;
    }

    public void findTemplates(Dictionary dictionary) {
        if (this._default != null) {
            dictionary.put(this._default, this);
        }
        for (int i = 0; i < this._patterns.size(); ++i) {
            Expr expr = (Expr)this._patterns.get(i);
            dictionary.put(XSLTCHelper.getTemplateForPattern(expr), this);
        }
    }

    public final List getPatterns() {
        return this._patterns;
    }

    public final Template getDefault() {
        return this._default;
    }

    public final int getKernelType() {
        return this._kernelType;
    }

    public final Mode getMode() {
        return this._mode;
    }
}

