/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.runtime;

import com.ibm.xtq.common.utils.XMLCharacterRecognizer;
import java.io.Writer;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serializer.utils.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class DOMBuilder
implements ContentHandler,
LexicalHandler {
    private final Document m_doc;
    private Node m_currentNode = null;
    private final Node m_root;
    private Node m_nextSibling;
    private final DocumentFragment m_docFrag;
    private final Stack m_elemStack = new Stack();
    protected boolean m_inCData = false;

    public DOMBuilder(Document document, Node node) {
        this.m_doc = document;
        this.m_docFrag = null;
        this.m_currentNode = node;
        this.m_root = node;
        if (node instanceof Element) {
            this.m_elemStack.push(node);
        }
    }

    public DOMBuilder(Document document, DocumentFragment documentFragment) {
        this.m_doc = document;
        this.m_docFrag = documentFragment;
        this.m_root = null;
    }

    public DOMBuilder(Document document) {
        this.m_docFrag = null;
        this.m_doc = document;
        this.m_root = document instanceof Node ? document : null;
    }

    public DOMBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.m_doc = documentBuilderFactory.newDocumentBuilder().newDocument();
        this.m_root = this.m_doc;
        this.m_docFrag = null;
    }

    public DOMBuilder(Node node) throws ParserConfigurationException {
        this.m_docFrag = null;
        if (node instanceof Document) {
            this.m_doc = (Document)node;
            this.m_root = node;
        } else if (node != null) {
            this.m_doc = node.getOwnerDocument();
            this.m_root = node;
        } else {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            this.m_doc = documentBuilderFactory.newDocumentBuilder().newDocument();
            this.m_root = this.m_doc;
        }
    }

    public Node getRootDocument() {
        return null != this.m_docFrag ? this.m_docFrag : this.m_doc;
    }

    public Node getRootNode() {
        return this.m_root;
    }

    public Node getCurrentNode() {
        return this.m_currentNode;
    }

    public void setNextSibling(Node node) {
        this.m_nextSibling = node;
    }

    public Node getNextSibling() {
        return this.m_nextSibling;
    }

    public Writer getWriter() {
        return null;
    }

    public void append(Node node) throws SAXException {
        Node node2 = this.m_currentNode;
        if (null != node2) {
            if (node2 == this.m_root && this.m_nextSibling != null) {
                node2.insertBefore(node, this.m_nextSibling);
            } else {
                node2.appendChild(node);
            }
        } else if (null != this.m_docFrag) {
            if (this.m_nextSibling != null) {
                this.m_docFrag.insertBefore(node, this.m_nextSibling);
            } else {
                this.m_docFrag.appendChild(node);
            }
        } else {
            boolean bl = true;
            short s = node.getNodeType();
            if (s == 3) {
                String string = node.getNodeValue();
                if (null != string && string.trim().length() > 0) {
                    throw new SAXException(Utils.messages.createMessage("ER_CANT_OUTPUT_TEXT_BEFORE_DOC", null));
                }
                bl = false;
            } else if (s == 1 && this.m_doc.getDocumentElement() != null) {
                bl = false;
                throw new SAXException(Utils.messages.createMessage("ER_CANT_HAVE_MORE_THAN_ONE_ROOT", null));
            }
            if (bl) {
                if (this.m_nextSibling != null) {
                    this.m_doc.insertBefore(node, this.m_nextSibling);
                } else {
                    this.m_doc.appendChild(node);
                }
            }
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Element element = null == string || string.length() == 0 ? this.m_doc.createElementNS(null, string3) : this.m_doc.createElementNS(string, string3);
        this.append(element);
        try {
            int n = attributes.getLength();
            if (0 != n) {
                for (int i = 0; i < n; ++i) {
                    String string4;
                    String string5;
                    if (attributes.getType(i).equalsIgnoreCase("ID")) {
                        this.setIDAttribute(attributes.getValue(i), element);
                    }
                    if ("".equals(string5 = attributes.getURI(i))) {
                        string5 = null;
                    }
                    if ((string4 = attributes.getQName(i)).startsWith("xmlns:") || string4.equals("xmlns")) {
                        if (string5 == null) {
                            string5 = "http://www.w3.org/2000/xmlns/";
                        }
                    } else if (string4.startsWith("xml:") && string5 == null) {
                        string5 = "http://www.w3.org/XML/1998/namespace";
                    }
                    element.setAttributeNS(string5, string4, attributes.getValue(i));
                }
            }
            this.m_elemStack.push(element);
            this.m_currentNode = element;
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.m_elemStack.pop();
        this.m_currentNode = this.m_elemStack.isEmpty() ? null : (Node)this.m_elemStack.peek();
    }

    public void setIDAttribute(String string, Element element) {
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.isOutsideDocElem() && XMLCharacterRecognizer.isWhiteSpace(cArray, n, n2)) {
            return;
        }
        if (this.m_inCData) {
            this.cdata(cArray, n, n2);
            return;
        }
        String string = new String(cArray, n, n2);
        Text text = this.m_doc.createTextNode(string);
        this.append(text);
    }

    public void charactersRaw(char[] cArray, int n, int n2) throws SAXException {
        if (this.isOutsideDocElem() && XMLCharacterRecognizer.isWhiteSpace(cArray, n, n2)) {
            return;
        }
        String string = new String(cArray, n, n2);
        this.append(this.m_doc.createProcessingInstruction("xslt-next-is-raw", "formatter-to-dom"));
        this.append(this.m_doc.createTextNode(string));
    }

    public void startEntity(String string) throws SAXException {
    }

    public void endEntity(String string) throws SAXException {
    }

    public void entityReference(String string) throws SAXException {
        this.append(this.m_doc.createEntityReference(string));
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.isOutsideDocElem()) {
            return;
        }
        String string = new String(cArray, n, n2);
        this.append(this.m_doc.createTextNode(string));
    }

    private boolean isOutsideDocElem() {
        return null == this.m_docFrag && this.m_elemStack.size() == 0 && (null == this.m_currentNode || this.m_currentNode.getNodeType() == 9);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.append(this.m_doc.createProcessingInstruction(string, string2));
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        this.append(this.m_doc.createComment(new String(cArray, n, n2)));
    }

    public void startCDATA() throws SAXException {
        this.m_inCData = true;
    }

    public void endCDATA() throws SAXException {
        this.m_inCData = false;
    }

    private void cdata(char[] cArray, int n, int n2) throws SAXException {
        if (this.isOutsideDocElem() && XMLCharacterRecognizer.isWhiteSpace(cArray, n, n2)) {
            return;
        }
        String string = new String(cArray, n, n2);
        this.append(this.m_doc.createCDATASection(string));
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void skippedEntity(String string) throws SAXException {
    }
}

