/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.jaxp;

import com.ibm.xtq.ast.parsers.xslt.SourceLoader;
import com.ibm.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xtq.xslt.drivers.XSLTCompiler;
import com.ibm.xtq.xslt.jaxp.AbstractTransformerFactory;
import com.ibm.xtq.xslt.jaxp.Util;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.TemplatesHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class AbstractTemplatesHandler
implements ContentHandler,
TemplatesHandler,
SourceLoader {
    private String _systemId;
    private int _indentNumber;
    private URIResolver _uriResolver = null;
    private AbstractTransformerFactory _tfactory = null;
    private XSLTParser _parser = null;
    private XSLTCompiler _xsltc = null;
    private String _xsltVersion = null;

    protected AbstractTemplatesHandler(int n, AbstractTransformerFactory abstractTransformerFactory) {
        this._indentNumber = n;
        this._tfactory = abstractTransformerFactory;
        this._xsltVersion = abstractTransformerFactory.getStringAttribute("http://www.ibm.com/xmlns/prod/xltxe-j/xslt-version");
        this._xsltc = new XSLTCompiler(this._xsltVersion);
        this._parser = this._xsltc.getParser();
        this._xsltc.reset();
        this._xsltc.setDebug(abstractTransformerFactory.getBooleanAttribute("http://www.ibm.com/xmlns/prod/xltxe-j/debug"));
        this._xsltc.setStreamResultOnly(abstractTransformerFactory.getBooleanAttribute("http://www.ibm.com/xmlns/prod/xltxe-j/stream-result-only"));
        this._xsltc.setStaticTyping(abstractTransformerFactory.getBooleanAttribute("http://www.ibm.com/xmlns/prod/xltxe-j/static-typing"));
    }

    protected XSLTCompiler getXSLTC() {
        return this._xsltc;
    }

    protected AbstractTransformerFactory getTransformerFactory() {
        return this._tfactory;
    }

    protected XSLTParser getParser() {
        return this._parser;
    }

    protected URIResolver getURIResolver() {
        return this._uriResolver;
    }

    public String getSystemId() {
        return this._systemId;
    }

    public void setSystemId(String string) {
        this._systemId = string;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this._uriResolver = uRIResolver;
    }

    public InputSource loadSource(String string, String string2, XSLTParser xSLTParser) {
        try {
            Source source = this._uriResolver.resolve(string, string2);
            if (source != null) {
                return Util.getInputSource(xSLTParser, source);
            }
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return null;
    }

    public void startDocument() {
        this._parser.startDocument();
    }

    public void endDocument() {
        this._parser.endDocument();
    }

    public void startPrefixMapping(String string, String string2) {
        this._parser.startPrefixMapping(string, string2);
    }

    public void endPrefixMapping(String string) {
        this._parser.endPrefixMapping(string);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this._parser.startElement(string, string2, string3, attributes);
    }

    public void endElement(String string, String string2, String string3) {
        this._parser.endElement(string, string2, string3);
    }

    public void characters(char[] cArray, int n, int n2) {
        this._parser.characters(cArray, n, n2);
    }

    public void processingInstruction(String string, String string2) {
        this._parser.processingInstruction(string, string2);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
        this._parser.ignorableWhitespace(cArray, n, n2);
    }

    public void skippedEntity(String string) {
        this._parser.skippedEntity(string);
    }

    public void setDocumentLocator(Locator locator) {
        this.setSystemId(locator.getSystemId());
        this._parser.setDocumentLocator(locator);
    }
}

