/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.drivers;

import com.ibm.xtq.xslt.drivers.XSLTCompiler;
import com.ibm.xtq.xslt.drivers.XSLTCompilerSettings;
import com.ibm.xtq.xslt.drivers.XSLTLinker;
import com.ibm.xtq.xslt.drivers.XSLTLinkerSettings;
import com.ibm.xylem.LogManager;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Module;
import com.ibm.xylem.ModuleSignature;
import com.ibm.xylem.Program;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;

public class XSLTInterpreter {
    static final Logger s_logger = Logger.getInstance(class$com$ibm$xtq$xslt$drivers$XSLTInterpreter == null ? (class$com$ibm$xtq$xslt$drivers$XSLTInterpreter = XSLTInterpreter.class$("com.ibm.xtq.xslt.drivers.XSLTInterpreter")) : class$com$ibm$xtq$xslt$drivers$XSLTInterpreter);
    static final boolean s_abe = false;
    static /* synthetic */ Class class$com$ibm$xtq$xslt$drivers$XSLTInterpreter;

    public static void main(String[] stringArray) {
        Object object;
        LogManager.initializeLogger();
        if (stringArray.length == 0) {
            s_logger.info("Usage: XSLTInterpreter\n        [-dumpxylem]\n        [-out filename]\n        xslfile xmlfile");
            return;
        }
        int n = 0;
        XSLTCompilerSettings xSLTCompilerSettings = new XSLTCompilerSettings();
        XSLTLinkerSettings xSLTLinkerSettings = new XSLTLinkerSettings(xSLTCompilerSettings);
        OutputStream outputStream = System.out;
        while (n < stringArray.length) {
            object = stringArray[n];
            if (((String)object).equals("-dumpxylem")) {
                xSLTLinkerSettings.setDumpXylem(true);
                ++n;
                continue;
            }
            if (!((String)object).equals("-out")) break;
            if (++n == stringArray.length) {
                s_logger.error("-out requires parameter");
                return;
            }
            try {
                outputStream = new FileOutputStream(stringArray[n]);
            }
            catch (Exception exception) {
                s_logger.error("Could not open output file " + stringArray[n], exception);
                return;
            }
            ++n;
        }
        try {
            if (stringArray.length - n != 2) {
                s_logger.error("Expected xslfile and xmlfile parameters only");
                return;
            }
            object = new File(stringArray[n]);
            File file = new File(stringArray[1 + n]);
            URL uRL = ((File)object).toURL();
            ModuleSignature moduleSignature = new ModuleSignature("");
            Program program = new Program(moduleSignature);
            XSLTCompiler xSLTCompiler = new XSLTCompiler(xSLTCompilerSettings.getVersion());
            Module module = xSLTCompiler.compileRuntime();
            Module module2 = XSLTCompiler.compileStylesheetToModule(uRL, module, null, false, xSLTCompilerSettings);
            if (module2 == null) {
                return;
            }
            module2.typeCheck();
            module2.formalizeSignature("");
            program.addModule(module2);
            program.addModule(module);
            XSLTLinker.interpretProgram(program, null, xSLTLinkerSettings, file.toURL(), outputStream);
            s_logger.info("Done");
        }
        catch (Exception exception) {
            s_logger.error("Error occurred compiling stylesheet", exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

