/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.xdm.ref;

import com.ibm.xtq.xml.xdm.XDMCursor;
import com.ibm.xtq.xml.xdm.XDMNode;
import com.ibm.xtq.xml.xdm.ref.XDMCursorProxyCursor;

public final class XDMNodeStreamCursor
extends XDMCursorProxyCursor {
    private XDMNode[] m_nodestream;
    private int m_index = 0;

    public XDMNodeStreamCursor(XDMNode[] xDMNodeArray) {
        super(null);
        this.m_nodestream = xDMNodeArray;
        if (this.m_nodestream != null && this.m_nodestream.length > 0) {
            this.m_currentCursor = (XDMCursor)this.m_nodestream[0];
        }
    }

    public boolean isEmpty() {
        return this.m_nodestream == null || this.m_nodestream.length == 0;
    }

    public int getCurrentPos() {
        return this.m_index + 1;
    }

    public boolean setCurrentPos(int n) {
        if (this.isEmpty() || n < 0 || n > this.m_nodestream.length) {
            return false;
        }
        this.m_index = n - 1;
        this.m_currentCursor = (XDMCursor)this.m_nodestream[this.m_index];
        return true;
    }

    public XDMCursor newContext(XDMCursor xDMCursor, Object object, boolean bl) {
        try {
            return this.cloneWithReset();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public void resetIteration() {
        this.m_index = 0;
        this.m_currentCursor = (XDMCursor)this.m_nodestream[0];
    }

    public boolean nextNode() {
        int n = this.m_index + 1;
        if (n < this.m_nodestream.length) {
            this.m_index = n;
            this.m_currentCursor = (XDMCursor)this.m_nodestream[this.m_index];
            return true;
        }
        return false;
    }

    public int getLength() {
        return this.m_nodestream == null ? 0 : this.m_nodestream.length;
    }

    public XDMCursor cloneWithReset() throws CloneNotSupportedException {
        XDMNodeStreamCursor xDMNodeStreamCursor = new XDMNodeStreamCursor(this.m_nodestream);
        return xDMNodeStreamCursor;
    }

    public Object clone() {
        XDMNodeStreamCursor xDMNodeStreamCursor = new XDMNodeStreamCursor(this.m_nodestream);
        xDMNodeStreamCursor.m_index = this.m_index;
        xDMNodeStreamCursor.m_currentCursor = this.m_currentCursor;
        return xDMNodeStreamCursor;
    }
}

