/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.utils;

import java.lang.ref.SoftReference;
import java.util.Hashtable;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLReaderManager {
    private static final String NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
    private static final String NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    private static final XMLReaderManager m_singletonManager = new XMLReaderManager();
    private static SAXParserFactory m_parserFactory;
    private ThreadLocal m_reader;
    private Hashtable m_inUse;

    private XMLReaderManager() {
    }

    public static XMLReaderManager getInstance() {
        return m_singletonManager;
    }

    public synchronized XMLReader getXMLReader(boolean bl) throws SAXException {
        XMLReader xMLReader;
        boolean bl2;
        if (this.m_inUse == null) {
            this.m_inUse = new Hashtable();
        }
        boolean bl3 = bl2 = (xMLReader = this.getThisThreadsReader(bl)) != null;
        if (!bl2 || this.m_inUse.get(xMLReader) == Boolean.TRUE) {
            try {
                try {
                    xMLReader = XMLReaderFactory.createXMLReader();
                }
                catch (Exception exception) {
                    if (m_parserFactory == null) {
                        m_parserFactory = SAXParserFactory.newInstance();
                        m_parserFactory.setNamespaceAware(true);
                        if (bl) {
                            m_parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                        } else {
                            m_parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", false);
                        }
                    }
                    xMLReader = m_parserFactory.newSAXParser().getXMLReader();
                }
                try {
                    xMLReader.setFeature(NAMESPACES_FEATURE, true);
                    xMLReader.setFeature(NAMESPACE_PREFIXES_FEATURE, false);
                }
                catch (SAXException sAXException) {}
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new SAXException(parserConfigurationException);
            }
            catch (FactoryConfigurationError factoryConfigurationError) {
                throw new SAXException(factoryConfigurationError.toString());
            }
            catch (NoSuchMethodError noSuchMethodError) {
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
            if (!bl2) {
                this.setThisThreadsReader(xMLReader, bl);
                this.m_inUse.put(xMLReader, Boolean.TRUE);
            }
        } else {
            this.m_inUse.put(xMLReader, Boolean.TRUE);
        }
        return xMLReader;
    }

    public synchronized void releaseXMLReader(XMLReader xMLReader) {
        if (xMLReader == null) {
            return;
        }
        if (this.getThisThreadsReader() == xMLReader) {
            this.m_inUse.remove(xMLReader);
        }
    }

    private XMLReader getThisThreadsReader(boolean bl) {
        XMLReader xMLReader = null;
        if (this.m_reader == null) {
            this.m_reader = new ThreadLocal();
        } else {
            SoftReference softReference = (SoftReference)this.m_reader.get();
            if (softReference != null) {
                xMLReader = (XMLReader)softReference.get();
                if (xMLReader == null) {
                    return xMLReader;
                }
                try {
                    xMLReader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", bl);
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    xMLReader = null;
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    xMLReader = null;
                }
            }
        }
        return xMLReader;
    }

    private XMLReader getThisThreadsReader() {
        XMLReader xMLReader = null;
        if (this.m_reader == null) {
            this.m_reader = new ThreadLocal();
        } else {
            SoftReference softReference = (SoftReference)this.m_reader.get();
            if (softReference != null) {
                xMLReader = (XMLReader)softReference.get();
            }
        }
        return xMLReader;
    }

    private void setThisThreadsReader(XMLReader xMLReader, boolean bl) {
        if (xMLReader != null) {
            SoftReference<XMLReader> softReference = new SoftReference<XMLReader>(xMLReader);
            this.m_reader.set(softReference);
        }
    }
}

