/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.types;

import com.ibm.xtq.xml.types.AnyAtomicType;
import com.ibm.xtq.xml.types.ChoiceType;
import com.ibm.xtq.xml.types.ComplexType;
import com.ibm.xtq.xml.types.CompoundType;
import com.ibm.xtq.xml.types.IDerivableType;
import com.ibm.xtq.xml.types.ItemType;
import com.ibm.xtq.xml.types.OccurrenceIndicator;
import com.ibm.xtq.xml.types.Type;
import com.ibm.xtq.xml.types.TypeConstants;
import com.ibm.xtq.xml.types.UserDefinedAtomicType;
import com.ibm.xtq.xml.types.UserDefinedListType;
import com.ibm.xtq.xml.types.UserDefinedUnionType;
import com.ibm.xtq.xml.types.XSequenceType;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;

public class TypeFactory {
    private final XSModel _schemaModel;
    private final HashMap _userTypes;
    private static final IDerivableType[] BUILTIN_TYPES = new IDerivableType[]{TypeConstants.UNTYPEDATOMIC, TypeConstants.STRING, TypeConstants.FLOAT, TypeConstants.DOUBLE, TypeConstants.DECIMAL, TypeConstants.INTEGER, TypeConstants.DURATION, TypeConstants.YEARMONTHDURATION, TypeConstants.DAYTIMEDURATION, TypeConstants.DATETIME, TypeConstants.TIME, TypeConstants.DATE, TypeConstants.GYEARMONTH, TypeConstants.GYEAR, TypeConstants.GMONTHDAY, TypeConstants.GDAY, TypeConstants.GMONTH, TypeConstants.BOOLEAN, TypeConstants.BASE64BINARY, TypeConstants.HEXBINARY, TypeConstants.ANYURI, TypeConstants.QNAME, TypeConstants.NOTATION, TypeConstants.LONG, TypeConstants.INT, TypeConstants.SHORT, TypeConstants.BYTE, TypeConstants.UNSIGNEDLONG, TypeConstants.UNSIGNEDINT, TypeConstants.UNSIGNEDSHORT, TypeConstants.UNSIGNEDBYTE, TypeConstants.NONPOSITIVEINTEGER, TypeConstants.NONNEGATIVEINTEGER, TypeConstants.POSITIVEINTEGER, TypeConstants.NEGATIVEINTEGER, TypeConstants.NORMALIZEDSTRING, TypeConstants.TOKEN, TypeConstants.LANGUAGE, TypeConstants.NMTOKEN, TypeConstants.NAME, TypeConstants.NCNAME, TypeConstants.ID, TypeConstants.IDREF, TypeConstants.ENTITY, TypeConstants.ANYATOMICTYPE, TypeConstants.ANYTYPE, TypeConstants.ANYSIMPLETYPE, TypeConstants.UNTYPEDANY, TypeConstants.IDREFS, TypeConstants.NMTOKENS, TypeConstants.ENTITIES};
    private static final HashMap NAME2TYPES = new HashMap();

    public TypeFactory() {
        this(null);
    }

    public TypeFactory(XSModel xSModel) {
        this._schemaModel = xSModel;
        this._userTypes = new HashMap();
    }

    public IDerivableType getTypeFromName(QName qName) {
        String string = qName.getNamespaceURI();
        IDerivableType iDerivableType = string.equals("http://www.w3.org/2001/XMLSchema") ? (IDerivableType)NAME2TYPES.get(qName) : this.getUserTypeFromName(qName);
        return iDerivableType;
    }

    public static IDerivableType getTypeFromId(int n) {
        return BUILTIN_TYPES[n];
    }

    public static int getTypeSize() {
        return BUILTIN_TYPES.length;
    }

    protected IDerivableType getUserTypeFromName(QName qName) {
        XSTypeDefinition xSTypeDefinition;
        String string = qName.getNamespaceURI();
        String string2 = qName.getLocalPart();
        IDerivableType iDerivableType = (IDerivableType)this._userTypes.get(qName);
        if (iDerivableType == null && this._schemaModel != null && (xSTypeDefinition = this._schemaModel.getTypeDefinition(string2, string)) != null) {
            iDerivableType = this.createUserTypeFromXSTypeDef(qName, xSTypeDefinition);
        }
        return iDerivableType;
    }

    public IDerivableType getTypeFromNameOrXSTypeDef(QName qName, XSTypeDefinition xSTypeDefinition) {
        IDerivableType iDerivableType;
        String string = qName.getNamespaceURI();
        if (string.equals("http://www.w3.org/2001/XMLSchema")) {
            iDerivableType = (IDerivableType)NAME2TYPES.get(qName);
        } else {
            iDerivableType = (IDerivableType)this._userTypes.get(qName);
            if (iDerivableType == null) {
                iDerivableType = this.createUserTypeFromXSTypeDef(qName, xSTypeDefinition);
            }
        }
        return iDerivableType;
    }

    public IDerivableType getTypeFromAnonymousXSTypeDef(XSTypeDefinition xSTypeDefinition) {
        Type type = null;
        if (xSTypeDefinition.getTypeCategory() == 16) {
            XSSimpleTypeDefinition xSSimpleTypeDefinition = (XSSimpleTypeDefinition)xSTypeDefinition;
            switch (xSSimpleTypeDefinition.getVariety()) {
                case 1: {
                    XSTypeDefinition xSTypeDefinition2 = xSSimpleTypeDefinition.getBaseType();
                    QName qName = new QName(xSTypeDefinition2.getNamespace(), xSTypeDefinition2.getName());
                    AnyAtomicType anyAtomicType = (AnyAtomicType)this.getTypeFromNameOrXSTypeDef(qName, xSTypeDefinition2);
                    UserDefinedAtomicType userDefinedAtomicType = new UserDefinedAtomicType(anyAtomicType);
                    type = userDefinedAtomicType;
                    break;
                }
                case 2: {
                    type = new UserDefinedListType();
                    break;
                }
                case 3: {
                    type = new UserDefinedUnionType();
                }
            }
        } else {
            ComplexType complexType;
            type = complexType = new ComplexType();
        }
        return type;
    }

    protected IDerivableType createUserTypeFromXSTypeDef(QName qName, XSTypeDefinition xSTypeDefinition) {
        Type type = null;
        if (xSTypeDefinition.getTypeCategory() == 16) {
            XSSimpleTypeDefinition xSSimpleTypeDefinition = (XSSimpleTypeDefinition)xSTypeDefinition;
            switch (xSSimpleTypeDefinition.getVariety()) {
                case 1: {
                    XSTypeDefinition xSTypeDefinition2 = xSSimpleTypeDefinition.getBaseType();
                    if (xSTypeDefinition2.getName() == null) {
                        xSTypeDefinition2 = xSSimpleTypeDefinition.getPrimitiveType();
                    }
                    QName qName2 = new QName(xSTypeDefinition2.getNamespace(), xSTypeDefinition2.getName());
                    AnyAtomicType anyAtomicType = (AnyAtomicType)this.getTypeFromNameOrXSTypeDef(qName2, xSTypeDefinition2);
                    type = new UserDefinedAtomicType(qName, anyAtomicType);
                    break;
                }
                case 2: {
                    type = new UserDefinedListType();
                    break;
                }
                case 3: {
                    type = new UserDefinedUnionType();
                }
            }
        } else {
            type = new ComplexType(qName);
        }
        this._userTypes.put(qName, type);
        return type;
    }

    public static Type newType(Type type, OccurrenceIndicator occurrenceIndicator) {
        if (occurrenceIndicator == OccurrenceIndicator.ONE) {
            return type;
        }
        if (type instanceof ItemType) {
            return new XSequenceType((ItemType)type, occurrenceIndicator);
        }
        return new CompoundType(type, occurrenceIndicator);
    }

    public static Type newChoiceType(Type type, Type type2) {
        if (type.equals(type2)) {
            return type;
        }
        return new ChoiceType(type, type2);
    }

    static {
        int n = BUILTIN_TYPES.length;
        for (int i = 0; i < n; ++i) {
            IDerivableType iDerivableType = BUILTIN_TYPES[i];
            NAME2TYPES.put(iDerivableType.getQName(), iDerivableType);
        }
    }
}

