/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.dtm.ref.xlxp2dtm;

import com.ibm.xml.xlxp.api.sax.impl.SAX2ParsedEntityFactory;
import com.ibm.xml.xlxp.api.util.SimpleDTDScannerHelper;
import com.ibm.xml.xlxp.api.util.SymbolStringMappings;
import com.ibm.xml.xlxp.scan.DTDScanner;
import com.ibm.xml.xlxp.scan.DTDScannerHelper;
import com.ibm.xml.xlxp.scan.DocumentEntityScanner;
import com.ibm.xml.xlxp.scan.msg.MessageProvider;
import com.ibm.xml.xlxp.scan.msg.MessageProviderRegistry;
import com.ibm.xml.xlxp.scan.util.DTDParsedEntityFactory;
import com.ibm.xml.xlxp.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.scan.util.QName;
import com.ibm.xml.xlxp.scan.util.SymbolTable;
import com.ibm.xml.xlxp.scan.util.XMLString;
import com.ibm.xml.xlxp.scan.util.XMLStringBuffer;
import com.ibm.xtq.common.utils.SystemIDResolver;
import com.ibm.xtq.common.utils.WrappedRuntimeException;
import com.ibm.xtq.xml.dtm.ref.xlxp2dtm.XLXP2DTM;
import com.ibm.xtq.xml.dtm.ref.xlxp2dtm.XLXPDTMManager;
import com.ibm.xtq.xslt.translator.StaticError;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public final class XLXPParser
extends SimpleDTDScannerHelper {
    private final SAX2ParsedEntityFactory m_entityFactory;
    private SymbolStringMappings m_symbolMappings;
    private DTDScanner m_dtdScanner;
    private XMLStringBuffer m_stringBuffer;
    private XLXP2DTM m_dtm;

    public XLXPParser() {
        this.m_stringBuffer = new XMLStringBuffer(this.fBufferFactory);
        this.m_entityFactory = new SAX2ParsedEntityFactory(this.fBufferFactory);
        this.m_symbolMappings = new SymbolStringMappings(this.fSymbolTable);
        this.m_dtdScanner = new XLXPDTTScanner(this, this.fDocumentEntityScanner, this.fSymbolTable, this.m_entityFactory, this.fBufferFactory);
    }

    public void setDTM(XLXP2DTM xLXP2DTM) {
        this.m_dtm = xLXP2DTM;
    }

    public void reportWarning() {
        MessageProvider messageProvider = MessageProviderRegistry.getMessageProvider(this.fErrorURI);
        String string = messageProvider.createMessage(null, this.fErrorCode, this.fErrorParams);
        System.err.println(string);
    }

    public void reportRecoverableError() {
        MessageProvider messageProvider = MessageProviderRegistry.getMessageProvider(this.fErrorURI);
        String string = messageProvider.createMessage(null, this.fErrorCode, this.fErrorParams);
        SAXParseException sAXParseException = new SAXParseException(string, null);
        throw new WrappedRuntimeException(sAXParseException);
    }

    public void reportFatalError() {
        this.reportRecoverableError();
    }

    public boolean produceStartDocumentEvent() {
        boolean bl = super.produceStartDocumentEvent();
        this.m_dtm.startDocumentEvent();
        return bl;
    }

    public boolean produceEndDocumentEvent() {
        boolean bl = super.produceEndDocumentEvent();
        this.m_dtm.endDocumentEvent();
        return bl;
    }

    public boolean produceEmptyElementEvent() {
        boolean bl = super.produceEmptyElementEvent();
        this.m_dtm.startElementEvent(this.fElementType, this.fNSDecls, this.fAttributes, true, this.m_symbolMappings);
        return bl;
    }

    public boolean produceStartElementEvent() {
        boolean bl = super.produceStartElementEvent();
        this.m_dtm.startElementEvent(this.fElementType, this.fNSDecls, this.fAttributes, false, this.m_symbolMappings);
        return bl;
    }

    public boolean produceEndElementEvent(QName qName) {
        boolean bl = super.produceEndElementEvent(qName);
        this.m_dtm.endElementEvent();
        return bl;
    }

    public boolean produceCharactersEvent() {
        boolean bl = super.produceCharactersEvent();
        this.m_dtm.charactersEvent(this.fContent);
        return bl;
    }

    public boolean produceWhitespaceEvent() {
        boolean bl = super.produceWhitespaceEvent();
        this.m_dtm.charactersEvent(this.fContent);
        return bl;
    }

    public boolean produceCharacterEvent(int n) {
        boolean bl = super.produceCharacterEvent(n);
        this.m_dtm.characterEvent(n, false);
        return bl;
    }

    public boolean producePredefinedEntityEvent(int n) {
        boolean bl = super.producePredefinedEntityEvent(n);
        this.m_dtm.characterEvent(n, true);
        return bl;
    }

    public boolean produceProcessingInstructionEvent() {
        boolean bl = super.produceProcessingInstructionEvent();
        this.m_dtm.processingInstructionEvent(this.fTarget, this.fContent);
        return bl;
    }

    public boolean produceCommentEvent() {
        boolean bl = super.produceCommentEvent();
        this.m_dtm.commentEvent(this.fContent);
        return bl;
    }

    public boolean produceStartCDATASectionEvent() {
        boolean bl = super.produceStartCDATASectionEvent();
        this.m_dtm.startCDATAEvent();
        return bl;
    }

    public boolean produceEndCDATASectionEvent() {
        boolean bl = super.produceEndCDATASectionEvent();
        this.m_dtm.endCDATAEvent();
        return bl;
    }

    public boolean produceWarningEvent(String string, int n) {
        boolean bl = super.produceWarningEvent(string, n);
        this.reportWarning();
        return bl;
    }

    public boolean produceRecoverableErrorEvent(String string, int n) {
        boolean bl = super.produceRecoverableErrorEvent(string, n);
        this.reportRecoverableError();
        return bl;
    }

    public boolean produceFatalErrorEvent(String string, int n) {
        boolean bl = super.produceFatalErrorEvent(string, n);
        this.reportFatalError();
        return bl;
    }

    public void reset(boolean bl) {
        super.reset(bl);
        this.m_entityFactory.reset(bl);
        this.m_symbolMappings.reset(bl);
        this.m_dtdScanner.reset(bl);
        this.m_dtm = null;
    }

    public void parse(InputStream inputStream) throws IOException {
        ParsedEntity parsedEntity = this.m_entityFactory.createParsedEntity(inputStream, null);
        this.parseDocumentEntity(parsedEntity);
    }

    public void parse(Reader reader) throws IOException {
        InputSource inputSource = new InputSource(reader);
        ParsedEntity parsedEntity = this.m_entityFactory.createParsedEntity(inputSource);
        this.parseDocumentEntity(parsedEntity);
    }

    public void parse(StreamSource streamSource) throws IOException {
        InputStream inputStream;
        String string = streamSource.getSystemId();
        if (null != string) {
            try {
                string = SystemIDResolver.getAbsoluteURI(string);
            }
            catch (Exception exception) {
                System.err.println("Can not absolutize URL: " + string);
            }
        }
        if ((inputStream = streamSource.getInputStream()) == null) {
            if (null != streamSource.getSystemId()) {
                String string2 = SystemIDResolver.getAbsoluteURI(string);
                inputStream = new URL(string2).openStream();
            } else {
                if (null != streamSource.getReader()) {
                    this.parse(streamSource.getReader());
                    return;
                }
                throw new StaticError("ERR_SYSTEMID_UNKNOWN");
            }
        }
        ParsedEntity parsedEntity = this.m_entityFactory.createParsedEntity(inputStream, null);
        if (string != null && (parsedEntity.baseURI == null || parsedEntity.baseURI.length() <= 0)) {
            parsedEntity.baseURI = string;
        }
        this.parseDocumentEntity(parsedEntity);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("Usage: java XLXPParser <filename>  ");
            System.exit(-1);
        }
        try {
            StreamSource streamSource = new StreamSource(new String(stringArray[0]));
            XLXPDTMManager xLXPDTMManager = new XLXPDTMManager();
            XLXP2DTM xLXP2DTM = (XLXP2DTM)xLXPDTMManager.getDTM(streamSource, true, null, false, true, false);
            xLXP2DTM.dumpDTM(System.err);
        }
        catch (Throwable throwable) {
            System.err.println("Unexpected exception: " + throwable);
            throwable.printStackTrace(System.err);
            System.exit(-1);
        }
    }

    private void unparsedEntityDecl(XMLString xMLString, XMLString xMLString2, XMLString xMLString3, XMLString xMLString4) {
        this.m_dtm.unparsedEntityDecl(null == xMLString ? "" : xMLString.toString(), null == xMLString2 ? "" : xMLString2.toString(), xMLString3.toString(), xMLString4.toString());
    }

    private class XLXPDTTScanner
    extends DTDScanner {
        public XLXPDTTScanner(DTDScannerHelper dTDScannerHelper, DocumentEntityScanner documentEntityScanner, SymbolTable symbolTable, DTDParsedEntityFactory dTDParsedEntityFactory, DataBufferFactory dataBufferFactory) {
            super(dTDScannerHelper, documentEntityScanner, dataBufferFactory, symbolTable, dTDParsedEntityFactory);
        }

        protected void unparsedEntityDecl(XMLString xMLString, XMLString xMLString2, XMLString xMLString3, XMLString xMLString4) {
            super.unparsedEntityDecl(xMLString, xMLString2, xMLString3, xMLString4);
            ((XLXPParser)this.fHelper).unparsedEntityDecl(xMLString, xMLString2, xMLString3, xMLString4);
        }
    }
}

