/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.datamodel;

import com.ibm.xtq.xml.datamodel.DynamicError;
import com.ibm.xtq.xml.datamodel.XBase64Binary;
import com.ibm.xtq.xml.datamodel.XItem;
import com.ibm.xtq.xml.datamodel.XItemBase;
import com.ibm.xtq.xml.datamodel.XUntypedAtomic;
import com.ibm.xtq.xml.types.ItemType;
import com.ibm.xtq.xml.types.TypeConstants;
import com.ibm.xtq.xml.types.TypeError;
import com.ibm.xtq.xml.xdm.res.XMLMessages;
import java.math.BigInteger;
import org.apache.xerces.impl.dv.util.HexBin;

public class XHexBinary
extends XItemBase {
    private byte[] m_bytes;
    private String m_str = null;

    public XHexBinary(byte[] byArray) {
        this(byArray, TypeConstants.HEXBINARY);
    }

    public XHexBinary(byte[] byArray, String string) {
        this(byArray, TypeConstants.HEXBINARY);
        this.m_str = string;
    }

    public XHexBinary(byte[] byArray, ItemType itemType) {
        this.m_bytes = byArray;
        this.m_type = itemType;
    }

    public int getPrimitiveId() {
        return 19;
    }

    public static XHexBinary parse(String string) {
        byte[] byArray = HexBin.decode(string);
        if (byArray != null) {
            return new XHexBinary(byArray, string);
        }
        throw new DynamicError(XMLMessages.createXMLMessage("ER_CAN_NOT_CAST_HEXBINARY", new Object[]{string}));
    }

    public XBase64Binary toBase64Binary() {
        BigInteger bigInteger = new BigInteger(this.m_bytes);
        return XBase64Binary.parse(bigInteger.toString(16));
    }

    public XHexBinary toHexBinary() {
        return this;
    }

    public String toString() {
        if (this.m_str == null) {
            this.m_str = HexBin.encode(this.m_bytes);
        }
        return this.m_str;
    }

    public XUntypedAtomic toUntypedAtomic() {
        return new XUntypedAtomic(this.toString());
    }

    public int getLength() {
        return this.m_bytes.length;
    }

    public byte[] getBytes() {
        return this.m_bytes;
    }

    public boolean equals(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 19: {
                return this.equals(xItem.toHexBinary());
            }
        }
        throw new TypeError();
    }

    public boolean equals(XHexBinary xHexBinary) {
        int n = this.getLength();
        if (n != xHexBinary.getLength()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.m_bytes[i] == xHexBinary.getBytes()[i]) continue;
            return false;
        }
        return true;
    }

    public final boolean notEquals(XHexBinary xHexBinary) throws TypeError {
        return !this.equals(xHexBinary);
    }
}

