/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.datamodel;

import com.ibm.xtq.xml.datamodel.CastLibrary;
import com.ibm.xtq.xml.datamodel.DateTimeBase;
import com.ibm.xtq.xml.datamodel.DynamicError;
import com.ibm.xtq.xml.datamodel.XItem;
import com.ibm.xtq.xml.datamodel.XItemBase;
import com.ibm.xtq.xml.datamodel.XUntypedAtomic;
import com.ibm.xtq.xml.types.ItemType;
import com.ibm.xtq.xml.types.TypeConstants;
import com.ibm.xtq.xml.types.TypeError;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.xs.MonthDV;
import org.apache.xerces.impl.dv.xs.TypeValidator;

public class XGMonth
extends XItemBase {
    private static TypeValidator m_validator = new MonthDV();
    private int m_month;

    public XGMonth(int n) {
        this(n, TypeConstants.GMONTH);
    }

    public XGMonth(int n, ItemType itemType) {
        this.m_month = n;
        this.m_type = itemType;
    }

    public int getPrimitiveId() {
        return 16;
    }

    public int getMonth() {
        return this.m_month;
    }

    public static XGMonth parse(String string) {
        try {
            DateTimeBase dateTimeBase = (DateTimeBase)m_validator.getActualValue(string, null);
            return new XGMonth(dateTimeBase.getMonth());
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new DynamicError(invalidDatatypeValueException.toString());
        }
    }

    public XGMonth toGMonth() {
        return this;
    }

    public String toString() {
        return "--" + CastLibrary.convertTo2CharString(this.m_month) + "--";
    }

    public XUntypedAtomic toUntypedAtomic() {
        return new XUntypedAtomic(this.toString());
    }

    public boolean equals(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 16: {
                return this.equals(xItem.toGMonth());
            }
        }
        throw new TypeError();
    }

    public boolean equals(XGMonth xGMonth) {
        return this.m_month == xGMonth.getMonth();
    }

    public final boolean notEquals(XGMonth xGMonth) throws TypeError {
        return !this.equals(xGMonth);
    }
}

