/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.datamodel;

import com.ibm.xtq.xml.datamodel.CastLibrary;
import com.ibm.xtq.xml.datamodel.DateTimeBase;
import com.ibm.xtq.xml.datamodel.DynamicError;
import com.ibm.xtq.xml.datamodel.XDayTimeDuration;
import com.ibm.xtq.xml.datamodel.XItemBase;
import com.ibm.xtq.xml.datamodel.XUntypedAtomic;
import com.ibm.xtq.xml.datamodel.XYearMonthDuration;
import com.ibm.xtq.xml.types.ItemType;
import com.ibm.xtq.xml.types.TypeConstants;
import java.math.BigDecimal;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.xs.DurationDV;
import org.apache.xerces.impl.dv.xs.TypeValidator;

public class XDuration
extends XItemBase {
    protected static TypeValidator m_validator = new DurationDV();
    protected int m_years = 0;
    protected int m_months = 0;
    protected int m_days = 0;
    protected int m_hours = 0;
    protected int m_minutes = 0;
    protected double m_seconds = 0.0;
    protected BigDecimal m_CValue = null;

    protected XDuration() {
    }

    protected XDuration(DateTimeBase dateTimeBase) {
        this.m_years = dateTimeBase.getYear();
        this.m_months = dateTimeBase.getMonth();
        this.m_days = dateTimeBase.getDay();
        this.m_hours = dateTimeBase.getHours();
        this.m_minutes = dateTimeBase.getMinutes();
        this.m_seconds = (double)dateTimeBase.getSeconds() + dateTimeBase.getFraction();
        this.m_type = TypeConstants.DURATION;
    }

    public XDuration(int n, int n2, int n3, int n4, int n5, double d) {
        this(n, n2, n3, n4, n5, d, TypeConstants.DURATION);
    }

    public XDuration(int n, int n2, int n3, int n4, int n5, double d, ItemType itemType) {
        this.m_years = n;
        this.m_months = n2;
        this.m_days = n3;
        this.m_hours = n4;
        this.m_minutes = n5;
        this.m_seconds = d;
        this.m_type = itemType;
    }

    public int getPrimitiveId() {
        return 6;
    }

    public BigDecimal getCValue() {
        return this.m_CValue;
    }

    public int getYears() {
        return this.m_years;
    }

    public int getMonths() {
        return this.m_months;
    }

    public int getDays() {
        return this.m_days;
    }

    public int getHours() {
        return this.m_hours;
    }

    public int getMinutes() {
        return this.m_minutes;
    }

    public double getSeconds() {
        return this.m_seconds;
    }

    public static XDuration parse(String string) {
        try {
            return new XDuration((DateTimeBase)m_validator.getActualValue(string, null));
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new DynamicError(invalidDatatypeValueException.toString());
        }
    }

    public XDayTimeDuration toDayTimeDuration() {
        return new XDayTimeDuration(this.m_days, this.m_hours, this.m_minutes, this.m_seconds);
    }

    public XDuration toDuration() {
        return this;
    }

    public String toString() {
        return CastLibrary.composeDurationCRep(this.m_years, this.m_months, this.m_days, this.m_hours, this.m_minutes, this.m_seconds, this.m_CValue, 6);
    }

    public XUntypedAtomic toUntypedAtomic() {
        return new XUntypedAtomic(this.toString());
    }

    public XYearMonthDuration toYearMonthDuration() {
        return new XYearMonthDuration(this.m_years, this.m_months);
    }
}

