/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.datamodel;

import com.ibm.xtq.xml.datamodel.CastLibrary;
import com.ibm.xtq.xml.datamodel.DateTimeBase;
import com.ibm.xtq.xml.datamodel.DynamicError;
import com.ibm.xtq.xml.datamodel.XDataTypeUtils;
import com.ibm.xtq.xml.datamodel.XDate;
import com.ibm.xtq.xml.datamodel.XDateTime;
import com.ibm.xtq.xml.datamodel.XDuration;
import com.ibm.xtq.xml.datamodel.XItem;
import com.ibm.xtq.xml.datamodel.XItemBase;
import com.ibm.xtq.xml.datamodel.XTime;
import com.ibm.xtq.xml.datamodel.XUntypedAtomic;
import com.ibm.xtq.xml.types.ItemType;
import com.ibm.xtq.xml.types.TypeConstants;
import com.ibm.xtq.xml.types.TypeError;
import java.math.BigDecimal;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;

public class XDayTimeDuration
extends XDuration {
    public XDayTimeDuration(int n, int n2, int n3, double d) {
        this.calculateValue(n, n2, n3, d);
        this.m_type = TypeConstants.DAYTIMEDURATION;
    }

    public XDayTimeDuration(int n, int n2, int n3, double d, ItemType itemType) {
        this.calculateValue(n, n2, n3, d);
        this.m_type = itemType;
    }

    public XDayTimeDuration(BigDecimal bigDecimal) {
        this.setValue(bigDecimal);
        this.m_type = TypeConstants.DAYTIMEDURATION;
    }

    public XDayTimeDuration(BigDecimal bigDecimal, ItemType itemType) {
        this.setValue(bigDecimal);
        this.m_type = itemType;
    }

    public final void calculateValue(int n, int n2, int n3, double d) {
        this.m_CValue = XDataTypeUtils.dayTimeDurationToSeconds(n, n2, n3, d);
        if (this.m_CValue.doubleValue() == 0.0) {
            return;
        }
        this.m_days = this.m_CValue.divide(new BigDecimal(86400.0), 1).intValue();
        BigDecimal bigDecimal = this.m_CValue.subtract(new BigDecimal(86400.0 * (double)this.m_days));
        this.m_hours = (int)bigDecimal.doubleValue() / 3600;
        bigDecimal = bigDecimal.subtract(new BigDecimal((double)(this.m_hours * 3600)));
        this.m_minutes = (int)bigDecimal.doubleValue() / 60;
        this.m_seconds = bigDecimal.subtract(new BigDecimal((double)(this.m_minutes * 60))).doubleValue();
    }

    public final void setValue(BigDecimal bigDecimal) {
        this.m_CValue = bigDecimal;
        if (bigDecimal.doubleValue() == 0.0) {
            return;
        }
        this.m_days = (int)bigDecimal.divide(new BigDecimal(86400.0), 1).longValue();
        BigDecimal bigDecimal2 = bigDecimal.subtract(new BigDecimal((double)this.m_days).multiply(new BigDecimal(86400.0)));
        this.m_hours = (int)bigDecimal2.doubleValue() / 3600;
        bigDecimal2 = bigDecimal2.subtract(new BigDecimal((double)(this.m_hours * 3600)));
        this.m_minutes = (int)bigDecimal2.doubleValue() / 60;
        this.m_seconds = bigDecimal2.subtract(new BigDecimal((double)(this.m_minutes * 60))).doubleValue();
    }

    public BigDecimal getCValue() {
        return this.m_CValue;
    }

    public int getPrimitiveId() {
        return 8;
    }

    public static XDayTimeDuration parseTMP(String string) {
        try {
            DateTimeBase dateTimeBase = (DateTimeBase)m_validator.getActualValue(string, null);
            return new XDayTimeDuration(dateTimeBase.getDay(), dateTimeBase.getHours(), dateTimeBase.getMinutes(), (double)dateTimeBase.getSeconds() + dateTimeBase.getFraction());
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new DynamicError(invalidDatatypeValueException.toString());
        }
    }

    public XDayTimeDuration toDayTimeDuration() {
        return this;
    }

    public XDuration toDuration() {
        return new XDuration(0, 0, this.m_days, this.m_hours, this.m_minutes, this.m_seconds);
    }

    public String toString() {
        return CastLibrary.composeDurationCRep(0, 0, this.m_days, this.m_hours, this.m_minutes, this.m_seconds, this.m_CValue, 8);
    }

    public XUntypedAtomic toUntypedAtomic() {
        return new XUntypedAtomic(this.toString());
    }

    public XDayTimeDuration add(XDayTimeDuration xDayTimeDuration) {
        return new XDayTimeDuration(this.m_days + xDayTimeDuration.getDays(), this.m_hours + xDayTimeDuration.getHours(), this.m_minutes + xDayTimeDuration.getMinutes(), this.m_seconds + xDayTimeDuration.getSeconds());
    }

    public XDate add(XDate xDate) {
        return xDate.add(this);
    }

    public XTime add(XTime xTime) {
        return xTime.add(this);
    }

    public XDateTime add(XDateTime xDateTime) {
        return xDateTime.add(this);
    }

    public XItem add(XItem xItem) {
        switch (xItem.getPrimitiveId()) {
            case 8: {
                return this.add(xItem.toDayTimeDuration());
            }
            case 9: {
                return this.add(xItem.toDatetime());
            }
            case 10: {
                return this.add(xItem.toTime());
            }
            case 11: {
                return this.add(xItem.toDate());
            }
        }
        throw new TypeError();
    }

    public XDayTimeDuration subtract(XDayTimeDuration xDayTimeDuration) {
        return new XDayTimeDuration(this.m_CValue.add(xDayTimeDuration.getCValue().negate()));
    }

    public XItem subtract(XItem xItem) {
        switch (xItem.getPrimitiveId()) {
            case 8: {
                return this.subtract(xItem.toDayTimeDuration());
            }
        }
        throw new TypeError();
    }

    public XDayTimeDuration multiply(double d) {
        return new XDayTimeDuration(this.m_CValue.multiply(new BigDecimal(d)));
    }

    public XItem multiply(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return this.multiply(xItem.toDouble());
            }
        }
        throw new TypeError();
    }

    public XDayTimeDuration divide(double d) {
        return new XDayTimeDuration(this.m_CValue.divide(new BigDecimal(d), 6, 4));
    }

    public double divide(XDayTimeDuration xDayTimeDuration) {
        return this.m_CValue.divide(xDayTimeDuration.getCValue(), 6, 0).doubleValue();
    }

    public XItem divide(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return this.divide(xItem.toDouble());
            }
        }
        throw new TypeError();
    }

    public final int compareTo(XDayTimeDuration xDayTimeDuration) throws TypeError {
        return XItemBase.FormatCompareOut(this.m_CValue.add(xDayTimeDuration.getCValue().negate()));
    }

    public final int compareTo(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 8: {
                return this.compareTo(xItem.toDayTimeDuration());
            }
        }
        throw new TypeError();
    }

    public final boolean equals(XDayTimeDuration xDayTimeDuration) throws TypeError {
        return this.compareTo(xDayTimeDuration) == 0;
    }

    public final boolean notEquals(XDayTimeDuration xDayTimeDuration) throws TypeError {
        return !this.equals(xDayTimeDuration);
    }

    public final boolean greaterThan(XDayTimeDuration xDayTimeDuration) throws TypeError {
        return this.compareTo(xDayTimeDuration) > 0;
    }

    public final boolean greaterOrEquals(XDayTimeDuration xDayTimeDuration) throws TypeError {
        return this.compareTo(xDayTimeDuration) >= 0;
    }

    public final boolean lessThan(XDayTimeDuration xDayTimeDuration) throws TypeError {
        return this.compareTo(xDayTimeDuration) < 0;
    }

    public final boolean lessOrEquals(XDayTimeDuration xDayTimeDuration) throws TypeError {
        return this.compareTo(xDayTimeDuration) <= 0;
    }
}

