/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.datamodel;

import com.ibm.xtq.xml.datamodel.XDayTimeDuration;
import com.ibm.xtq.xml.datamodel.XTime;
import com.ibm.xtq.xml.datamodel.XYearMonthDuration;
import java.math.BigDecimal;

public class XDataTypeUtils {
    public static final BigDecimal dayTimeDurationToSeconds(XDayTimeDuration xDayTimeDuration) {
        return XDataTypeUtils.dayTimeDurationToSeconds(xDayTimeDuration.getDays(), xDayTimeDuration.getHours(), xDayTimeDuration.getMinutes(), xDayTimeDuration.getSeconds());
    }

    public static final BigDecimal dayTimeDurationToSeconds(int n, int n2, int n3, double d) {
        return new BigDecimal((double)n).multiply(new BigDecimal(86400.0)).add(new BigDecimal((double)n2).multiply(new BigDecimal(3600.0))).add(new BigDecimal((double)n3).multiply(new BigDecimal(60.0))).add(new BigDecimal(d)).setScale(2, 4);
    }

    public static final double timeToSeconds(XTime xTime) {
        return (double)(xTime.getHour() * 3600 + xTime.getMinute() * 60) + xTime.getSecond();
    }

    public static final XDayTimeDuration secondsTodayTimeDuration(BigDecimal bigDecimal) {
        return new XDayTimeDuration(bigDecimal);
    }

    public static final XYearMonthDuration negate(XYearMonthDuration xYearMonthDuration) {
        return new XYearMonthDuration(xYearMonthDuration.getCValue().negate());
    }

    public static final XDayTimeDuration negate(XDayTimeDuration xDayTimeDuration) {
        return new XDayTimeDuration(xDayTimeDuration.getCValue().negate());
    }

    public static final int fQuotient(double d, double d2) {
        return (int)Math.floor(d / d2);
    }

    public static final int fQuotient(double d, int n, int n2) {
        return XDataTypeUtils.fQuotient(d - (double)n, n2 - n);
    }

    public static final double modulo(double d, double d2, int n) {
        return d - (double)n * d2;
    }

    public static final double modulo(double d, int n, int n2) {
        double d2 = d - (double)n;
        double d3 = n2 - n;
        return XDataTypeUtils.modulo(d2, d3, XDataTypeUtils.fQuotient(d2, d3)) + (double)n;
    }

    public static int maxDayInMonthFor(int n, int n2) {
        if (n2 == 2) {
            return XDataTypeUtils.isLeapYear(n) ? 29 : 28;
        }
        if (n2 == 4 || n2 == 6 || n2 == 9 || n2 == 11) {
            return 30;
        }
        return 31;
    }

    private static boolean isLeapYear(int n) {
        return n % 400 == 0 || n % 100 != 0 && n % 4 == 0;
    }

    public static final int[] normalizeDate(int n, int n2, int n3) {
        int[] nArray = new int[3];
        while (true) {
            int n4;
            int n5 = XDataTypeUtils.maxDayInMonthFor(n3, n2);
            if (n < 1) {
                n += XDataTypeUtils.maxDayInMonthFor(n3, n2 - 1);
                n4 = -1;
            } else {
                if (n <= n5) break;
                n -= n5;
                n4 = 1;
            }
            n5 = n2 + n4;
            n2 = (int)XDataTypeUtils.modulo((double)n5, 1, 13);
            n3 += XDataTypeUtils.fQuotient(n5, 1, 13);
        }
        nArray[0] = n;
        nArray[1] = n2;
        nArray[2] = n3;
        return nArray;
    }

    public static final int normalizeDay(int n, int n2, int n3) {
        int n4 = XDataTypeUtils.maxDayInMonthFor(n3, n2);
        if (n < 1) {
            n4 = 1;
        } else if (n < n4 && n >= 1) {
            n4 = n;
        }
        return n4;
    }

    private static int leaps(int n) {
        return (n - 1) / 4 - (n - 1) / 100 + (n - 1) / 400;
    }

    public static final int numberOfDays(int n, int n2, int n3) {
        int[] nArray = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
        int n4 = (n3 - 1) * 365 + XDataTypeUtils.leaps(n3);
        n4 += nArray[n2 - 1] + n;
        return XDataTypeUtils.isLeapYear(n3) && n2 > 2 ? ++n4 : n4;
    }
}

