/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.datamodel;

import com.ibm.xtq.xml.datamodel.CastLibrary;
import com.ibm.xtq.xml.datamodel.XItem;
import com.ibm.xtq.xml.datamodel.XItemBase;
import com.ibm.xtq.xml.datamodel.XUntypedAtomic;
import com.ibm.xtq.xml.types.ItemType;
import com.ibm.xtq.xml.types.TypeConstants;
import com.ibm.xtq.xml.types.TypeError;
import java.math.BigDecimal;
import java.math.BigInteger;

public class XBoolean
extends XItemBase {
    public static final XBoolean TRUE = new XBoolean(true);
    public static final XBoolean FALSE = new XBoolean(false);
    private boolean m_value;

    public XBoolean(boolean bl) {
        this.m_value = bl;
        this.m_type = TypeConstants.BOOLEAN;
    }

    public XBoolean(boolean bl, ItemType itemType) {
        this.m_value = bl;
        this.m_type = itemType;
    }

    public int getPrimitiveId() {
        return 17;
    }

    public static XBoolean valueOf(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public static XBoolean valueOf(String string) {
        return XBoolean.valueOf(CastLibrary.toBoolean(string));
    }

    public boolean getCurrentItemAsBoolean() throws TypeError {
        return this.m_value;
    }

    public boolean equals(XItem xItem) throws TypeError {
        if (xItem instanceof XBoolean) {
            return this.m_value == xItem.toBoolean();
        }
        throw new TypeError();
    }

    public boolean equals(boolean bl) throws TypeError {
        return this.m_value == bl;
    }

    public int compareTo(XItem xItem) throws TypeError {
        if (xItem instanceof XBoolean) {
            boolean bl = xItem.toBoolean();
            if (this.m_value == bl) {
                return 0;
            }
            return this.m_value ? 1 : -1;
        }
        throw new TypeError();
    }

    public int compareTo(boolean bl) throws TypeError {
        if (this.m_value == bl) {
            return 0;
        }
        return this.m_value ? 1 : -1;
    }

    public final boolean greaterThan(boolean bl) throws TypeError {
        return this.m_value && !bl;
    }

    public final boolean lessThan(boolean bl) throws TypeError {
        return !this.m_value && bl;
    }

    public final boolean lessOrEquals(boolean bl) throws TypeError {
        throw new TypeError();
    }

    public final boolean lessOrEquals(XItem xItem) throws TypeError {
        throw new TypeError();
    }

    public final boolean greaterOrEquals(boolean bl) throws TypeError {
        throw new TypeError();
    }

    public final boolean greaterOrEquals(XItem xItem) throws TypeError {
        throw new TypeError();
    }

    public boolean toBoolean() {
        return this.m_value;
    }

    public BigDecimal toDecimal() {
        return this.m_value ? DECIMAL_ONE : DECIMAL_ZERO;
    }

    public double toDouble() {
        return this.m_value ? 1.0 : 0.0;
    }

    public float toFloat() {
        return this.m_value ? 1.0f : 0.0f;
    }

    public BigInteger toInteger() {
        return this.m_value ? BigInteger.ONE : BigInteger.ZERO;
    }

    public String toString() {
        return String.valueOf(this.m_value);
    }

    public XUntypedAtomic toUntypedAtomic() {
        return new XUntypedAtomic(this.toString());
    }
}

