/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.bcel.verifier.structurals;

import com.ibm.xtq.bcel.generic.ReferenceType;
import com.ibm.xtq.bcel.generic.Type;
import com.ibm.xtq.bcel.verifier.exc.AssertionViolatedException;
import com.ibm.xtq.bcel.verifier.exc.StructuralCodeConstraintException;
import com.ibm.xtq.bcel.verifier.structurals.UninitializedObjectType;

public class LocalVariables {
    private Type[] locals;

    public LocalVariables(int maxLocals) {
        this.locals = new Type[maxLocals];
        int i = 0;
        while (i < maxLocals) {
            this.locals[i] = Type.UNKNOWN;
            ++i;
        }
    }

    protected Object clone() {
        LocalVariables lvs = new LocalVariables(this.locals.length);
        int i = 0;
        while (i < this.locals.length) {
            lvs.locals[i] = this.locals[i];
            ++i;
        }
        return lvs;
    }

    public Type get(int i) {
        return this.locals[i];
    }

    public LocalVariables getClone() {
        return (LocalVariables)this.clone();
    }

    public int maxLocals() {
        return this.locals.length;
    }

    public void set(int i, Type type) {
        if (type == Type.BYTE || type == Type.SHORT || type == Type.BOOLEAN || type == Type.CHAR) {
            throw new AssertionViolatedException("LocalVariables do not know about '" + type + "'. Use Type.INT instead.");
        }
        this.locals[i] = type;
    }

    public boolean equals(Object o) {
        if (!(o instanceof LocalVariables)) {
            return false;
        }
        LocalVariables lv = (LocalVariables)o;
        if (this.locals.length != lv.locals.length) {
            return false;
        }
        int i = 0;
        while (i < this.locals.length) {
            if (!this.locals[i].equals(lv.locals[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void merge(LocalVariables lv) {
        if (this.locals.length != lv.locals.length) {
            throw new AssertionViolatedException("Merging LocalVariables of different size?!? From different methods or what?!?");
        }
        int i = 0;
        while (i < this.locals.length) {
            this.merge(lv, i);
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void merge(LocalVariables lv, int i) {
        if (!(this.locals[i] instanceof UninitializedObjectType) && lv.locals[i] instanceof UninitializedObjectType) {
            throw new StructuralCodeConstraintException("Backwards branch with an uninitialized object in the local variables detected.");
        }
        if (!this.locals[i].equals(lv.locals[i]) && this.locals[i] instanceof UninitializedObjectType && lv.locals[i] instanceof UninitializedObjectType) {
            throw new StructuralCodeConstraintException("Backwards branch with an uninitialized object in the local variables detected.");
        }
        if (this.locals[i] instanceof UninitializedObjectType && !(lv.locals[i] instanceof UninitializedObjectType)) {
            this.locals[i] = ((UninitializedObjectType)this.locals[i]).getInitialized();
        }
        if (this.locals[i] instanceof ReferenceType && lv.locals[i] instanceof ReferenceType) {
            if (this.locals[i].equals(lv.locals[i])) return;
            ReferenceType sup = ((ReferenceType)this.locals[i]).getFirstCommonSuperclass((ReferenceType)lv.locals[i]);
            if (sup == null) throw new AssertionViolatedException("Could not load all the super classes of '" + this.locals[i] + "' and '" + lv.locals[i] + "'.");
            this.locals[i] = sup;
            return;
        } else {
            if (this.locals[i].equals(lv.locals[i])) return;
            this.locals[i] = Type.UNKNOWN;
        }
    }

    public String toString() {
        String s = new String();
        int i = 0;
        while (i < this.locals.length) {
            s = s + Integer.toString(i) + ": " + this.locals[i] + "\n";
            ++i;
        }
        return s;
    }

    public void initializeObject(UninitializedObjectType u) {
        int i = 0;
        while (i < this.locals.length) {
            if (this.locals[i] == u) {
                this.locals[i] = u.getInitialized();
            }
            ++i;
        }
    }
}

