/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.ast.parsers.xslt;

import com.ibm.xtq.Constants;
import com.ibm.xtq.ast.XPath20Exception;
import com.ibm.xtq.ast.nodes.CharacterMap;
import com.ibm.xtq.ast.nodes.DirElemConstructor;
import com.ibm.xtq.ast.nodes.Expr;
import com.ibm.xtq.ast.nodes.FunctionDecl;
import com.ibm.xtq.ast.nodes.Node;
import com.ibm.xtq.ast.nodes.Output;
import com.ibm.xtq.ast.nodes.ResultDocument;
import com.ibm.xtq.ast.nodes.SimpleNode;
import com.ibm.xtq.ast.nodes.Template;
import com.ibm.xtq.ast.nodes.Text;
import com.ibm.xtq.ast.nodes.TypeExpr;
import com.ibm.xtq.ast.nodes.UnsupportedElement;
import com.ibm.xtq.ast.nodes.VariableBase;
import com.ibm.xtq.ast.nodes.XTQProgram;
import com.ibm.xtq.ast.parsers.xpath.ParseException;
import com.ibm.xtq.ast.parsers.xpath.XPath;
import com.ibm.xtq.ast.parsers.xpath.factories.ExpressionFactoryImpl;
import com.ibm.xtq.ast.parsers.xslt.ASTBuildingContext;
import com.ibm.xtq.ast.parsers.xslt.XSLT1ParseTables;
import com.ibm.xtq.ast.parsers.xslt.XSLT2ParseTables;
import com.ibm.xtq.ast.parsers.xslt.XSLTParseQNameUtils;
import com.ibm.xtq.ast.parsers.xslt.XSLTParseTables;
import com.ibm.xtq.ast.res.ASTBaseMsg;
import com.ibm.xtq.ast.res.ASTMsg;
import com.ibm.xtq.common.utils.AttributeList;
import com.ibm.xtq.common.utils.ErrorHandler;
import com.ibm.xtq.common.utils.Util;
import com.ibm.xtq.common.utils.XML11Char;
import com.ibm.xtq.common.utils.XMLChar;
import com.ibm.xtq.scontext.MergedCharacterMapsManager;
import com.ibm.xtq.scontext.XStaticContext;
import com.ibm.xtq.utils.LineInfo;
import com.ibm.xtq.utils.Reporter;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class XSLTParser
implements Constants,
ContentHandler,
LexicalHandler,
ASTBuildingContext {
    private static final String XSL = "xsl";
    private Locator _locator = null;
    private XMLReader _reader = null;
    private boolean _debug = false;
    private XSLTParseTables _parseTables;
    private QName _useAttributeSets;
    private Hashtable _variableScope;
    private XTQProgram _currentXTQProgram;
    private XTQProgram _topLevelXTQProgram;
    private Output _output;
    private Template _template;
    private boolean _rootNamespaceDef;
    private Expr _root;
    private String _target;
    private int _currentImportPrecedence;
    private ExpressionFactoryImpl _expressionFactory = new ExpressionFactoryImpl();
    private XStaticContext _staticContext;
    private final boolean _isXSLT20;
    private boolean _xml10Only;
    private boolean _isSecureProcessing;
    private XSLTParseQNameUtils parseUtilsInstance;
    private Reporter _reporter = new Reporter();
    private HashSet _extensionNamespaces = null;
    private String _PImedia = null;
    private String _PItitle = null;
    private String _PIcharset = null;
    private int _templateIndex = 0;
    private Stack _parentStack = null;
    private Stack _entityInfoStack = null;
    private int _elementDepthInEntity = 0;
    private HashMap _prefixMapping = null;

    public XSLTParser() {
        this(false);
        this._xml10Only = false;
    }

    public XSLTParser(boolean bl) {
        this._isXSLT20 = bl;
        this._xml10Only = false;
    }

    public void init() {
        this.getExpressionFactory().setLanguage("XPath1");
        this.parseUtilsInstance = XSLTParseQNameUtils.getInstance();
        this._variableScope = new Hashtable();
        this._template = null;
        this._staticContext = this._expressionFactory.getContext();
        this._currentXTQProgram = null;
        this._output = null;
        this._root = null;
        this._rootNamespaceDef = false;
        this._currentImportPrecedence = 1;
        if (this._isXSLT20) {
            this._parseTables = XSLT2ParseTables.getInstance();
        } else {
            this._parseTables = XSLT1ParseTables.getInstance();
            this._staticContext.setBuiltInNamespaceForFunction();
        }
        this._useAttributeSets = this.getQName("http://www.w3.org/1999/XSL/Transform", XSL, "use-attribute-sets");
    }

    public void reset() {
        this.parseUtilsInstance.reset();
        this._variableScope.clear();
        this._template = null;
        this._currentXTQProgram = null;
        this._output = null;
        this._root = null;
        this._rootNamespaceDef = false;
        this._currentImportPrecedence = 1;
        this._staticContext.reset(this._isXSLT20);
        this._expressionFactory.reset();
        this._reporter.reset();
    }

    public boolean isDebug() {
        return this._debug;
    }

    public void setDebug(boolean bl) {
        this._debug = bl;
    }

    public void setXML10Only(boolean bl) {
        this._xml10Only = bl;
    }

    public boolean isXSLT20() {
        return this._isXSLT20;
    }

    public ExpressionFactoryImpl getExpressionFactory() {
        return this._expressionFactory;
    }

    public XStaticContext getStaticContext() {
        return this._staticContext;
    }

    public void setXMLReader(XMLReader xMLReader) {
        this._reader = xMLReader;
    }

    public XMLReader getXMLReader() {
        return this._reader;
    }

    public void setOutput(Output output) {
        if (this._output != null) {
            if (this._output.getImportPrecedence() <= output.getImportPrecedence()) {
                String string = this._output.getCdata();
                output.mergeCdata(string);
                this._output.disable();
                this._output = output;
            } else {
                output.disable();
            }
        } else {
            this._output = output;
        }
    }

    public Output getOutput() {
        return this._output;
    }

    public Properties getOutputProperties() {
        Properties properties = this.getTopLevelXTQProgram().getOutputProperties();
        return properties;
    }

    public int getCurrentImportPrecedence() {
        return this._currentImportPrecedence;
    }

    public int getNextImportPrecedence() {
        return ++this._currentImportPrecedence;
    }

    public void setCurrentXTQProgram(XTQProgram xTQProgram) {
        this._currentXTQProgram = xTQProgram;
    }

    public XTQProgram getCurrentXTQProgram() {
        return this._currentXTQProgram;
    }

    public XTQProgram getTopLevelXTQProgram() {
        return this._topLevelXTQProgram;
    }

    public void setTopLevelXTQProgram(XTQProgram xTQProgram) {
        this._topLevelXTQProgram = xTQProgram;
    }

    public QName getQNameSafe(String string) {
        return this.parseUtilsInstance.getQNameSafe(string, this._staticContext);
    }

    public QName getQName(String string) {
        return this.parseUtilsInstance.getQName(this, string, true, false, this._staticContext);
    }

    public QName getQNameIgnoreDefaultNs(String string) {
        return this.parseUtilsInstance.getQName(this, string, true, true, this._staticContext);
    }

    public ArrayList getQNameListIgnoreDefaultNs(String string) {
        ArrayList<QName> arrayList = new ArrayList<QName>();
        StringTokenizer stringTokenizer = Util.whitespaceTokenize(string);
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            arrayList.add(this.parseUtilsInstance.getQName(this, string2, true, true, this._staticContext));
        }
        return arrayList;
    }

    public QName getQName(String string, boolean bl) {
        return this.parseUtilsInstance.getQName(this, string, bl, false, this._staticContext);
    }

    public QName getQName(String string, boolean bl, boolean bl2) {
        return this.parseUtilsInstance.getQName(this, string, bl, bl2, this._staticContext);
    }

    public QName getQName(String string, String string2, String string3) {
        return this.parseUtilsInstance.getQName(string, string2, string3);
    }

    public QName getQName(String string, String string2) {
        return this.parseUtilsInstance.getQName(this, string + string2, true, false, this._staticContext);
    }

    public QName getQName(QName qName, QName qName2) {
        return this.parseUtilsInstance.getQName(this, qName.toString() + qName2.toString(), true, false, this._staticContext);
    }

    public QName getUseAttributeSets() {
        return this._useAttributeSets;
    }

    public XTQProgram makeStylesheet(Expr expr) {
        try {
            XTQProgram xTQProgram;
            if (expr instanceof XTQProgram) {
                xTQProgram = (XTQProgram)expr;
                xTQProgram.setParser(this);
                int n = xTQProgram.jjtGetNumChildren();
                for (int i = 0; i < n; ++i) {
                    Expr expr2 = (Expr)xTQProgram.jjtGetChild(i);
                    if (expr2.getId() != 108) continue;
                    this.checkForNullNS(expr2);
                }
            } else {
                xTQProgram = new XTQProgram();
                xTQProgram.setLineInfo(expr.getLineInfo());
                xTQProgram.setParser(this);
                xTQProgram.setSimplified();
                xTQProgram.jjtAppendChild(this, expr);
                xTQProgram.setAttributes(expr.getAttributes());
                xTQProgram.setProgramVersion(expr.getProgramVersion());
                if (expr.lookupNamespace("") == null) {
                    expr.addPrefixMapping("", "");
                }
            }
            return xTQProgram;
        }
        catch (ClassCastException classCastException) {
            ASTMsg aSTMsg = new ASTMsg("NOT_STYLESHEET_ERR", expr);
            this._reporter.report(2, aSTMsg);
            return null;
        }
    }

    public void createAST(XTQProgram xTQProgram) {
        if (xTQProgram != null) {
            xTQProgram.callParseContents(this);
            int n = xTQProgram.jjtGetNumChildren();
            for (int i = 0; i < n; ++i) {
                Node node = xTQProgram.jjtGetChild(i);
                if (!(node instanceof Text)) continue;
                Text text = (Text)node;
                int n2 = text.getLineNumber();
                int n3 = text.getColumnNumber();
                ASTMsg aSTMsg = new ASTMsg("ILLEGAL_TEXT_NODE_ERR", n2, n3, (Object)null);
                this.reportError(3, aSTMsg);
            }
            this.reportDuplicateErrors();
            this.globalUseCharacterMapsErrors(xTQProgram);
        }
    }

    private void globalUseCharacterMapsErrors(XTQProgram xTQProgram) {
        int n;
        int n2;
        Object object;
        Object object2;
        Object object3;
        String string;
        String[] stringArray;
        XStaticContext xStaticContext = this.getStaticContext();
        MergedCharacterMapsManager mergedCharacterMapsManager = xStaticContext.getCharacterMapsManager();
        if (mergedCharacterMapsManager != null && (stringArray = mergedCharacterMapsManager.getReferences()) != null && stringArray.length > 0) {
            Object[] objectArray = mergedCharacterMapsManager.getReferencingNodes();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2;
                String string3;
                string = stringArray[i];
                object3 = mergedCharacterMapsManager.findCharMap(string);
                object2 = (Expr)objectArray[i];
                object = "";
                if (object2 instanceof Output) {
                    if (object3 != null) {
                        ((MergedCharacterMapsManager.CharacterMapRecord)object3).mightBeUsedByOutputOrResultDocument();
                        continue;
                    }
                    object = "xsl:output";
                } else if (object2 instanceof ResultDocument) {
                    if (object3 != null) {
                        ((MergedCharacterMapsManager.CharacterMapRecord)object3).mightBeUsedByOutputOrResultDocument();
                        continue;
                    }
                    object = "xsl:result-document";
                } else if (object2 instanceof CharacterMap) {
                    if (object3 != null) continue;
                    object = "xsl:character-map";
                }
                n2 = string.indexOf(125);
                if (0 <= n2) {
                    string3 = string.substring(n2 + 1);
                    string2 = string.substring(1, n2);
                } else {
                    string3 = string;
                    string2 = "";
                }
                Object[] objectArray2 = new String[]{object, string3, string2};
                ASTMsg aSTMsg = new ASTMsg("USE_CHARACTER_MAPS_NO_NAME_MATCH", objectArray2, (Expr)object2);
                this.reportError(3, aSTMsg);
            }
        }
        stringArray = mergedCharacterMapsManager.getCharacterMapNames();
        for (n = 0; n < stringArray.length; ++n) {
            MergedCharacterMapsManager.CharacterMapRecord characterMapRecord = mergedCharacterMapsManager.findCharMap(stringArray[n]);
            if (!characterMapRecord.isDuplicate()) continue;
            string = characterMapRecord.getURI();
            object3 = characterMapRecord.getLocalName();
            object2 = (MergedCharacterMapsManager.CharacterMapRecord[])characterMapRecord.getExpr();
            object = string == null || string.length() == 0 ? new ASTMsg("CHARACTER_MAP_NAME_DUPLICATES1", object3, (Expr)object2) : new ASTMsg("CHARACTER_MAP_NAME_DUPLICATES2", object3, string, (Expr)object2);
            this.reportError(3, (ASTBaseMsg)object);
        }
        mergedCharacterMapsManager.process();
        block5: for (n = 0; n < stringArray.length; ++n) {
            MergedCharacterMapsManager.CharacterMapRecord characterMapRecord = mergedCharacterMapsManager.findCharMap(stringArray[n]);
            int n3 = mergedCharacterMapsManager.getStatus(stringArray[n]);
            switch (n3) {
                case 3: {
                    object2 = mergedCharacterMapsManager.getCircularList(stringArray[n]);
                    object = new StringBuffer();
                    for (n2 = 0; n2 < ((MergedCharacterMapsManager.CharacterMapRecord[])object2).length; ++n2) {
                        if (0 < n2) {
                            ((StringBuffer)object).append(", ");
                        }
                        ((StringBuffer)object).append(object2[n2].getLexicalQName());
                    }
                    object3 = ((StringBuffer)object).toString();
                    object2 = (Expr)characterMapRecord.getExpr();
                    object = new ASTMsg("USE_CHARACTER_MAPS_CIRCULAR", object3, (Expr)object2);
                    this.reportError(3, (ASTBaseMsg)object);
                    continue block5;
                }
            }
        }
    }

    private void reportDuplicateErrors() {
        Hashtable hashtable = this._staticContext.getStylesheetFunctions();
        if (null != hashtable) {
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                FunctionDecl functionDecl = (FunctionDecl)enumeration.nextElement();
                if (!functionDecl.isDuplicate()) continue;
                String string = functionDecl.getQName().toString();
                ASTMsg aSTMsg = new ASTMsg("FUNCTION_REDEF_ERR", string);
                this.reportError(3, aSTMsg);
            }
        }
    }

    public Expr parse(XMLReader xMLReader, InputSource inputSource) {
        try {
            xMLReader.setContentHandler(this);
            xMLReader.parse(inputSource);
            return this.getStylesheet(this._root);
        }
        catch (IOException iOException) {
            if (this._debug) {
                iOException.printStackTrace();
            }
            this.reportError(2, new ASTMsg(iOException));
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (this._debug) {
                sAXException.printStackTrace();
                if (exception != null) {
                    exception.printStackTrace();
                }
            }
            if (sAXException instanceof SAXParseException) {
                ASTMsg aSTMsg = new ASTMsg("PARSE_ERR", ((SAXParseException)sAXException).getSystemId(), ((SAXParseException)sAXException).getMessage(), ((SAXParseException)sAXException).getLineNumber(), ((SAXParseException)sAXException).getColumnNumber());
                this.reportError(2, aSTMsg);
            }
            this.reportError(2, new ASTMsg(sAXException));
        }
        return null;
    }

    public Expr parse(InputSource inputSource) {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            try {
                sAXParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
            }
            catch (Exception exception) {
                sAXParserFactory.setNamespaceAware(true);
            }
            if (this._isSecureProcessing) {
                sAXParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            return this.parse(xMLReader, inputSource);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ASTMsg aSTMsg = new ASTMsg("ERR_SYSTEM", "SAX parser is not configured correctly.");
            this.reportError(2, aSTMsg);
        }
        catch (SAXParseException sAXParseException) {
            this.reportError(2, new ASTMsg("PARSE_ERR", sAXParseException.getSystemId(), sAXParseException.getMessage(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber()));
        }
        catch (SAXException sAXException) {
            this.reportError(2, new ASTMsg(sAXException.getMessage()));
        }
        return null;
    }

    public Expr getDocumentRoot() {
        return this._root;
    }

    public void setPIParameters(String string, String string2, String string3) {
        this._PImedia = string;
        this._PItitle = string2;
        this._PIcharset = string3;
    }

    private Expr getStylesheet(Expr expr) {
        if (this._target == null) {
            if (!this._rootNamespaceDef) {
                ASTMsg aSTMsg = new ASTMsg("MISSING_XSLT_URI_ERR");
                this._reporter.report(2, aSTMsg);
            }
            return expr;
        }
        if (this._target.charAt(0) == '#') {
            Expr expr2 = this.findStylesheet(expr, this._target.substring(1));
            if (expr2 == null) {
                ASTMsg aSTMsg = new ASTMsg("MISSING_XSLT_TARGET_ERR", (Object)this._target, expr);
                this._reporter.report(2, aSTMsg);
            }
            return expr2;
        }
        return this.loadExternalStylesheet(this._target);
    }

    private Expr findStylesheet(Expr expr, String string) {
        String string2;
        if (expr == null) {
            return null;
        }
        if (expr instanceof XTQProgram && (string2 = expr.getAttribute("id")).equals(string)) {
            return expr;
        }
        int n = expr.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            Expr expr2 = (Expr)expr.jjtGetChild(i);
            Expr expr3 = this.findStylesheet(expr2, string);
            if (expr3 == null) continue;
            return expr3;
        }
        return null;
    }

    private Expr loadExternalStylesheet(String string) {
        InputSource inputSource = new File(string).exists() ? new InputSource("file:" + string) : new InputSource(string);
        Expr expr = this.parse(inputSource);
        return expr;
    }

    public boolean elementSupported(String string, String string2) {
        return this._parseTables.getInstrClass(this.getQName(string, XSL, string2)) != null;
    }

    public Iterator getInstructionItr() {
        return this._parseTables.getInstrQNames();
    }

    public Template getTemplate() {
        return this._template;
    }

    public void setTemplate(Template template) {
        this._template = template;
    }

    public int getTemplateIndex() {
        return this._templateIndex++;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Expr makeInstance(String string, String string2, String string3, Attributes attributes, Expr expr) {
        Expr expr2 = null;
        QName qName = this.getQName(string, string2, string3);
        String string4 = (String)this._parseTables.getInstrClass(qName);
        if (string4 != null) {
            try {
                Class<?> clazz = Class.forName(string4);
                expr2 = (Expr)clazz.newInstance();
                expr2.setNodeQName(qName);
                if (this._locator != null) {
                    expr2.setLineInfo(LineInfo.createLineInfo(this._locator));
                }
                expr2.jjtSetParent(expr);
                if (expr2 instanceof XTQProgram) {
                    if (this._topLevelXTQProgram == null) {
                        this._topLevelXTQProgram = (XTQProgram)expr2;
                    }
                    XTQProgram xTQProgram = (XTQProgram)expr2;
                    xTQProgram.setParser(this);
                }
                expr2.setName(string, string2, string3);
                expr2.setAttributes(new AttributeList(attributes));
                expr2.setPrefixMapping(this._prefixMapping);
                this.setStandardAttributes(string, expr2, attributes, expr);
                this.checkAttributes(expr2, attributes, qName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ASTMsg aSTMsg = new ASTMsg("ERR_SYSTEM", "The class " + expr2 + " can not be found: " + classNotFoundException.getMessage());
                this.reportError(3, aSTMsg);
            }
            catch (IllegalAccessException illegalAccessException) {
                ASTMsg aSTMsg = new ASTMsg("ERR_SYSTEM", "The class " + expr2 + " can not be accessed: " + illegalAccessException.getMessage());
                this.reportError(3, aSTMsg);
            }
            catch (InstantiationException instantiationException) {
                ASTMsg aSTMsg = new ASTMsg("ERR_SYSTEM", "The class " + expr2 + " can not be instantiated: " + instantiationException.getMessage());
                this.reportError(3, aSTMsg);
            }
        } else if (string != null) {
            expr2 = new UnsupportedElement(string, string2, string3);
            expr2.setNodeQName(qName);
            if (this._locator != null) {
                expr2.setLineInfo(LineInfo.createLineInfo(this._locator));
            }
            expr2.jjtSetParent(expr);
            expr2.setAttributes(new AttributeList(attributes));
            expr2.setPrefixMapping(this._prefixMapping);
            this.setStandardAttributes(string, expr2, attributes, expr);
            if (string.equals("http://www.w3.org/1999/XSL/Transform")) {
                UnsupportedElement unsupportedElement = (UnsupportedElement)expr2;
                ASTMsg aSTMsg = new ASTMsg("UNSUPPORTED_XSL_ERR", expr2.getLineNumber(), expr2.getColumnNumber(), string3);
                unsupportedElement.setErrorMessage(aSTMsg);
                try {
                    double d = Double.valueOf(unsupportedElement.getProgramVersion());
                    if (!(d <= 2.0)) {
                        // empty if block
                    }
                }
                catch (Exception exception) {
                    ASTMsg aSTMsg2 = new ASTMsg("ERR_SYSTEM", (Object)exception.getMessage(), (Expr)unsupportedElement);
                    this.reportError(2, aSTMsg2);
                }
            } else if (string.equals("http://xml.apache.org/xalan/xsltc")) {
                UnsupportedElement unsupportedElement = (UnsupportedElement)expr2;
                unsupportedElement.setIsExtension();
                ASTMsg aSTMsg = new ASTMsg("UNSUPPORTED_EXT_ERR", expr2.getLineNumber(), expr2.getColumnNumber(), string3);
                unsupportedElement.setErrorMessage(aSTMsg);
            } else {
                XTQProgram xTQProgram = this._topLevelXTQProgram;
                if (xTQProgram != null && expr2.isExtension(string) && xTQProgram != expr) {
                    UnsupportedElement unsupportedElement = (UnsupportedElement)expr2;
                    unsupportedElement.setIsExtension();
                    ASTMsg aSTMsg = new ASTMsg("UNSUPPORTED_EXT_ERR", expr2.getLineNumber(), expr2.getColumnNumber(), string2 + ":" + string3);
                    unsupportedElement.setErrorMessage(aSTMsg);
                } else {
                    LineInfo lineInfo = expr2.getLineInfo();
                    expr2 = new DirElemConstructor(108);
                    expr2.jjtSetParent(expr);
                    expr2.setAttributes(new AttributeList(attributes));
                    expr2.setPrefixMapping(this._prefixMapping);
                    this.setStandardAttributes(string, expr2, attributes, expr);
                    expr2.setLineInfo(lineInfo);
                    this.checkAttributes(expr2, attributes, qName);
                }
            }
        }
        if (expr2 != null && expr2 instanceof DirElemConstructor) {
            ((DirElemConstructor)expr2).setQName(qName);
        }
        return expr2;
    }

    private void checkAttributes(Expr expr, Attributes attributes, QName qName) {
        int n;
        String[] stringArray = this._parseTables.getRequiredAttrs(qName);
        String[] stringArray2 = this._parseTables.getOptAttrs(qName);
        String string = expr.getProgramVersion();
        double d = Double.valueOf(string);
        this.checkForStandardAttrsOnLRE(expr, qName, attributes);
        ArrayList<String> arrayList = null;
        if (stringArray != null) {
            arrayList = new ArrayList<String>(stringArray.length);
            for (n = 0; n < stringArray.length; ++n) {
                arrayList.add(stringArray[n]);
            }
        }
        if (d <= 2.0 && (stringArray != null || stringArray2 != null)) {
            int n2 = attributes.getLength();
            for (int i = 0; i < n2; ++i) {
                Object object;
                String string2 = attributes.getQName(i);
                if (this._isXSLT20 ? string2.startsWith("xml") || string2.indexOf(58) > 0 && !attributes.getURI(i).equals("http://www.w3.org/1999/XSL/Transform") : string2.startsWith("xml") || string2.indexOf(58) > 0) continue;
                boolean bl = false;
                if (stringArray != null) {
                    for (n = 0; n < stringArray.length; ++n) {
                        if (!string2.equalsIgnoreCase(stringArray[n])) continue;
                        bl = true;
                        arrayList.remove(stringArray[n]);
                        break;
                    }
                }
                if (stringArray2 != null && !bl) {
                    for (n = 0; n < stringArray2.length; ++n) {
                        if (!string2.equalsIgnoreCase(stringArray2[n])) continue;
                        bl = true;
                        break;
                    }
                }
                if (!bl) {
                    if (!this._isXSLT20 && string.equals("2.0")) {
                        this._parseTables = XSLT2ParseTables.getInstance();
                    }
                    object = this._parseTables.getStdAttrs();
                    for (n = 0; n < ((HashMap)object).size(); ++n) {
                        if (!((HashMap)object).containsKey(string2)) continue;
                        bl = true;
                        break;
                    }
                }
                if (bl) continue;
                object = new ASTMsg("ILLEGAL_ATTRIBUTE_ERR", (Object)string2, expr);
                this.reportError(5, (ASTBaseMsg)object);
            }
            if (!arrayList.isEmpty()) {
                for (n = 0; n < arrayList.size(); ++n) {
                    ASTMsg aSTMsg = new ASTMsg("REQUIRED_ATTR_ERR", (Object)((String)arrayList.get(n)), expr);
                    this.reportError(3, aSTMsg);
                }
            }
        }
    }

    public boolean checkAttributeValue(Expr expr, String string, String string2, String string3, int n) {
        int n2 = this._parseTables.getAttributeTypeIndex(string2);
        boolean bl = false;
        switch (n2) {
            case 0: {
                bl = this.checkFixedAttributeValues(expr, string, string2, string3, n);
                break;
            }
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            case 3: {
                if (XMLChar.isValidToken(string3)) {
                    bl = true;
                    break;
                }
                ASTMsg aSTMsg = new ASTMsg("INVALID_ATTR_VALUE_ERR", "'token'", string3, expr);
                this.reportError(n, aSTMsg);
                bl = false;
                break;
            }
            case 4: {
                bl = true;
                break;
            }
            case 5: {
                if (this.isValidQName(string3)) {
                    bl = true;
                    break;
                }
                ASTMsg aSTMsg = new ASTMsg("INVALID_ATTR_VALUE_ERR", "QName", string3, expr);
                this.reportError(n, aSTMsg);
                bl = false;
                break;
            }
            case 6: {
                String string4 = this.invalidQNames(string3, null);
                if (string4 == null) {
                    bl = true;
                    break;
                }
                ASTMsg aSTMsg = new ASTMsg("INVALID_ATTR_LIST_VALUE_ERR", "QNames", string4, expr);
                this.reportError(n, aSTMsg);
                bl = false;
                break;
            }
            case 7: {
                bl = true;
                break;
            }
            case 8: {
                bl = true;
                break;
            }
            case 9: {
                bl = true;
                break;
            }
            case 10: {
                bl = true;
                break;
            }
            case 11: {
                if (XMLChar.isValidNCName(string3)) {
                    bl = true;
                    break;
                }
                ASTMsg aSTMsg = new ASTMsg("INVALID_ATTR_VALUE_ERR", "NCName", string3, expr);
                this.reportError(n, aSTMsg);
                bl = false;
                break;
            }
            case 12: {
                if (XMLChar.isValidNmtoken(string3)) {
                    bl = true;
                    break;
                }
                ASTMsg aSTMsg = new ASTMsg("INVALID_ATTR_VALUE_ERR", "NMTOKEN", string3, expr);
                this.reportError(n, aSTMsg);
                bl = false;
                break;
            }
            case 13: {
                bl = true;
                break;
            }
            case 14: {
                bl = true;
                break;
            }
            case 15: {
                bl = true;
                break;
            }
            case 16: {
                bl = true;
                break;
            }
            case 17: {
                bl = true;
                break;
            }
            case 18: {
                bl = true;
                break;
            }
            case 19: {
                bl = true;
                break;
            }
            case 20: {
                if (XMLChar.isValidQNameButNotNCName(string3)) {
                    bl = true;
                    break;
                }
                ASTMsg aSTMsg = new ASTMsg("INVALID_ATTR_VALUE_ERR", "qname-but-not-ncname", string3, expr);
                this.reportError(n, aSTMsg);
                bl = false;
            }
        }
        return bl;
    }

    private boolean checkFixedAttributeValues(Expr expr, String string, String string2, String string3, int n) {
        String[] stringArray = this._parseTables.getFixedAttributeValues(string2);
        String string4 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (string3.equals(stringArray[i])) {
                return true;
            }
            string4 = string4 + "'" + stringArray[i] + "'";
            if (i >= stringArray.length - 1) continue;
            string4 = string4 + " | ";
        }
        Object[] objectArray = new String[]{string, string2, string3, string4};
        ASTMsg aSTMsg = new ASTMsg("INVALID_FIXED_ATTR_VALUE_ERR", objectArray, expr);
        this.reportError(n, aSTMsg);
        return false;
    }

    boolean isExtension(QName qName) {
        String string = qName.getNamespaceURI();
        return string != null && !string.equals("") && !string.equals("http://www.w3.org/1999/XSL/Transform");
    }

    public ArrayList getAllowedChildren(Expr expr) {
        QName qName = expr.getNodeQName();
        if (expr.getId() == 108) {
            qName = ((DirElemConstructor)expr).getQName();
            return this._parseTables.getAllowedChildrenList(this.parseUtilsInstance.getQName("http://www.w3.org/1999/XSL/Transform", XSL, "element"));
        }
        return this._parseTables.getAllowedChildrenList(qName);
    }

    public void checkAllowedChildren(Expr expr) {
        int n = expr.jjtGetNumChildren();
        ArrayList arrayList = this.getAllowedChildren(expr);
        QName qName = expr.getNodeQName();
        if (expr.getId() == 108) {
            qName = ((DirElemConstructor)expr).getQName();
        }
        for (int i = 0; i < n; ++i) {
            Expr expr2 = (Expr)expr.jjtGetChild(i);
            int n2 = expr2.getId();
            QName qName2 = expr2.getNodeQName();
            if ((arrayList == null || arrayList.contains(new Integer(n2))) && (arrayList != null || n <= 0)) continue;
            String[] stringArray = new String[2];
            if (n2 == 108) {
                qName2 = ((DirElemConstructor)expr2).getQName();
            }
            if (qName2 == null) continue;
            stringArray[0] = qName.getPrefix().equals("") ? "<" : "<" + qName.getPrefix() + ":";
            stringArray[0] = stringArray[0] + qName.getLocalPart() + ">";
            stringArray[1] = qName2.getPrefix().equals("") ? "<" : "<" + qName2.getPrefix() + ":";
            stringArray[1] = stringArray[1] + qName2.getLocalPart() + ">";
            ASTMsg aSTMsg = new ASTMsg("INVALID_CHILD_ERR", stringArray[0], stringArray[1], expr);
            this.reportError(3, aSTMsg);
        }
    }

    public void checkNodesOrder(Expr expr) {
        if (expr.getChildren() == null) {
            return;
        }
        int n = expr.getId();
        Iterator iterator = expr.getChildren().iterator();
        switch (n) {
            case 3: {
                Object object;
                boolean bl = false;
                boolean bl2 = false;
                while (iterator.hasNext()) {
                    object = (Expr)iterator.next();
                    int n2 = ((SimpleNode)object).getId();
                    if (n2 == 228 && ((Text)object).isIgnore()) continue;
                    if (n2 == 221 && ((SimpleNode)object).jjtGetParent() == expr) {
                        bl = true;
                        continue;
                    }
                    if (bl) continue;
                    bl2 = true;
                }
                if (!bl || !bl2) break;
                object = new ASTMsg("ERR_ORDER_IMPORT");
                this.reportError(3, (ASTBaseMsg)object);
                break;
            }
            case 201: 
            case 202: 
            case 209: {
                Object object;
                boolean bl = false;
                boolean bl3 = false;
                while (iterator.hasNext()) {
                    object = (Expr)iterator.next();
                    int n3 = ((SimpleNode)object).getId();
                    if (n3 == 228 && ((Text)object).isIgnore()) continue;
                    if (n3 == 211) {
                        bl3 = true;
                        continue;
                    }
                    if (bl3) continue;
                    bl = true;
                }
                if (!bl3 || !bl) break;
                object = new ASTMsg("SORT_POSITION_ERR", expr.getNodeQName());
                this.reportError(3, (ASTBaseMsg)object);
                break;
            }
            case 197: {
                Object object;
                int n4 = 0;
                int n5 = 0;
                while (iterator.hasNext()) {
                    object = (Expr)iterator.next();
                    int n6 = ((SimpleNode)object).getId();
                    if (n6 == 228 && ((Text)object).isIgnore()) continue;
                    if (n6 == 215) {
                        if (n5 > 0) {
                            ASTMsg aSTMsg = new ASTMsg("WHEN_ELEMENT_ERR");
                            this.reportError(3, aSTMsg);
                        }
                        ++n4;
                        continue;
                    }
                    ++n5;
                }
                if (n4 == 0) {
                    object = new ASTMsg("MISSING_WHEN_ERR");
                    this.reportError(3, (ASTBaseMsg)object);
                }
                if (n5 <= true) break;
                object = new ASTMsg("MULTIPLE_OTHERWISE_ERR");
                this.reportError(3, (ASTBaseMsg)object);
            }
        }
    }

    public Expr parseExpression(ASTBuildingContext aSTBuildingContext, Expr expr, String string) {
        Expr expr2 = null;
        try {
            this._expressionFactory.setExprContext(expr);
            expr2 = this._expressionFactory.createExpr(aSTBuildingContext, string);
            if (expr2.getId() == 40 && expr2.jjtGetNumChildren() == 1) {
                expr2 = (Expr)expr2.jjtGetChild(0);
            }
            expr2.jjtSetParent(expr);
        }
        catch (XPath20Exception xPath20Exception) {
            if (this._debug) {
                xPath20Exception.printStackTrace();
            }
            this.reportError(3, new ASTMsg("XPATH_PARSER_ERR", (Object)string, expr));
        }
        return expr2;
    }

    public TypeExpr parseSequenceTypeExpression(Expr expr, String string) {
        TypeExpr typeExpr = null;
        try {
            this._expressionFactory.setExprContext(expr);
            this._expressionFactory.setContext(this._staticContext);
            XPath xPath = new XPath((ASTBuildingContext)this, new StringReader(string));
            try {
                QName qName;
                String string2;
                TypeExpr typeExpr2 = xPath.SequenceTypeStandalone();
                if (string.indexOf(58) == -1 && !(string2 = expr.getDefaultNS()).equals("") && (qName = typeExpr2.getTypeName()) != null) {
                    QName qName2 = this._expressionFactory.createQName(string2, qName.getLocalPart(), qName.getPrefix());
                    typeExpr2.setTypeName(qName2);
                }
                typeExpr2.jjtSetParent(null);
                typeExpr = typeExpr2;
            }
            catch (ParseException parseException) {
                throw new XPath20Exception(parseException);
            }
            if (typeExpr.getId() == 40 && typeExpr.jjtGetNumChildren() == 1) {
                typeExpr = (TypeExpr)typeExpr.jjtGetChild(0);
            }
            typeExpr.jjtSetParent(expr);
        }
        catch (XPath20Exception xPath20Exception) {
            if (this._debug) {
                xPath20Exception.printStackTrace();
            }
            this.reportError(3, new ASTMsg("XPATH_PARSER_ERR", (Object)string, expr));
        }
        return typeExpr;
    }

    public Expr parseExpression(Expr expr, String string, String string2) {
        String string3 = expr.getAttribute(string);
        if (string3.length() == 0 && string2 != null) {
            string3 = string2;
        }
        return this.parseExpression(this, expr, string3);
    }

    public Expr parseExpression(String string) {
        Expr expr = null;
        try {
            expr = this._expressionFactory.createExpr(this, string);
            if (expr.getId() == 40 && expr.jjtGetNumChildren() == 1) {
                expr = (Expr)expr.jjtGetChild(0);
            }
        }
        catch (XPath20Exception xPath20Exception) {
            if (this._debug) {
                xPath20Exception.printStackTrace();
            }
            this.reportError(3, new ASTMsg("XPATH_PARSER_ERR", string));
        }
        return expr;
    }

    public Expr parsePattern(Expr expr, String string) {
        Expr expr2 = null;
        try {
            this._expressionFactory.setExprContext(expr);
            expr2 = this._expressionFactory.createPattern(this, this._staticContext, string);
            if (null != expr2) {
                expr2.jjtSetParent(expr);
            }
        }
        catch (XPath20Exception xPath20Exception) {
            if (this._debug) {
                xPath20Exception.printStackTrace();
            }
            this.reportError(3, new ASTMsg("XPATH_PARSER_ERR", (Object)string, expr));
        }
        return expr2;
    }

    public Expr parsePattern(Expr expr, String string, String string2) {
        String string3 = expr.getAttribute(string);
        if (string3 != null && string3.startsWith("//")) {
            String string4;
            int n = string3.indexOf("key");
            if (n == -1) {
                n = string3.indexOf("id");
            }
            if ((string4 = string3.substring(n + 1)).indexOf("key") > -1 || string4.indexOf("id") > -1) {
                ASTMsg aSTMsg = new ASTMsg("ERR_TOP_PATTERN", string3);
                this.reportError(3, aSTMsg);
            }
        }
        if (string3.length() == 0 && string2 != null) {
            string3 = string2;
        }
        return this.parsePattern(expr, string3);
    }

    public boolean errorsFound() {
        return this._reporter.errorsFound();
    }

    public void printErrors() {
        this._reporter.printErrors();
    }

    public void printWarnings() {
        this._reporter.printWarnings();
    }

    public void reportError(int n, ASTBaseMsg aSTBaseMsg) {
        this._reporter.report(n, aSTBaseMsg);
    }

    public void reportError(int n, String string) {
        int n2 = this._locator.getLineNumber();
        int n3 = this._locator.getColumnNumber();
        ASTMsg aSTMsg = new ASTMsg(string, n2, n3, (Object)null);
        this.reportError(n, aSTMsg);
    }

    public Vector getErrors() {
        return this._reporter.getErrors();
    }

    public Vector getWarnings() {
        return this._reporter.getWarnings();
    }

    public void startDocument() {
        this._root = null;
        this._target = null;
        this._prefixMapping = null;
        this._parentStack = new Stack();
        if (this._locator != null) {
            this._entityInfoStack = new Stack();
        }
    }

    public void endDocument() {
    }

    public void startPrefixMapping(String string, String string2) {
        if (this._prefixMapping == null) {
            this._prefixMapping = new HashMap();
        }
        this._prefixMapping.put(string, string2);
    }

    public void endPrefixMapping(String string) {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Expr expr;
        int n = string3.lastIndexOf(58);
        String string4 = n == -1 ? "" : string3.substring(0, n);
        Expr expr2 = this._root == null ? null : (Expr)this._parentStack.peek();
        if (string == null) {
            string = "";
        }
        if ((expr = this.makeInstance(string, string4, string2, attributes, expr2)) == null) {
            ASTMsg aSTMsg = new ASTMsg("ELEMENT_PARSE_ERR", string4 + ':' + string2);
            throw new SAXException(aSTMsg.toString());
        }
        if (this._root == null) {
            this._rootNamespaceDef = this._prefixMapping != null && this._prefixMapping.containsValue("http://www.w3.org/1999/XSL/Transform");
            this._root = expr;
        } else {
            expr2.jjtAppendChild(this, expr);
            expr.jjtSetParent(expr2);
        }
        this._prefixMapping = null;
        this._parentStack.push(expr);
        ++this._elementDepthInEntity;
        expr.setIsTopLevelElementInEntity(this._elementDepthInEntity == 1);
    }

    public void endElement(String string, String string2, String string3) {
        this._parentStack.pop();
        --this._elementDepthInEntity;
    }

    private void setStandardAttributes(String string, Expr expr, Attributes attributes, Expr expr2) {
        int n = attributes.getLength();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = null;
        String string3 = null;
        for (int i = 0; i < n; ++i) {
            Object object;
            String string4;
            String string5 = attributes.getURI(i);
            if (string5 == null) {
                string5 = "";
            }
            if ((string4 = attributes.getLocalName(i)) == null) {
                string4 = "";
            }
            if (string5.equals("http://www.w3.org/XML/1998/namespace") && string4.equals("base")) {
                expr.setBaseURI(attributes.getValue(i));
                bl3 = true;
                continue;
            }
            if ((!string5.equals("") || string == null || !string.equals("http://www.w3.org/1999/XSL/Transform")) && !string5.equals("http://www.w3.org/1999/XSL/Transform")) continue;
            if (string4.equals("version")) {
                expr.setProgramVersion(attributes.getValue(i));
                bl = true;
                continue;
            }
            if (string4.equals("xpath-default-namespace")) {
                expr.setDefaultElementTypeNamespace(attributes.getValue(i));
                bl2 = true;
                continue;
            }
            if (string4.equals("exclude-result-prefixes")) {
                string2 = attributes.getValue(i);
                if (this.invalidNCNames(string2, (String[])(object = new String[]{"#default"})) == null || string2.equals("#all")) continue;
                ASTMsg aSTMsg = new ASTMsg("INVALID_NCNAME_ERR", (Object)string2, this);
                this.reportError(3, aSTMsg);
                continue;
            }
            if (!string4.equals("extension-element-prefixes") || this.invalidNCNames(string3 = attributes.getValue(i), null) == null) continue;
            object = new ASTMsg("INVALID_NCNAME_ERR", (Object)string3, this);
            this.reportError(3, (ASTBaseMsg)object);
        }
        if (!bl) {
            if (null == expr2) {
                expr.setProgramVersion("2.0");
            } else {
                expr.setProgramVersion(expr2.getProgramVersion());
            }
        }
        if (!bl2) {
            if (null == expr2) {
                expr.setDefaultElementTypeNamespace("");
            } else {
                expr.setDefaultElementTypeNamespace(expr2.getDefaultNS());
            }
        }
        expr.setExcludeResultPrefixes(this, string2, expr2);
        expr.setExtensionElemPrefixes(string3, expr2);
        expr.excludePrefixes(this);
    }

    public void characters(char[] cArray, int n, int n2) {
        Text text;
        String string = new String(cArray, n, n2);
        Expr expr = (Expr)this._parentStack.peek();
        if (string.length() == 0) {
            return;
        }
        if (expr instanceof Text) {
            ((Text)expr).setText(string);
            return;
        }
        if (Util.trimWhitespace(string).length() != 0 && expr instanceof XTQProgram) {
            if (this._isXSLT20) {
                this.reportError(2, "STYLESHEET_HAS_TEXT_NODE");
            } else {
                this.reportError(3, "ILLEGAL_TEXT_NODE_ERR");
            }
        }
        if (expr instanceof XTQProgram) {
            return;
        }
        Expr expr2 = expr.lastChild();
        if (expr2 != null && expr2 instanceof Text && !(text = (Text)expr2).isTextElement() && n2 >= 1) {
            text.setText(string);
            return;
        }
        expr.jjtAppendChild(this, new Text(string, expr.getProgramVersion()));
    }

    private String getTokenValue(String string) {
        int n = string.indexOf(34);
        int n2 = string.lastIndexOf(34);
        if (n < 0) {
            int n3 = string.indexOf(39);
            int n4 = string.lastIndexOf(39);
            if (n3 < 0) {
                return string;
            }
            return string.substring(n3 + 1, n4);
        }
        return string.substring(n + 1, n2);
    }

    public void processingInstruction(String string, String string2) {
        if (this._target == null && string.equals("xml-stylesheet")) {
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            StringTokenizer stringTokenizer = Util.whitespaceTokenize(string2);
            while (stringTokenizer.hasMoreElements()) {
                String string7 = (String)stringTokenizer.nextElement();
                if (string7.startsWith("href")) {
                    string3 = this.getTokenValue(string7);
                    continue;
                }
                if (string7.startsWith("media")) {
                    string4 = this.getTokenValue(string7);
                    continue;
                }
                if (string7.startsWith("title")) {
                    string5 = this.getTokenValue(string7);
                    continue;
                }
                if (!string7.startsWith("charset")) continue;
                string6 = this.getTokenValue(string7);
            }
            if (!(this._PImedia != null && !this._PImedia.equals(string4) || this._PItitle != null && !this._PImedia.equals(string5) || this._PIcharset != null && !this._PImedia.equals(string6))) {
                this._target = string3;
            }
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
    }

    public void skippedEntity(String string) {
    }

    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    public boolean isReservedNamespace(String string) {
        return this._parseTables.hasReservedNamespace(string);
    }

    public Properties getMergedXslOuputProperties(String string) {
        XTQProgram xTQProgram = this.getTopLevelXTQProgram();
        Properties properties = xTQProgram.getEffectiveMergedXslOutputProperties(string);
        return properties;
    }

    public void AppendExpandedQName(StringBuffer stringBuffer, String string) {
        int n = string.lastIndexOf(58);
        if (n != -1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            String string4 = null;
            string4 = this._staticContext.lookupNamespace(string2);
            if (string4 == null) {
                stringBuffer.append(string3);
            } else {
                stringBuffer.append('{');
                stringBuffer.append(string4);
                stringBuffer.append('}');
                stringBuffer.append(string3);
            }
        } else {
            String string5 = string;
            String string6 = this._staticContext.lookupNamespace("");
            if (!"".equals(string6)) {
                stringBuffer.append('{');
                stringBuffer.append(string6);
                stringBuffer.append('}');
            }
            stringBuffer.append(string5);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        int n = stringArray.length;
        int n2 = 0;
        boolean bl = false;
        File file = null;
        String string = "2.0";
        while (n > 0) {
            if (stringArray[n2].equals("-dumptree")) {
                bl = true;
                ++n2;
                --n;
                continue;
            }
            if ("-file".equalsIgnoreCase(stringArray[n2])) {
                --n;
                file = new File(stringArray[++n2]);
                ++n2;
                --n;
                continue;
            }
            if ("-xsltversion".equalsIgnoreCase(stringArray[n2])) {
                --n;
                string = stringArray[++n2];
                ++n2;
                --n;
                continue;
            }
            if (stringArray[n2].endsWith(".xslt") || stringArray[n2].endsWith(".xsl")) {
                System.out.println("Running test for: " + stringArray[n2]);
                file = new File(stringArray[n2]);
                ++n2;
                --n;
                continue;
            }
            if ("-catalog".equalsIgnoreCase(stringArray[n2])) {
                System.err.println("-catalog not yet implemented");
                System.exit(-1);
                continue;
            }
            System.out.println("XSLTParser [-dumptree] -file {filename}");
        }
        XTQProgram xTQProgram = XSLTParser.makeAST(file, string);
        if (null != xTQProgram) {
            xTQProgram.dump("|", System.out);
        } else {
            System.err.println("Could not process XSLT file!");
        }
    }

    private static XTQProgram makeAST(File file, String string) {
        InputSource inputSource = new InputSource(file.getAbsolutePath());
        return XSLTParser.makeAST(inputSource, string);
    }

    private static XTQProgram makeAST(InputSource inputSource, String string) {
        XSLTParser xSLTParser = new XSLTParser(string.equals("2.0"));
        xSLTParser.init();
        return xSLTParser.makeAST(inputSource);
    }

    public XTQProgram makeAST(InputSource inputSource) {
        XMLReader xMLReader = this.getXMLReader();
        Expr expr = xMLReader == null ? this.parse(inputSource) : this.parse(xMLReader, inputSource);
        if (!this.errorsFound() && expr != null) {
            XTQProgram xTQProgram = this.makeStylesheet(expr);
            this.setTopLevelXTQProgram(xTQProgram);
            xTQProgram.setSystemId(inputSource.getSystemId());
            xTQProgram.setPublicId(inputSource.getPublicId());
            xTQProgram.setParentXTQProgram(null);
            this.setCurrentXTQProgram(xTQProgram);
            this.createAST(xTQProgram);
            return xTQProgram;
        }
        this.printWarnings();
        this.printErrors();
        return null;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this._reporter.setErrorHandler(errorHandler);
    }

    public boolean getSecureProcessing() {
        return this._isSecureProcessing;
    }

    public void setSecureProcessing(boolean bl) {
        this._isSecureProcessing = bl;
    }

    public boolean isValidQName(String string) {
        boolean bl = !this._xml10Only ? XML11Char.isXML11ValidQName(string) : XMLChar.isValidQName(string);
        return bl;
    }

    public boolean isValidNCName(String string) {
        boolean bl = !this._xml10Only ? XML11Char.isXML11ValidNCName(string) : XMLChar.isValidNCName(string);
        return bl;
    }

    public String invalidQNames(String string, String[] stringArray) {
        String string2 = this.invalidNames(true, string, stringArray);
        return string2;
    }

    public String invalidNCNames(String string, String[] stringArray) {
        String string2 = this.invalidNames(false, string, stringArray);
        return string2;
    }

    private String invalidNames(boolean bl, String string, String[] stringArray) {
        String string2 = null;
        if (string != null && !string.equals("")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if ((!bl || this.isValidQName(string3)) && (bl || this.isValidNCName(string3))) continue;
                boolean bl2 = false;
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!stringArray[i].equals(string3)) continue;
                        bl2 = true;
                        break;
                    }
                }
                if (bl2) continue;
                if (string2 == null) {
                    string2 = string3;
                    continue;
                }
                string2 = string2 + ' ';
                string2 = string2 + string3;
            }
        }
        return string2;
    }

    public void checkForStandardAttrsOnLRE(Expr expr, QName qName, Attributes attributes) {
        HashMap hashMap = this._parseTables.getStdAttrs();
        if (expr.getId() == 108) {
            String string = null;
            String string2 = null;
            String string3 = null;
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                string = attributes.getQName(i);
                string2 = attributes.getLocalName(i);
                string3 = attributes.getURI(i);
                if (!this.isXSLT20()) continue;
                if (string3 != null && string3.equals("http://www.w3.org/1999/XSL/Transform")) {
                    if (hashMap == null || hashMap.isEmpty() || hashMap.containsKey(string2) || string2.equals("use-attribute-sets")) continue;
                    ASTMsg aSTMsg = new ASTMsg("ATTR_ERR", (Object)string, this);
                    this.reportError(3, aSTMsg);
                    continue;
                }
                if (!string.startsWith("xml") && string.indexOf(58) > 0 && attributes.getURI(i).equals("http://www.w3.org/1999/XSL/Transform")) continue;
            }
        }
    }

    public void checkForNullNS(Expr expr) {
        QName qName;
        String string;
        String string2;
        if (expr.getId() == 108 && ((string2 = expr.lookupNamespace(string = (qName = ((DirElemConstructor)expr).getQName()).getPrefix())) == null || string2 == "")) {
            ASTMsg aSTMsg = new ASTMsg("NULL_NS_TOPLEVEL_CHILD", qName);
            this.reportError(3, aSTMsg);
        }
    }

    public void checkAttributeLength(Expr expr, String string, String string2) {
        if (expr.getId() == 206 && string.equals("grouping-separator") && !string2.startsWith("{") && string2.length() > 1) {
            ASTMsg aSTMsg = new ASTMsg("ELEMENT_CONTENT_ERR", string);
            this.reportError(3, aSTMsg);
        }
    }

    public Reporter getReporter() {
        return this._reporter;
    }

    public boolean isExtensionNamespace(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (this._extensionNamespaces == null) {
            this._extensionNamespaces = new HashSet();
            this._extensionNamespaces.add("http://www.ibm.com/xmlns/prod/xltxe-j");
            this._extensionNamespaces.add("http://xml.apache.org/xalan");
            this._extensionNamespaces.add("http://xml.apache.org/xslt");
        }
        return this._extensionNamespaces.contains(string);
    }

    public void hasDuplicateVarDeclaration(VariableBase variableBase) {
        QName qName = variableBase.getQName();
        if ((variableBase.getId() == 29 || variableBase.getId() == 34) && variableBase.isDuplicate()) {
            ASTMsg aSTMsg = new ASTMsg("VAR_REDEF_ERR", qName);
            this.reportError(3, aSTMsg);
        }
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void startEntity(String string) throws SAXException {
        if (this._entityInfoStack != null) {
            this._entityInfoStack.push(new Integer(this._elementDepthInEntity));
        }
    }

    public void endEntity(String string) throws SAXException {
        this._elementDepthInEntity = (Integer)this._entityInfoStack.pop();
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
    }
}

