/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.ast.nodes;

import com.ibm.xtq.ast.nodes.Expr;
import com.ibm.xtq.ast.nodes.OutputCharacter;
import com.ibm.xtq.ast.nodes.TopLevelDecl;
import com.ibm.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xtq.ast.res.ASTBaseMsg;
import com.ibm.xtq.ast.res.ASTMsg;
import com.ibm.xtq.common.utils.Util;
import com.ibm.xtq.common.utils.XMLChar;
import com.ibm.xtq.scontext.MergedCharacterMapsManager;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;

public final class CharacterMap
extends TopLevelDecl {
    private String m_name;
    private String m_expandedName;
    private String m_use_character_maps;

    public CharacterMap(int n) {
        super(n);
    }

    public CharacterMap() {
        super(218);
    }

    public void parseContents(XSLTParser xSLTParser) {
        Attributes attributes = this.getAttributes();
        if (attributes != null) {
            String string = null;
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                String string2 = attributes.getLocalName(i);
                String string3 = attributes.getValue(i);
                if ("use-character-maps".equals(string2)) {
                    this.setUseCharacterMaps(string3);
                    continue;
                }
                if (!"name".equals(string2)) continue;
                string = string3;
                this.setName(xSLTParser, string);
            }
            this.processUseCharacterMaps(xSLTParser);
            this.parseOwnChildren(xSLTParser);
        }
    }

    private void parseOwnChildren(XSLTParser xSLTParser) {
        int n = this.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            Expr expr = (Expr)this.jjtGetChild(i);
            if (!(expr instanceof OutputCharacter)) continue;
            xSLTParser.getStaticContext().setCurrentNode(expr);
            expr.callParseContents(xSLTParser);
        }
    }

    private void processUseCharacterMaps(XSLTParser xSLTParser) {
        String string;
        Object object;
        MergedCharacterMapsManager mergedCharacterMapsManager = xSLTParser.getStaticContext().getCharacterMapsManager();
        boolean bl = true;
        if (this.m_expandedName != null) {
            object = mergedCharacterMapsManager.findCharMap(this.m_expandedName);
            if (object != null && ((MergedCharacterMapsManager.CharacterMapRecord)object).getImportPrecedence() > this.getImportPrecedence()) {
                bl = false;
            } else if (object != null && ((MergedCharacterMapsManager.CharacterMapRecord)object).getImportPrecedence() == this.getImportPrecedence()) {
                ((MergedCharacterMapsManager.CharacterMapRecord)object).markDuplicate();
                bl = false;
            } else {
                object = mergedCharacterMapsManager.getCharMap(this.m_expandedName, this.getImportPrecedence());
                string = this.getLexicalQName();
                ((MergedCharacterMapsManager.CharacterMapRecord)object).setLexicalQName(string);
                ((MergedCharacterMapsManager.CharacterMapRecord)object).setExpr(this);
                bl = true;
            }
        }
        if (this.m_expandedName != null && this.m_use_character_maps != null) {
            object = Util.whitespaceTokenize(this.m_use_character_maps);
            while (((StringTokenizer)object).hasMoreTokens()) {
                Object object2;
                string = ((StringTokenizer)object).nextToken();
                if (!XMLChar.isValidQName(string)) {
                    object2 = new ASTMsg("USE_CHARACTER_MAPS_NOT_LEXICAL_QNAME", (Object)string, "xsl:charater-map");
                    xSLTParser.reportError(3, (ASTBaseMsg)object2);
                    continue;
                }
                object2 = this.getExpandedQName(xSLTParser, string);
                if (object2 != null) {
                    if (!bl) continue;
                    mergedCharacterMapsManager.setDependancy(this.m_expandedName, (String)object2);
                    mergedCharacterMapsManager.characterMapIsReferenced((String)object2, this);
                    continue;
                }
                ASTMsg aSTMsg = new ASTMsg("USE_CHARACTER_MAPS_NO_URI", (Object)string, "xsl:charater-map");
                xSLTParser.reportError(3, aSTMsg);
            }
        }
    }

    private void setName(XSLTParser xSLTParser, String string) {
        this.m_name = string;
        this.m_expandedName = this.getExpandedQName(xSLTParser, string);
        if (!XMLChar.isValidQName(string)) {
            ASTMsg aSTMsg = new ASTMsg("CHARACTER_MAP_NAME_NOT_LEXICAL_QNAME", (Object)string, (Expr)this);
            xSLTParser.reportError(3, aSTMsg);
            return;
        }
        if (this.m_expandedName == null) {
            int n = string.indexOf(58);
            String string2 = string.substring(0, n);
            ASTMsg aSTMsg = new ASTMsg("CHARACTER_MAP_NAME_NO_URI", string, string2, this);
            xSLTParser.reportError(3, aSTMsg);
            return;
        }
    }

    private void setUseCharacterMaps(String string) {
        this.m_use_character_maps = string;
    }

    String getExpandedQname() {
        return this.m_expandedName;
    }

    String getLexicalQName() {
        return this.m_name;
    }

    public short getExprType() {
        return 0;
    }
}

