/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.util;

import com.ibm.xml.xlxp.scan.util.DataBuffer;
import com.ibm.xml.xlxp.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.scan.util.DataBufferReferrer;

public class SimpleDataBufferFactory
implements DataBufferFactory {
    private static final boolean DEBUG = false;
    private DataBuffer fFreeBuffers;
    private DataBufferReferrerQueue fReferrers = new DataBufferReferrerQueue();
    private DataBufferActiveQueue fActiveBuffers = new DataBufferActiveQueue();
    private int activeCount;
    private static int fgIdCounter;

    public DataBuffer createBuffer() {
        DataBuffer dataBuffer = this.fFreeBuffers;
        if (dataBuffer != null) {
            this.fFreeBuffers = dataBuffer.next;
            dataBuffer.next = null;
            dataBuffer.columnNumber = 1;
            dataBuffer.lineNumber = 1;
            dataBuffer.byteOffset = -1;
            dataBuffer.startPosIncrement = 0;
        } else {
            dataBuffer = new DataBuffer(this);
            dataBuffer.id = ++fgIdCounter;
        }
        this.fActiveBuffers.add(dataBuffer);
        ++this.activeCount;
        return dataBuffer;
    }

    public void freeBuffer(DataBuffer dataBuffer) {
        this.fActiveBuffers.remove(dataBuffer);
        --this.activeCount;
        dataBuffer.next = this.fFreeBuffers;
        this.fFreeBuffers = dataBuffer;
    }

    public void addReferrer(DataBufferReferrer dataBufferReferrer) {
        this.fReferrers.add(dataBufferReferrer);
    }

    public void removeReferrer(DataBufferReferrer dataBufferReferrer) {
        this.fReferrers.remove(dataBufferReferrer);
    }

    public boolean isReferenced(DataBuffer dataBuffer) {
        return this.fReferrers.isReferenced(dataBuffer);
    }

    public void reset(boolean bl) {
        this.reclaimBuffers(0);
        if (!bl) {
            this.fFreeBuffers = null;
        }
    }

    public void reclaimBuffers(int n) {
        if (this.activeCount < n) {
            return;
        }
        DataBuffer dataBuffer = this.fActiveBuffers.first();
        while (dataBuffer != null) {
            if (!this.fReferrers.isReferenced(dataBuffer)) {
                if (dataBuffer.activePrev.next == dataBuffer) {
                    dataBuffer.activePrev.next = null;
                }
                DataBuffer dataBuffer2 = this.fActiveBuffers.remove(dataBuffer);
                --this.activeCount;
                dataBuffer.next = this.fFreeBuffers;
                this.fFreeBuffers = dataBuffer;
                dataBuffer = dataBuffer2;
                continue;
            }
            dataBuffer = this.fActiveBuffers.next(dataBuffer);
        }
    }

    class DataBufferActiveQueue {
        DataBuffer head;

        DataBufferActiveQueue() {
            this.head.activePrev = this.head.activeNext = (this.head = new DataBuffer(SimpleDataBufferFactory.this));
        }

        void add(DataBuffer dataBuffer) {
            DataBuffer dataBuffer2 = this.head.activePrev;
            dataBuffer.activeNext = dataBuffer2.activeNext;
            dataBuffer.activePrev = dataBuffer2;
            dataBuffer2.activeNext = dataBuffer;
            this.head.activePrev = dataBuffer;
        }

        DataBuffer remove(DataBuffer dataBuffer) {
            DataBuffer dataBuffer2;
            dataBuffer.activePrev.activeNext = dataBuffer2 = dataBuffer.activeNext;
            dataBuffer2.activePrev = dataBuffer.activePrev;
            dataBuffer.activeNext = null;
            dataBuffer.activePrev = null;
            return dataBuffer2 != this.head ? dataBuffer2 : null;
        }

        DataBuffer first() {
            return this.head.activeNext != this.head ? this.head.activeNext : null;
        }

        DataBuffer next(DataBuffer dataBuffer) {
            return dataBuffer.activeNext != this.head ? dataBuffer.activeNext : null;
        }
    }

    class DataBufferReferrerQueue {
        DataBufferReferrer head;

        DataBufferReferrerQueue() {
            this.head.prev = this.head.next = (this.head = new DataBufferReferrer(this){
                private final /* synthetic */ DataBufferReferrerQueue this$1;
                {
                    this.this$1 = dataBufferReferrerQueue;
                }

                public boolean hasReferenceTo(DataBuffer dataBuffer) {
                    return false;
                }
            });
        }

        boolean isReferenced(DataBuffer dataBuffer) {
            DataBufferReferrer dataBufferReferrer = this.head.next;
            boolean bl = false;
            while (dataBufferReferrer != this.head) {
                if (dataBufferReferrer.active && dataBufferReferrer.hasReferenceTo(dataBuffer)) {
                    ++dataBufferReferrer.hits;
                    if (dataBufferReferrer != this.head.next && dataBufferReferrer.hits > dataBufferReferrer.prev.hits) {
                        this.moveToFront(dataBufferReferrer);
                    }
                    return true;
                }
                dataBufferReferrer = dataBufferReferrer.next;
            }
            return false;
        }

        void moveToFront(DataBufferReferrer dataBufferReferrer) {
            DataBufferReferrer dataBufferReferrer2;
            this.remove(dataBufferReferrer);
            dataBufferReferrer.next = dataBufferReferrer2 = this.head.next;
            dataBufferReferrer.prev = this.head;
            dataBufferReferrer2.prev = dataBufferReferrer;
            this.head.next = dataBufferReferrer;
        }

        void add(DataBufferReferrer dataBufferReferrer) {
            DataBufferReferrer dataBufferReferrer2 = this.head.prev;
            dataBufferReferrer.next = this.head;
            dataBufferReferrer.prev = dataBufferReferrer2;
            dataBufferReferrer2.next = dataBufferReferrer;
            this.head.prev = dataBufferReferrer;
        }

        void remove(DataBufferReferrer dataBufferReferrer) {
            dataBufferReferrer.prev.next = dataBufferReferrer.next;
            dataBufferReferrer.next.prev = dataBufferReferrer.prev;
            dataBufferReferrer.next = null;
            dataBufferReferrer.prev = null;
        }
    }
}

