/*
 * Decompiled with CFR 0.152.
 */
package xlxp.samples.val.xs;

import com.ibm.xml.xlxp2.api.sax.impl.SAX2ParsedEntityFactory;
import com.ibm.xml.xlxp2.converter.Converter;
import com.ibm.xml.xlxp2.converter.DVFactory;
import com.ibm.xml.xlxp2.grammar.Grammar;
import com.ibm.xml.xlxp2.runtime.VMContext;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.DTDScanner;
import com.ibm.xml.xlxp2.scan.msg.MessageProvider;
import com.ibm.xml.xlxp2.scan.msg.MessageProviderRegistry;
import com.ibm.xml.xlxp2.scan.util.DTDGrammar;
import com.ibm.xml.xlxp2.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import com.ibm.xml.xlxp2.scan.util.SimpleDataBufferFactory;
import com.ibm.xml.xlxp2.scan.util.SymbolTable;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import com.ibm.xml.xlxp2.scan.util.XMLTracer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import org.apache.xerces.impl.xs.util.XSGrammarPool;
import org.apache.xerces.parsers.XMLGrammarPreparser;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.apache.xerces.xs.XSModel;
import org.xml.sax.InputSource;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class ParserBase {
    protected static boolean VALIDATION = true;
    protected static boolean SOAP = false;
    protected static boolean DEBUG = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            try {
                return Boolean.getBoolean("debug.trace");
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
    });
    protected static boolean schemaErr;
    private static final String GRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    private static final String FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    protected DataBufferFactory fBufferFactory = new SimpleDataBufferFactory();
    protected final SymbolTable fSymbolTable = new SymbolTable();
    protected final SAX2ParsedEntityFactory fEntityFactory;
    protected ParsedEntity fDocumentEntity;
    protected XMLTracer fXMLTracer;
    protected final boolean fEnableTracing;
    protected final VMContext fContext;
    protected Grammar fIR;
    protected int validationDepth;
    protected boolean fNeedReset;
    protected final boolean fLocalSymbol;
    private final DTDScanner fDTDScanner;

    public ParserBase() {
        this(true, true);
    }

    protected ParserBase(boolean bl, boolean bl2) {
        this.fLocalSymbol = bl;
        this.fContext = this.createVMContext(bl2);
        this.fEnableTracing = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    return Boolean.getBoolean("xlxp.samples.val.xs.ParserBase.enableTracing");
                }
                catch (SecurityException securityException) {
                    return false;
                }
            }
        });
        if (this.fEnableTracing) {
            this.fXMLTracer = new XMLTracer(System.err);
        }
        this.fEntityFactory = new SAX2ParsedEntityFactory(this.fBufferFactory);
        this.fDTDScanner = new DTDScanner(this.fContext, this.fSymbolTable, this.fEntityFactory){

            protected void setGrammar(DTDGrammar dTDGrammar) {
                super.setGrammar(dTDGrammar);
                if (ParserBase.this.fContext.validating) {
                    ParserBase.this.fContext.setEntityDeclPool(dTDGrammar.getEntityDeclPool());
                }
            }
        };
        this.fContext.setDTDSupport(this.fDTDScanner);
        this.fNeedReset = false;
    }

    protected void reset(boolean bl) {
        this.fEntityFactory.reset(bl);
        this.fContext.reset(bl);
        this.fDTDScanner.reset(bl);
        if (this.fLocalSymbol) {
            this.fSymbolTable.reset(bl);
        }
        this.fBufferFactory.reset(bl);
    }

    protected VMContext createVMContext(boolean bl) {
        return new ParserBaseVMScannerHelper(this.fBufferFactory, this.fSymbolTable, false, true, bl);
    }

    protected void printWarning(String string, int n, int n2, XMLString[] xMLStringArray, long l) {
        String string2 = "[WARNING]: " + this.generateErrorMessage(string, n, n2, xMLStringArray);
        System.err.println(string2);
    }

    protected void printRecoverableError(String string, int n, int n2, XMLString[] xMLStringArray, long l) {
        String string2 = "[ERROR]: " + this.generateErrorMessage(string, n, n2, xMLStringArray);
        System.err.println(string2);
    }

    protected void printFatalError(String string, int n, int n2, XMLString[] xMLStringArray, long l) {
        String string2 = "[FATAL]: " + this.generateErrorMessage(string, n, n2, xMLStringArray);
        System.err.println(string2);
        throw new RuntimeException(string2);
    }

    protected String generateErrorMessage(String string, int n, int n2, XMLString[] xMLStringArray) {
        MessageProvider messageProvider = MessageProviderRegistry.getMessageProvider(string);
        return messageProvider.createMessage(null, n, xMLStringArray);
    }

    protected void parseXML(InputSource inputSource) {
        this.validationDepth = -1;
        if (this.fNeedReset) {
            this.reset(true);
        }
        this.fNeedReset = true;
        this.fDocumentEntity = this.fEntityFactory.createParsedEntity(inputSource);
        this.fContext.parseDocumentEntity(this.fDocumentEntity);
    }

    protected void loadGrammar(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        if (DEBUG) {
            System.err.print("Before loading XSModel: ");
            System.gc();
            System.err.print((double)(System.currentTimeMillis() - l) / 1000.0 + " secs, ");
            System.err.println(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory() + " bytes of memory.");
        }
        XSModel xSModel = this.loadXSModel(stringArray);
        if (DEBUG) {
            System.err.print("After loading XSModel: ");
            System.gc();
            System.err.print((double)(System.currentTimeMillis() - l) / 1000.0 + " secs, ");
            System.err.println(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory() + " bytes of memory.");
        }
        if (xSModel == null) {
            throw new Exception("No Grammar found!");
        }
        Converter converter = new Converter(VALIDATION);
        this.fIR = converter.convert(xSModel, DVFactory.forVersion((short)0), null, null);
        if (!SOAP) {
            this.fContext.setIR(this.fIR);
        }
        if (DEBUG) {
            System.err.print("After converting/loading the grammar: ");
            System.gc();
            System.err.print((double)(System.currentTimeMillis() - l) / 1000.0 + " secs, ");
            System.err.println(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory() + " bytes of memory.");
        }
    }

    protected void loadGrammar(String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        this.loadGrammar(stringArray);
    }

    protected XSModel loadXSModel(String[] stringArray) {
        XMLGrammarPreparser xMLGrammarPreparser = new XMLGrammarPreparser();
        xMLGrammarPreparser.registerPreparser("http://www.w3.org/2001/XMLSchema", null);
        xMLGrammarPreparser.setFeature(FULL_CHECKING, true);
        xMLGrammarPreparser.setErrorHandler(this.createXercesErrorHandler());
        XSGrammarPool xSGrammarPool = new XSGrammarPool();
        xMLGrammarPreparser.setProperty(GRAMMAR_POOL, (Object)xSGrammarPool);
        XMLInputSource xMLInputSource = new XMLInputSource(null, null, null);
        for (int i = 0; i < stringArray.length; ++i) {
            xMLInputSource.setSystemId(stringArray[i]);
            ByteArrayInputStream byteArrayInputStream = ParserBase.getByteArrayInputStream(stringArray[i]);
            if (byteArrayInputStream != null) {
                xMLInputSource.setByteStream((InputStream)byteArrayInputStream);
            }
            try {
                xMLGrammarPreparser.preparseGrammar("http://www.w3.org/2001/XMLSchema", xMLInputSource);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return xSGrammarPool.toXSModel();
    }

    protected XMLErrorHandler createXercesErrorHandler() {
        return new XMLErrorHandler(){

            public void warning(String string, String string2, XMLParseException xMLParseException) {
            }

            public void error(String string, String string2, XMLParseException xMLParseException) {
                System.err.println("#ERROR: Invalid schema: " + string2);
                schemaErr = true;
            }

            public void fatalError(String string, String string2, XMLParseException xMLParseException) {
                schemaErr = true;
                throw new RuntimeException("Invalid schema: " + string2);
            }
        };
    }

    public static void main(String[] stringArray) {
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        if (n3 < stringArray.length && stringArray[n3].equals("-v")) {
            VALIDATION = true;
            ++n3;
        } else if (n3 < stringArray.length && stringArray[n3].equals("-V")) {
            VALIDATION = false;
            ++n3;
        }
        if (n3 < stringArray.length && stringArray[n3].equals("-soap")) {
            SOAP = true;
            ++n3;
        }
        if (n3 < stringArray.length && stringArray[n3].equals("-c")) {
            if (++n3 == stringArray.length) {
                ParserBase.printUsage();
                System.exit(1);
            }
            n = Integer.parseInt(stringArray[n3]);
            ++n3;
        }
        if (n3 < stringArray.length && stringArray[n3].equals("-w")) {
            if (++n3 == stringArray.length) {
                ParserBase.printUsage();
                System.exit(1);
            }
            n2 = Integer.parseInt(stringArray[n3]);
            ++n3;
        }
        if (n3 + 2 > stringArray.length) {
            ParserBase.printUsage();
            System.exit(1);
        }
        String[] stringArray2 = new String[stringArray.length - n3 - 1];
        System.arraycopy(stringArray, n3, stringArray2, 0, stringArray.length - n3 - 1);
        String string = stringArray[stringArray.length - 1];
        try {
            ByteArrayInputStream byteArrayInputStream;
            ParserBase parserBase = new ParserBase();
            parserBase.loadGrammar(stringArray2);
            InputSource inputSource = new InputSource(string);
            boolean bl = false;
            if (n2 > 0 && (byteArrayInputStream = ParserBase.getByteArrayInputStream(string)) != null) {
                inputSource.setByteStream(byteArrayInputStream);
                bl = true;
            }
            parserBase.prepare(inputSource, n2, bl);
            long l = System.currentTimeMillis();
            parserBase.parse(inputSource, n, bl);
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            ParserBase.printResults(string, l3, n);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    protected static ByteArrayInputStream getByteArrayInputStream(String string) {
        byte[] byArray = new byte[100000];
        try {
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            int n = inputStream.read(byArray);
            inputStream.close();
            if (n == 100000) {
                return null;
            }
            return new ByteArrayInputStream(byArray, 0, n);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void prepare(InputSource inputSource, int n, boolean bl) throws Exception {
        for (int i = 0; i < n; ++i) {
            this.parseXML(inputSource);
            if (!bl) continue;
            inputSource.getByteStream().reset();
        }
    }

    protected void parse(InputSource inputSource, int n, boolean bl) throws Exception {
        for (int i = 0; i < n; ++i) {
            this.parseXML(inputSource);
            if (!bl) continue;
            inputSource.getByteStream().reset();
        }
    }

    private static void printUsage() {
        System.err.println("usage: java xlxp.samples.val.xs.ParserBase (options) <xsds> <xml>");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -v          Perform schema validation.");
        System.err.println("  -V          Do not perform schema validation.");
        System.err.println("  -soap       Start schema validation only for recognizable elements.");
        System.err.println("  -c number   Select number of repetitions.");
        System.err.println("  -w number   Select number of warmup repetitions.");
        System.err.println();
        System.err.println("defaults:");
        System.err.println("  validation: true");
        System.err.println("  soap: false");
        System.err.println("  repetition: 1");
        System.err.println("  warmup:     0");
        System.err.println();
        System.err.println("Note:");
        System.err.println("- If there are warmup runs and the file size is less than 100KB, the input is read from an byte input stream.");
    }

    protected static void printResults(String string, double d, int n) {
        PrintWriter printWriter = new PrintWriter(System.out);
        printWriter.print(string);
        printWriter.print(": ");
        printWriter.print(d / (double)n);
        printWriter.print(" ms");
        printWriter.print("; ");
        printWriter.print(n);
        printWriter.print(" parses.");
        printWriter.println();
        printWriter.flush();
    }

    public class ParserBaseVMScannerHelper
    extends VMContext {
        public ParserBaseVMScannerHelper(DataBufferFactory dataBufferFactory, SymbolTable symbolTable, boolean bl, boolean bl2, boolean bl3) {
            super(dataBufferFactory, symbolTable, bl, bl2, VALIDATION, bl3, true);
        }

        public boolean produceWarningEvent() {
            boolean bl = super.produceWarningEvent();
            ParserBase.this.printWarning(this.errorURI, this.errorCode, this.errorParamsCount, this.errorParamStrings, this.errorOffset);
            return bl;
        }

        public boolean produceRecoverableErrorEvent() {
            boolean bl = super.produceRecoverableErrorEvent();
            ParserBase.this.printRecoverableError(this.errorURI, this.errorCode, this.errorParamsCount, this.errorParamStrings, this.errorOffset);
            return bl;
        }

        public boolean produceFatalErrorEvent() {
            boolean bl = super.produceFatalErrorEvent();
            ParserBase.this.printFatalError(this.errorURI, this.errorCode, this.errorParamsCount, this.errorParamStrings, this.errorOffset);
            return bl;
        }

        public boolean produceLeafElementEvent() {
            boolean bl = super.produceLeafElementEvent();
            if (!SOAP) {
                return bl;
            }
            if (ParserBase.this.validationDepth == -1 && ParserBase.this.fIR.root.elements != null && ParserBaseVMScannerHelper.findQNameInChoices(ParserBase.this.fIR.root.elements, ParserBase.this.fIR.root.elementTable, this.elementType) >= 0) {
                this.startSchemaAssessment(ParserBase.this.fIR);
                this.stopSchemaAssessment();
            }
            return bl;
        }

        public boolean produceStartElementEvent() {
            boolean bl = super.produceStartElementEvent();
            if (!SOAP) {
                return bl;
            }
            if (ParserBase.this.validationDepth == -1) {
                if (ParserBase.this.fIR.root.elements != null && ParserBaseVMScannerHelper.findQNameInChoices(ParserBase.this.fIR.root.elements, ParserBase.this.fIR.root.elementTable, this.elementType) >= 0) {
                    this.startSchemaAssessment(ParserBase.this.fIR);
                    ParserBase.this.validationDepth = 1;
                }
            } else {
                ++ParserBase.this.validationDepth;
            }
            return bl;
        }

        public boolean produceEndElementEvent() {
            boolean bl = super.produceEndElementEvent();
            if (!SOAP) {
                return bl;
            }
            if (ParserBase.this.validationDepth >= 0 && --ParserBase.this.validationDepth == 0) {
                this.stopSchemaAssessment();
            }
            return bl;
        }
    }
}

