/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.Permission;
import java.util.HashMap;

public final class EJBMethodPermission
extends Permission
implements Serializable {
    private static final String[] interfaceKeys = new String[]{"Local", "LocalHome", "Remote", "Home", "ServiceEndpoint"};
    private static HashMap interfaceHash = new HashMap();
    private transient int methodInterface;
    private transient String otherMethodInterface = null;
    private transient String methodName;
    private transient String methodParams;
    private transient String actions;
    private transient int hashCodeValue = 0;
    private static final long serialVersionUID = 1L;
    private static final ObjectStreamField[] serialPersistentFields;

    public EJBMethodPermission(String name2, String actions) {
        super(name2);
        this.setMethodSpec(actions);
    }

    public EJBMethodPermission(String EJBName, String methodName, String methodInterface, String[] methodParams) {
        super(EJBName);
        this.setMethodSpec(methodName, methodInterface, methodParams);
    }

    public EJBMethodPermission(String EJBName, String methodInterface, Method method) {
        super(EJBName);
        this.setMethodSpec(methodInterface, method);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof EJBMethodPermission)) {
            return false;
        }
        EJBMethodPermission that = (EJBMethodPermission)o;
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        if (this.methodName != null ? that.methodName == null || !this.methodName.equals(that.methodName) : that.methodName != null) {
            return false;
        }
        if (this.methodInterface != that.methodInterface) {
            return false;
        }
        if (this.methodInterface == -2 && !this.otherMethodInterface.equals(that.otherMethodInterface)) {
            return false;
        }
        return !(this.methodParams != null ? that.methodParams == null || !this.methodParams.equals(that.methodParams) : that.methodParams != null);
    }

    public String getActions() {
        if (this.actions == null) {
            String iSpec;
            String string = this.methodInterface == -1 ? null : (iSpec = this.methodInterface < 0 ? this.otherMethodInterface : interfaceKeys[this.methodInterface]);
            if (this.methodName == null) {
                if (iSpec == null) {
                    if (this.methodParams != null) {
                        this.actions = "," + this.methodParams;
                    }
                } else {
                    this.actions = this.methodParams == null ? "," + iSpec : "," + iSpec + this.methodParams;
                }
            } else {
                this.actions = iSpec == null ? (this.methodParams == null ? this.methodName : this.methodName + "," + this.methodParams) : (this.methodParams == null ? this.methodName + "," + iSpec : this.methodName + "," + iSpec + this.methodParams);
            }
        }
        return this.actions;
    }

    public int hashCode() {
        if (this.hashCodeValue == 0) {
            String actions = this.getActions();
            String hashInput = actions == null ? this.getName() : new String(this.getName() + " " + actions);
            this.hashCodeValue = hashInput.hashCode();
        }
        return this.hashCodeValue;
    }

    public boolean implies(Permission permission) {
        if (permission == null || !(permission instanceof EJBMethodPermission)) {
            return false;
        }
        EJBMethodPermission that = (EJBMethodPermission)permission;
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        if (!(this.methodName == null || that.methodName != null && this.methodName.equals(that.methodName))) {
            return false;
        }
        if (this.methodInterface != -1 && (that.methodInterface == -1 || this.methodInterface != that.methodInterface)) {
            return false;
        }
        if (this.methodInterface == -2 && !this.otherMethodInterface.equals(that.otherMethodInterface)) {
            return false;
        }
        return this.methodParams == null || that.methodParams != null && this.methodParams.equals(that.methodParams);
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.setMethodSpec((String)s.readFields().get("actions", null));
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.putFields().put("actions", this.getActions());
        s.writeFields();
    }

    private void setMethodSpec(String actions) {
        String mInterface = null;
        this.methodName = null;
        this.methodParams = null;
        if (actions != null) {
            if (actions.length() > 0) {
                int i = actions.indexOf(44);
                if (i < 0) {
                    this.methodName = actions;
                } else if (i >= 0) {
                    if (i != 0) {
                        this.methodName = actions.substring(0, i);
                    }
                    if (actions.length() == i + 1) {
                        throw new IllegalArgumentException("illegal actions spec");
                    }
                    int j = actions.substring(i + 1).indexOf(44);
                    if (j < 0) {
                        mInterface = actions.substring(i + 1);
                    } else {
                        if (j > 0) {
                            mInterface = actions.substring(i + 1, i + j + 1);
                        }
                        this.methodParams = actions.substring(i + j + 1);
                        if (this.methodParams.length() > 1 && this.methodParams.endsWith(",")) {
                            throw new IllegalArgumentException("illegal methodParam");
                        }
                    }
                }
            } else {
                actions = null;
            }
        }
        this.methodInterface = EJBMethodPermission.validateInterface(mInterface);
        if (this.methodInterface < -1) {
            this.otherMethodInterface = mInterface;
        }
        this.actions = actions;
    }

    private void setMethodSpec(String methodName, String mInterface, String[] methodParams) {
        if (methodName != null && methodName.indexOf(44) >= 0) {
            throw new IllegalArgumentException("illegal methodName");
        }
        this.methodInterface = EJBMethodPermission.validateInterface(mInterface);
        if (this.methodInterface < -1) {
            this.otherMethodInterface = mInterface;
        }
        if (methodParams != null) {
            StringBuffer mParams = new StringBuffer(",");
            for (int i = 0; i < methodParams.length; ++i) {
                if (methodParams[i] == null || methodParams[i].indexOf(44) >= 0) {
                    throw new IllegalArgumentException("illegal methodParam");
                }
                if (i == 0) {
                    mParams.append(methodParams[i]);
                    continue;
                }
                mParams.append("," + methodParams[i]);
            }
            this.methodParams = mParams.toString();
        } else {
            this.methodParams = null;
        }
        this.methodName = methodName;
    }

    private void setMethodSpec(String mInterface, Method method) {
        this.methodInterface = EJBMethodPermission.validateInterface(mInterface);
        if (this.methodInterface < -1) {
            this.otherMethodInterface = mInterface;
        }
        this.methodName = method.getName();
        Class<?>[] params = method.getParameterTypes();
        StringBuffer mParams = new StringBuffer(",");
        for (int i = 0; i < params.length; ++i) {
            String pname = params[i].getName();
            Class<?> compType = params[i].getComponentType();
            if (compType != null) {
                String brackets = "[]";
                while (compType.getComponentType() != null) {
                    compType = compType.getComponentType();
                    brackets = brackets + "[]";
                }
                pname = compType.getName() + brackets;
            }
            if (i == 0) {
                mParams.append(pname);
                continue;
            }
            mParams.append("," + pname);
        }
        this.methodParams = mParams.toString();
    }

    private static int validateInterface(String methodInterface) {
        int result = -1;
        if (methodInterface != null && methodInterface.length() > 0) {
            Integer i = (Integer)interfaceHash.get(methodInterface);
            result = i != null ? i : -2;
        }
        return result;
    }

    static {
        for (int i = 0; i < interfaceKeys.length; ++i) {
            interfaceHash.put(interfaceKeys[i], new Integer(i));
        }
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("actions", String.class)};
    }
}

