/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.mail.internet.HeaderTokenizer;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

public class ParameterList {
    private Map list = new LinkedHashMap();
    private static boolean encodeParameters = false;
    private static boolean decodeParameters = false;
    private static boolean decodeParametersStrict = false;
    private static final char[] hex;

    public ParameterList() {
    }

    public ParameterList(String string) throws ParseException {
        HeaderTokenizer.Token token;
        HeaderTokenizer headerTokenizer = new HeaderTokenizer(string, "()<>@,;:\\\"\t []/?=");
        while (true) {
            int n;
            if ((n = (token = headerTokenizer.next()).getType()) == -4) {
                return;
            }
            if ((char)n != ';') break;
            token = headerTokenizer.next();
            if (token.getType() == -4) {
                return;
            }
            if (token.getType() != -1) {
                throw new ParseException("Expected parameter name, got \"" + token.getValue() + "\"");
            }
            String string2 = token.getValue().toLowerCase();
            token = headerTokenizer.next();
            if ((char)token.getType() != '=') {
                throw new ParseException("Expected '=', got \"" + token.getValue() + "\"");
            }
            token = headerTokenizer.next();
            n = token.getType();
            if (n != -1 && n != -2) {
                throw new ParseException("Expected parameter value, got \"" + token.getValue() + "\"");
            }
            String string3 = token.getValue();
            if (decodeParameters && string2.endsWith("*")) {
                string2 = string2.substring(0, string2.length() - 1);
                this.list.put(string2, this.decodeValue(string3));
                continue;
            }
            this.list.put(string2, string3);
        }
        throw new ParseException("Expected ';', got \"" + token.getValue() + "\"");
    }

    public int size() {
        return this.list.size();
    }

    public String get(String string) {
        Object v = this.list.get(string.trim().toLowerCase());
        String string2 = v instanceof Value ? ((Value)v).value : (String)v;
        return string2;
    }

    public void set(String string, String string2) {
        this.list.put(string.trim().toLowerCase(), string2);
    }

    public void set(String string, String string2, String string3) {
        if (encodeParameters) {
            Value value2 = this.encodeValue(string2, string3);
            if (value2 != null) {
                this.list.put(string.trim().toLowerCase(), value2);
            } else {
                this.set(string, string2);
            }
        } else {
            this.set(string, string2);
        }
    }

    public void remove(String string) {
        this.list.remove(string.trim().toLowerCase());
    }

    public Enumeration getNames() {
        return new ParamEnum(this.list.keySet().iterator());
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.list.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = (String)iterator.next();
            Object v = this.list.get(string2);
            if (v instanceof Value) {
                string = ((Value)v).encodedValue;
                string2 = string2 + '*';
            } else {
                string = (String)v;
            }
            string = this.quote(string);
            stringBuffer.append("; ");
            int n2 = string2.length() + string.length() + 1;
            if ((n += 2) + n2 > 76) {
                stringBuffer.append("\r\n\t");
                n = 8;
            }
            stringBuffer.append(string2).append('=');
            if ((n += string2.length() + 1) + string.length() > 76) {
                String string3 = MimeUtility.fold(n, string);
                stringBuffer.append(string3);
                int n3 = string3.lastIndexOf(10);
                if (n3 >= 0) {
                    n += string3.length() - n3 - 1;
                    continue;
                }
                n += string3.length();
                continue;
            }
            stringBuffer.append(string);
            n += string.length();
        }
        return stringBuffer.toString();
    }

    private String quote(String string) {
        return MimeUtility.quote(string, "()<>@,;:\\\"\t []/?=");
    }

    private Value encodeValue(String string, String string2) {
        byte[] byArray;
        if (MimeUtility.checkAscii(string) == 1) {
            return null;
        }
        try {
            byArray = string.getBytes(MimeUtility.javaCharset(string2));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length + string2.length() + 2);
        stringBuffer.append(string2).append("''");
        int n = 0;
        while (n < byArray.length) {
            char c = (char)(byArray[n] & 0xFF);
            if (c <= ' ' || c >= '\u007f' || c == '*' || c == '\'' || c == '%' || "()<>@,;:\\\"\t []/?=".indexOf(c) >= 0) {
                stringBuffer.append('%').append(hex[c >> 4]).append(hex[c & 0xF]);
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        Value value2 = new Value();
        value2.value = string;
        value2.encodedValue = stringBuffer.toString();
        return value2;
    }

    private Value decodeValue(String string) throws ParseException {
        Value value2;
        block12: {
            value2 = new Value();
            value2.encodedValue = string;
            value2.value = string;
            try {
                int n = string.indexOf(39);
                if (n <= 0) {
                    if (decodeParametersStrict) {
                        throw new ParseException("Missing charset in encoded value: " + string);
                    }
                    return value2;
                }
                String string2 = string.substring(0, n);
                int n2 = string.indexOf(39, n + 1);
                if (n2 < 0) {
                    if (decodeParametersStrict) {
                        throw new ParseException("Missing language in encoded value: " + string);
                    }
                    return value2;
                }
                String string3 = string.substring(n + 1, n2);
                string = string.substring(n2 + 1);
                byte[] byArray = new byte[string.length()];
                n = 0;
                int n3 = 0;
                while (n < string.length()) {
                    char c = string.charAt(n);
                    if (c == '%') {
                        String string4 = string.substring(n + 1, n + 3);
                        c = (char)Integer.parseInt(string4, 16);
                        n += 2;
                    }
                    byArray[n3++] = (byte)c;
                    ++n;
                }
                value2.value = new String(byArray, 0, n3, MimeUtility.javaCharset(string2));
            }
            catch (NumberFormatException numberFormatException) {
                if (decodeParametersStrict) {
                    throw new ParseException(numberFormatException.toString());
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (decodeParametersStrict) {
                    throw new ParseException(unsupportedEncodingException.toString());
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                if (!decodeParametersStrict) break block12;
                throw new ParseException(stringIndexOutOfBoundsException.toString());
            }
        }
        return value2;
    }

    static {
        try {
            String string = System.getProperty("mail.mime.encodeparameters");
            encodeParameters = string != null && string.equalsIgnoreCase("true");
            string = System.getProperty("mail.mime.decodeparameters");
            decodeParameters = string != null && string.equalsIgnoreCase("true");
            string = System.getProperty("mail.mime.decodeparameters.strict");
            decodeParametersStrict = string != null && string.equalsIgnoreCase("true");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }

    private static class ParamEnum
    implements Enumeration {
        private Iterator it;

        ParamEnum(Iterator iterator) {
            this.it = iterator;
        }

        public boolean hasMoreElements() {
            return this.it.hasNext();
        }

        public Object nextElement() {
            return this.it.next();
        }
    }

    private static class Value {
        String value;
        String encodedValue;

        private Value() {
        }
    }
}

