/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.MessageFactory;

public class IntegerConverter
implements Converter {
    public static final String CONVERTER_ID = "javax.faces.Integer";
    public static final String INTEGER_ID = "javax.faces.converter.IntegerConverter.INTEGER";
    public static final String STRING_ID = "javax.faces.converter.STRING";

    @Override
    public Object getAsObject(FacesContext context, UIComponent component, String value2) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value2 == null) {
            return null;
        }
        if ((value2 = value2.trim()).length() < 1) {
            return null;
        }
        try {
            return Integer.valueOf(value2);
        }
        catch (NumberFormatException nfe) {
            throw new ConverterException(MessageFactory.getMessage(context, INTEGER_ID, value2, "9346", MessageFactory.getLabel(context, component)));
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
    }

    @Override
    public String getAsString(FacesContext context, UIComponent component, Object value2) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value2 == null) {
            return "";
        }
        if (value2 instanceof String) {
            return (String)value2;
        }
        try {
            return Integer.toString(((Number)value2).intValue());
        }
        catch (Exception e) {
            throw new ConverterException(MessageFactory.getMessage(context, STRING_ID, value2, MessageFactory.getLabel(context, component)), (Throwable)e);
        }
    }
}

