/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.MessageFactory;

public class DoubleConverter
implements Converter {
    public static final String CONVERTER_ID = "javax.faces.Double";
    public static final String DOUBLE_ID = "javax.faces.converter.DoubleConverter.DOUBLE";
    public static final String STRING_ID = "javax.faces.converter.STRING";

    @Override
    public Object getAsObject(FacesContext context, UIComponent component, String value2) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value2 == null) {
            return null;
        }
        if ((value2 = value2.trim()).length() < 1) {
            return null;
        }
        try {
            return Double.valueOf(value2);
        }
        catch (NumberFormatException nfe) {
            throw new ConverterException(MessageFactory.getMessage(context, DOUBLE_ID, value2, "1999999", MessageFactory.getLabel(context, component)));
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
    }

    @Override
    public String getAsString(FacesContext context, UIComponent component, Object value2) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value2 == null) {
            return "";
        }
        if (value2 instanceof String) {
            return (String)value2;
        }
        try {
            return Double.toString(((Number)value2).doubleValue());
        }
        catch (Exception e) {
            throw new ConverterException(MessageFactory.getMessage(context, STRING_ID, value2, MessageFactory.getLabel(context, component)), (Throwable)e);
        }
    }
}

