/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.MessageFactory;

public class DateTimeConverter
implements Converter,
StateHolder {
    public static final String CONVERTER_ID = "javax.faces.DateTime";
    public static final String DATE_ID = "javax.faces.converter.DateTimeConverter.DATE";
    public static final String TIME_ID = "javax.faces.converter.DateTimeConverter.TIME";
    public static final String DATETIME_ID = "javax.faces.converter.DateTimeConverter.DATETIME";
    public static final String STRING_ID = "javax.faces.converter.STRING";
    private static final TimeZone DEFAULT_TIME_ZONE = TimeZone.getTimeZone("GMT");
    private String dateStyle = "default";
    private Locale locale = null;
    private String pattern = null;
    private String timeStyle = "default";
    private TimeZone timeZone = DEFAULT_TIME_ZONE;
    private String type = "date";
    private boolean transientFlag = false;

    public String getDateStyle() {
        return this.dateStyle;
    }

    public void setDateStyle(String dateStyle) {
        this.dateStyle = dateStyle;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = this.getLocale(FacesContext.getCurrentInstance());
        }
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getTimeStyle() {
        return this.timeStyle;
    }

    public void setTimeStyle(String timeStyle) {
        this.timeStyle = timeStyle;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public Object getAsObject(FacesContext context, UIComponent component, String value2) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        Date returnValue = null;
        DateFormat parser = null;
        try {
            if (value2 == null) {
                return null;
            }
            if ((value2 = value2.trim()).length() < 1) {
                return null;
            }
            Locale locale = this.getLocale(context);
            parser = this.getDateFormat(locale);
            if (null != this.timeZone) {
                parser.setTimeZone(this.timeZone);
            }
            returnValue = parser.parse(value2);
        }
        catch (ParseException e) {
            if ("date".equals(this.type)) {
                throw new ConverterException(MessageFactory.getMessage(context, DATE_ID, value2, parser.format(new Date(System.currentTimeMillis())), MessageFactory.getLabel(context, component)));
            }
            if ("time".equals(this.type)) {
                throw new ConverterException(MessageFactory.getMessage(context, TIME_ID, value2, parser.format(new Date(System.currentTimeMillis())), MessageFactory.getLabel(context, component)));
            }
            if ("both".equals(this.type)) {
                throw new ConverterException(MessageFactory.getMessage(context, DATETIME_ID, value2, parser.format(new Date(System.currentTimeMillis())), MessageFactory.getLabel(context, component)));
            }
        }
        catch (ConverterException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
        return returnValue;
    }

    @Override
    public String getAsString(FacesContext context, UIComponent component, Object value2) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        try {
            if (value2 == null) {
                return "";
            }
            if (value2 instanceof String) {
                return (String)value2;
            }
            Locale locale = this.getLocale(context);
            DateFormat formatter = this.getDateFormat(locale);
            if (null != this.timeZone) {
                formatter.setTimeZone(this.timeZone);
            }
            return formatter.format(value2);
        }
        catch (ConverterException e) {
            throw new ConverterException(MessageFactory.getMessage(context, STRING_ID, value2, MessageFactory.getLabel(context, component)), (Throwable)e);
        }
        catch (Exception e) {
            throw new ConverterException(MessageFactory.getMessage(context, STRING_ID, value2, MessageFactory.getLabel(context, component)), (Throwable)e);
        }
    }

    private DateFormat getDateFormat(Locale locale) {
        DateFormat df;
        if (this.pattern == null && this.type == null) {
            throw new IllegalArgumentException("Either pattern or type must be specified.");
        }
        if (this.pattern != null) {
            df = new SimpleDateFormat(this.pattern, locale);
        } else if (this.type.equals("both")) {
            df = DateFormat.getDateTimeInstance(DateTimeConverter.getStyle(this.dateStyle), DateTimeConverter.getStyle(this.timeStyle), locale);
        } else if (this.type.equals("date")) {
            df = DateFormat.getDateInstance(DateTimeConverter.getStyle(this.dateStyle), locale);
        } else if (this.type.equals("time")) {
            df = DateFormat.getTimeInstance(DateTimeConverter.getStyle(this.timeStyle), locale);
        } else {
            throw new IllegalArgumentException("Invalid type: " + this.type);
        }
        df.setLenient(false);
        return df;
    }

    private Locale getLocale(FacesContext context) {
        Locale locale = this.locale;
        if (locale == null) {
            locale = context.getViewRoot().getLocale();
        }
        return locale;
    }

    private static int getStyle(String name2) {
        if ("default".equals(name2)) {
            return 2;
        }
        if ("short".equals(name2)) {
            return 3;
        }
        if ("medium".equals(name2)) {
            return 2;
        }
        if ("long".equals(name2)) {
            return 1;
        }
        if ("full".equals(name2)) {
            return 0;
        }
        throw new ConverterException("Invalid style '" + name2 + '\'');
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.dateStyle, this.locale, this.pattern, this.timeStyle, this.timeZone, this.type};
        return values;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.dateStyle = (String)values[0];
        this.locale = (Locale)values[1];
        this.pattern = (String)values[2];
        this.timeStyle = (String)values[3];
        this.timeZone = (TimeZone)values[4];
        this.type = (String)values[5];
    }

    @Override
    public boolean isTransient() {
        return this.transientFlag;
    }

    @Override
    public void setTransient(boolean transientFlag) {
        this.transientFlag = transientFlag;
    }
}

